/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.refactoring.AutoValue_SuggestedFix_MatchedNodeInfo;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.Matchers;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.RefactoringUtils;
import com.google.javascript.refactoring.RequireAliasGenerator;
import com.google.javascript.refactoring.ScriptMetadata;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NonJSDocComment;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class SuggestedFix {
    private final MatchedNodeInfo matchedNodeInfo;
    private final SetMultimap<String, CodeReplacement> replacements;
    @Nullable
    private final String description;
    private final ImmutableList<SuggestedFix> alternatives;

    private SuggestedFix(MatchedNodeInfo matchedNodeInfo, SetMultimap<String, CodeReplacement> replacements, @Nullable String description, ImmutableList<SuggestedFix> alternatives) {
        this.matchedNodeInfo = matchedNodeInfo;
        this.replacements = replacements;
        this.description = description;
        this.alternatives = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this)).addAll(alternatives)).build();
    }

    public MatchedNodeInfo getMatchedNodeInfo() {
        return this.matchedNodeInfo;
    }

    public SetMultimap<String, CodeReplacement> getReplacements() {
        return this.replacements;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ImmutableList<SuggestedFix> getAlternatives() {
        return this.alternatives;
    }

    public ImmutableList<SuggestedFix> getNonDefaultAlternatives() {
        return this.alternatives.subList(1, this.alternatives.size());
    }

    boolean isNoOp() {
        return this.replacements.isEmpty();
    }

    public String toString() {
        if (this.isNoOp()) {
            return "<no-op SuggestedFix>";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Collection<CodeReplacement>> entry : this.replacements.asMap().entrySet()) {
            sb.append("Replacements for file: ").append(entry.getKey()).append("\n");
            Joiner.on("\n\n").appendTo(sb, (Iterable)entry.getValue());
        }
        return sb.toString();
    }

    private static int getStartPositionForNodeConsideringComments(Node node) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(node);
        NonJSDocComment associatedNonJSDocComment = node.getNonJSDocComment();
        int start = node.getSourceOffset();
        if (jsdoc != null) {
            start = jsdoc.getOriginalCommentPosition();
        }
        if (associatedNonJSDocComment != null) {
            start = Math.min(start, associatedNonJSDocComment.getStartPosition().getOffset());
        }
        return start;
    }

    @AutoValue
    public static abstract class MatchedNodeInfo {
        static MatchedNodeInfo create(Node node, boolean closurized) {
            return new AutoValue_SuggestedFix_MatchedNodeInfo(NodeUtil.getSourceName(node), node.getLineno(), node.getCharno(), closurized);
        }

        public abstract String getSourceFilename();

        public abstract int getLineno();

        public abstract int getCharno();

        public abstract boolean isInClosurizedFile();
    }

    public static final class Builder {
        private MatchedNodeInfo matchedNodeInfo = null;
        private final ImmutableSetMultimap.Builder<String, CodeReplacement> replacements = ImmutableSetMultimap.builder();
        private final ImmutableList.Builder<SuggestedFix> alternatives = ImmutableList.builder();
        private String description = null;

        public Builder attachMatchedNodeInfo(Node node, AbstractCompiler compiler) {
            this.matchedNodeInfo = MatchedNodeInfo.create(node, RefactoringUtils.isInClosurizedFile(node, new NodeMetadata(compiler)));
            return this;
        }

        public Builder addAlternative(SuggestedFix alternative) {
            Preconditions.checkState(alternative.getNonDefaultAlternatives().isEmpty(), "Alternative SuggestedFix must have no alternatives of their own.");
            this.alternatives.add((Object)alternative);
            return this;
        }

        Builder replaceText(Node node, int length, String newContent) {
            int startPosition = node.getSourceOffset();
            this.replacements.put((Object)node.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, newContent));
            return this;
        }

        public Builder addChildToFront(Node parentNode, String content) {
            Preconditions.checkState(parentNode.isBlock(), "addChildToFront is only supported for BLOCK statements.");
            int startPosition = parentNode.getSourceOffset() + 1;
            this.replacements.put((Object)parentNode.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, "\n" + content));
            return this;
        }

        public Builder insertAfter(Node node, String text) {
            int position = node.getSourceOffset() + node.getLength();
            this.replacements.put((Object)node.getSourceFileName(), (Object)CodeReplacement.create(position, 0, text));
            return this;
        }

        public Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler) {
            return this.insertBefore(nodeToInsertBefore, n, compiler, "");
        }

        Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler, String sortKey) {
            return this.insertBefore(nodeToInsertBefore, this.generateCode(compiler, n), sortKey);
        }

        public Builder insertBefore(Node nodeToInsertBefore, String content) {
            return this.insertBefore(nodeToInsertBefore, content, "");
        }

        private Builder insertBefore(Node nodeToInsertBefore, String content, String sortKey) {
            int startPosition = SuggestedFix.getStartPositionForNodeConsideringComments(nodeToInsertBefore);
            Preconditions.checkNotNull(nodeToInsertBefore.getSourceFileName(), "No source file name for node: %s", (Object)nodeToInsertBefore);
            this.replacements.put((Object)nodeToInsertBefore.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, content, sortKey));
            return this;
        }

        public Builder delete(Node n) {
            return this.delete(n, true);
        }

        private Builder delete(Node n, boolean deleteWhitespaceBefore) {
            Node previousSibling;
            int startPosition = SuggestedFix.getStartPositionForNodeConsideringComments(n);
            int startOffsetWithoutComments = n.getSourceOffset();
            int length = startOffsetWithoutComments - startPosition + n.getLength();
            if (n.getNext() != null && NodeUtil.getBestJSDocInfo(n.getNext()) == null && n.getNext().getNonJSDocComment() == null) {
                length = n.getNext().getSourceOffset() - startPosition;
            }
            if (n.isName() && NodeUtil.isNameDeclaration(n.getParent()) || n.isStringKey()) {
                if (n.getNext() != null) {
                    length = SuggestedFix.getStartPositionForNodeConsideringComments(n.getNext()) - startPosition;
                } else if (n.hasChildren()) {
                    Node child = n.getFirstChild();
                    length = child.getSourceOffset() + child.getLength() - startPosition;
                }
                if (n.getParent().getLastChild() == n && n != n.getParent().getFirstChild()) {
                    Node previousSibling2 = n.getPrevious();
                    if (previousSibling2.hasChildren()) {
                        Node child = previousSibling2.getFirstChild();
                        int startPositionDiff = startPosition - (child.getSourceOffset() + child.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    } else {
                        int startPositionDiff = startPosition - (previousSibling2.getSourceOffset() + previousSibling2.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    }
                }
            }
            Node parent = n.getParent();
            if (deleteWhitespaceBefore && parent != null && (parent.isScript() || parent.isBlock()) && (previousSibling = n.getPrevious()) != null) {
                int previousSiblingEndPosition = previousSibling.getSourceOffset() + previousSibling.getLength();
                length += startPosition - previousSiblingEndPosition;
                startPosition = previousSiblingEndPosition;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, ""));
            return this;
        }

        public Builder deleteWithoutRemovingWhitespaceBefore(Node n) {
            return this.delete(n, false);
        }

        public Builder deleteWithoutRemovingWhitespace(Node n) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset(), n.getLength(), ""));
            return this;
        }

        public Builder rename(Node n, String name) {
            return this.rename(n, name, false);
        }

        public Builder rename(Node n, String name, boolean replaceEntireName) {
            Node nodeToRename = null;
            if (n.isCall() || n.isTaggedTemplateLit()) {
                Node child;
                nodeToRename = child = n.getFirstChild();
                if (!replaceEntireName && child.isGetProp()) {
                    nodeToRename = child.getLastChild();
                }
            } else if (n.isGetProp()) {
                nodeToRename = n.getLastChild();
                if (replaceEntireName) {
                    while (nodeToRename.getParent().isGetProp()) {
                        nodeToRename = nodeToRename.getParent();
                    }
                }
            } else if (n.isStringKey() || n.isName()) {
                nodeToRename = n;
            } else if (n.isString()) {
                Preconditions.checkState(n.getParent().isGetProp(), n);
                nodeToRename = n;
            } else {
                throw new UnsupportedOperationException("Rename is not implemented for this node type: " + n);
            }
            this.replacements.put((Object)nodeToRename.getSourceFileName(), (Object)CodeReplacement.create(nodeToRename.getSourceOffset(), nodeToRename.getLength(), name));
            return this;
        }

        public Builder replaceRange(Node first, Node last, String newContent) {
            Preconditions.checkState(first.getParent() == last.getParent());
            int start = SuggestedFix.getStartPositionForNodeConsideringComments(first);
            if (start == 0) {
                start = first.getSourceOffset();
            }
            int end = last.getSourceOffset() + last.getLength();
            int length = end - start;
            this.replacements.put((Object)first.getSourceFileName(), (Object)CodeReplacement.create(start, length, newContent));
            return this;
        }

        public Builder replace(Node original, Node newNode, AbstractCompiler compiler) {
            boolean needsSemicolon;
            String newCode;
            Node parent = original.getParent();
            if (parent != null && parent.isExprResult()) {
                original = parent;
            }
            if ((newCode = this.generateCode(compiler, newNode)).endsWith("\n")) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            boolean bl = needsSemicolon = parent != null && (parent.isExprResult() || parent.isBlock() || parent.isScript() || parent.isModuleBody());
            if (newCode.endsWith(";") && !needsSemicolon) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            if (parent != null && IR.mayBeExpression(parent)) {
                Node replacement = newNode;
                while ((replacement.isBlock() || replacement.isScript() || replacement.isModuleBody()) && replacement.hasOneChild()) {
                    replacement = replacement.getOnlyChild();
                }
                if (replacement.isExprResult()) {
                    replacement = replacement.getOnlyChild();
                }
                if (IR.mayBeExpression(replacement)) {
                    int outer = NodeUtil.precedence(parent.getToken());
                    int inner = NodeUtil.precedence(original.getToken());
                    int newInner = NodeUtil.precedence(replacement.getToken());
                    if (newInner < NodeUtil.precedence(Token.CALL) && newInner <= outer && inner >= outer) {
                        newCode = "(" + newCode + ")";
                    }
                }
            }
            this.replacements.put((Object)original.getSourceFileName(), (Object)CodeReplacement.create(original.getSourceOffset(), original.getLength(), newCode));
            return this;
        }

        public Builder addCast(Node n, AbstractCompiler compiler, String type) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset(), n.getLength(), "/** @type {" + type + "} */ (" + this.generateCode(compiler, n) + ")"));
            return this;
        }

        public Builder removeCast(Node n, AbstractCompiler compiler) {
            Preconditions.checkArgument(n.isCast());
            JSDocInfo jsDoc = n.getJSDocInfo();
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(jsDoc.getOriginalCommentPosition(), n.getFirstChild().getSourceOffset() - jsDoc.getOriginalCommentPosition(), ""));
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset() + n.getLength() - 1, 1, ""));
            return this;
        }

        public Builder addOrReplaceJsDoc(Node n, String newJsDoc) {
            int startPosition = n.getSourceOffset();
            int length = 0;
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
                length = jsDoc.getOriginalCommentString().length();
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, newJsDoc));
            return this;
        }

        public Builder changeJsDocType(Node n, AbstractCompiler compiler, String type) {
            Node typeNode = JsDocInfoParser.parseTypeString(type);
            Preconditions.checkNotNull(typeNode, "Invalid type: %s", (Object)type);
            JSTypeExpression typeExpr = new JSTypeExpression(typeNode, "jsflume");
            JSType newJsType = typeExpr.evaluate(null, compiler.getTypeRegistry());
            if (newJsType == null) {
                throw new RuntimeException("JS Compiler does not recognize type: " + type);
            }
            this.replaceTypePattern(n, type, Pattern.compile("@(type) *\\{?[^@\\s}]+\\}?"));
            this.replaceTypePattern(n, type, Pattern.compile("@(export|package|private|protected|public|const|return) *\\{[^}]+\\}"));
            return this;
        }

        private void replaceTypePattern(Node n, String type, Pattern pattern) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            Preconditions.checkNotNull(info, "Node %s does not have JS Doc associated with it.", (Object)n);
            String originalComment = info.getOriginalCommentString();
            int originalPosition = info.getOriginalCommentPosition();
            if (originalComment != null) {
                Matcher m = pattern.matcher(originalComment);
                while (m.find()) {
                    this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(originalPosition + m.start(), m.end() - m.start(), "@" + m.group(1) + " {" + type + "}"));
                }
            }
        }

        public Builder insertArguments(Node n, int position, String ... args) {
            int startPosition;
            int i;
            Preconditions.checkArgument(n.isCall(), "insertArguments is only applicable to function call nodes.");
            Node argument = n.getSecondChild();
            for (i = 0; argument != null && i < position; argument = argument.getNext(), ++i) {
            }
            if (argument == null) {
                Preconditions.checkArgument(position == i, "The specified position must be less than the number of arguments.");
                startPosition = n.getSourceOffset() + n.getLength() - 1;
            } else {
                startPosition = SuggestedFix.getStartPositionForNodeConsideringComments(argument);
            }
            String newContent = Joiner.on(", ").join(args);
            if (argument != null) {
                newContent = newContent + ", ";
            } else if (i > 0) {
                newContent = ", " + newContent;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, newContent));
            return this;
        }

        public Builder deleteArgument(Node n, int position) {
            Preconditions.checkArgument(n.isCall() || n.isNew(), "deleteArgument is only applicable to function call nodes.");
            int numArguments = n.getChildCount() - 1;
            Preconditions.checkState(numArguments > 0, "deleteArgument() cannot be used on a function call with no arguments");
            Preconditions.checkArgument(position >= 0 && position < numArguments, "The specified position must be less than the number of arguments.");
            Node argument = n.getSecondChild();
            int startOfArgumentToRemove = -1;
            int endOfArgumentToRemove = -1;
            int i = 0;
            while (argument != null) {
                if (i < position) {
                    startOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i == position) {
                    if (position == 0) {
                        startOfArgumentToRemove = SuggestedFix.getStartPositionForNodeConsideringComments(argument);
                    }
                    endOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i > position) {
                    if (position != 0) break;
                    endOfArgumentToRemove = argument.getSourceOffset();
                    break;
                }
                argument = argument.getNext();
                ++i;
            }
            int lengthOfArgumentToRemove = endOfArgumentToRemove - startOfArgumentToRemove;
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startOfArgumentToRemove, lengthOfArgumentToRemove, ""));
            return this;
        }

        private static Node createImportNode(ImportType importType, @Nullable String alias, String namespace) {
            String requireFlavor;
            switch (importType) {
                case REQUIRE: {
                    requireFlavor = "require";
                    break;
                }
                case REQUIRE_TYPE: {
                    requireFlavor = "requireType";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Node callNode = IR.call(IR.getprop(IR.name("goog"), IR.string(requireFlavor)), IR.string(namespace));
            if (alias != null) {
                return IR.constNode(IR.name(alias), callNode);
            }
            return IR.exprResult(callNode);
        }

        public Builder addGoogRequire(Match m, String namespace, ScriptMetadata scriptMetadata) {
            return this.addImport(m, namespace, ImportType.REQUIRE, scriptMetadata);
        }

        public Builder addGoogRequireType(Match m, String namespace, ScriptMetadata scriptMetadata) {
            return this.addImport(m, namespace, ImportType.REQUIRE_TYPE, scriptMetadata);
        }

        public Builder addImport(Match m, String namespace, ImportType importType, ScriptMetadata scriptMetadata) {
            String alias;
            if (scriptMetadata.supportsRequireAliases()) {
                String existingAlias = scriptMetadata.getAlias(namespace);
                alias = existingAlias != null ? existingAlias : (namespace.indexOf(46) == -1 ? namespace : Streams.stream(RequireAliasGenerator.over(namespace)).filter(a -> !scriptMetadata.usesName((String)a)).findFirst().orElseThrow(AssertionError::new));
                scriptMetadata.addAlias(namespace, alias);
            } else {
                alias = null;
            }
            NodeMetadata metadata = m.getMetadata();
            Node existingNode = Builder.findGoogRequireNode(m.getNode(), metadata, namespace);
            if (existingNode != null) {
                if (existingNode.isExprResult() && alias != null) {
                    Node newNode = IR.constNode(IR.name(alias), existingNode.getFirstChild().cloneTree());
                    this.replace(existingNode, newNode, m.getMetadata().getCompiler());
                    scriptMetadata.addAlias(namespace, alias);
                }
                return this;
            }
            Node script = scriptMetadata.getScript();
            if (script.getFirstChild().isModuleBody()) {
                script = script.getFirstChild();
            }
            Node lastModuleOrProvideNode = null;
            Node lastGoogRequireNode = null;
            Node nodeToInsertBefore = null;
            for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                if (Matchers.googModule().matches(child, metadata)) {
                    lastModuleOrProvideNode = child;
                }
                if (NodeUtil.isExprCall(child)) {
                    Node grandchild = child.getFirstChild();
                    if (Matchers.googModuleOrProvide().matches(grandchild, metadata)) {
                        lastModuleOrProvideNode = grandchild;
                        continue;
                    }
                    if (!Matchers.googRequirelike().matches(grandchild, metadata)) continue;
                    lastGoogRequireNode = grandchild;
                    if (!grandchild.getLastChild().isString() || namespace.compareTo(grandchild.getLastChild().getString()) >= 0) continue;
                    nodeToInsertBefore = child;
                    break;
                }
                if (!NodeUtil.isNameDeclaration(child) || child.getFirstFirstChild() == null || !Matchers.googRequirelike().matches(child.getFirstFirstChild(), metadata)) continue;
                lastGoogRequireNode = child.getFirstFirstChild();
                String requireName = child.getFirstChild().getString();
                String originalName = child.getFirstChild().getOriginalName();
                if (originalName != null) {
                    requireName = originalName;
                }
                if (alias.compareTo(requireName) >= 0) continue;
                nodeToInsertBefore = child;
                break;
            }
            Node newImportNode = Builder.createImportNode(importType, alias, namespace);
            if (nodeToInsertBefore == null) {
                if (lastModuleOrProvideNode != null || lastGoogRequireNode != null) {
                    Node nodeToInsertAfter = lastGoogRequireNode != null ? lastGoogRequireNode : lastModuleOrProvideNode;
                    int startPosition = nodeToInsertAfter.getSourceOffset() + nodeToInsertAfter.getLength() + 2;
                    this.replacements.put((Object)nodeToInsertAfter.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, this.generateCode(m.getMetadata().getCompiler(), newImportNode), namespace));
                    return this;
                }
                if (script.hasChildren()) {
                    nodeToInsertBefore = script.getFirstChild();
                } else {
                    this.replacements.put((Object)script.getSourceFileName(), (Object)CodeReplacement.create(0, 0, this.generateCode(m.getMetadata().getCompiler(), newImportNode), namespace));
                    return this;
                }
            }
            return this.insertBefore(nodeToInsertBefore, newImportNode, m.getMetadata().getCompiler(), namespace);
        }

        public Builder removeGoogRequire(Match m, String namespace) {
            Node googRequireNode = Builder.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            if (googRequireNode != null) {
                return this.deleteWithoutRemovingWhitespaceBefore(googRequireNode);
            }
            return this;
        }

        @Nullable
        private static Node findGoogRequireNode(Node n, NodeMetadata metadata, String namespace) {
            Node script = metadata.getCompiler().getScriptNode(n.getSourceFileName());
            if (script.getFirstChild().isModuleBody()) {
                script = script.getFirstChild();
            }
            for (Node child : script.children()) {
                if (!NodeUtil.isExprCall(child) || !Matchers.googRequirelike(namespace).matches(child.getFirstChild(), metadata)) continue;
                return child;
            }
            for (Node child : script.children()) {
                if (!NodeUtil.isNameDeclaration(child) || child.getFirstChild().isDestructuringLhs() || child.getFirstChild().getLastChild() == null || !Matchers.googRequirelike(namespace).matches(child.getFirstChild().getLastChild(), metadata)) continue;
                return child;
            }
            return null;
        }

        public String generateCode(AbstractCompiler compiler, Node node) {
            if (node.isBlock()) {
                node.setToken(Token.SCRIPT);
            }
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.setPreferSingleQuotes(true);
            compilerOptions.setUseOriginalNamesInOutput(true);
            compilerOptions.setPreserveNonJSDocComments(true);
            compilerOptions.setTrustedStrings(true);
            return new CodePrinter.Builder(node).setCompilerOptions(compilerOptions).setTypeRegistry(compiler.getTypeRegistry()).setPrettyPrint(true).setLineBreak(true).setOutputTypes(true).build();
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public SuggestedFix build() {
            return new SuggestedFix(this.matchedNodeInfo, (SetMultimap)((Object)this.replacements.build()), this.description, (ImmutableList)this.alternatives.build());
        }
    }

    static enum ImportType {
        REQUIRE,
        REQUIRE_TYPE;

    }
}

