/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.graph;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.filters.plugin.graph.EgoBuilder;
import org.openide.util.NbBundle;

public class EgoPanel
extends JPanel {
    private EgoBuilder.EgoFilter egoFilter;
    private JComboBox depthComboBox;
    private JLabel labelDepth;
    private JLabel labelNodeId;
    private JTextField nodeIdTextField;
    private JButton okButton;
    private JCheckBox withSelfCheckbox;

    public EgoPanel() {
        this.initComponents();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EgoPanel.this.egoFilter.getProperties()[0].setValue((Object)EgoPanel.this.nodeIdTextField.getText());
            }
        });
        this.depthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int depth = -1;
                int index = EgoPanel.this.depthComboBox.getSelectedIndex();
                depth = index == EgoPanel.this.depthComboBox.getModel().getSize() - 1 ? Integer.MAX_VALUE : index + 1;
                if (!EgoPanel.this.egoFilter.getDepth().equals(depth)) {
                    EgoPanel.this.egoFilter.getProperties()[1].setValue((Object)depth);
                }
            }
        });
        this.withSelfCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!EgoPanel.this.egoFilter.isSelf() == EgoPanel.this.withSelfCheckbox.isSelected()) {
                    EgoPanel.this.egoFilter.getProperties()[2].setValue((Object)EgoPanel.this.withSelfCheckbox.isSelected());
                }
            }
        });
    }

    public void setup(EgoBuilder.EgoFilter egoFilter) {
        this.egoFilter = egoFilter;
        this.nodeIdTextField.setText(egoFilter.getPattern());
        int depth = egoFilter.getDepth();
        if (depth == Integer.MAX_VALUE) {
            this.depthComboBox.setSelectedIndex(this.depthComboBox.getModel().getSize() - 1);
        } else {
            this.depthComboBox.setSelectedIndex(depth - 1);
        }
        this.withSelfCheckbox.setSelected(egoFilter.isSelf());
    }

    private void initComponents() {
        this.labelNodeId = new JLabel();
        this.nodeIdTextField = new JTextField();
        this.labelDepth = new JLabel();
        this.depthComboBox = new JComboBox();
        this.okButton = new JButton();
        this.withSelfCheckbox = new JCheckBox();
        this.labelNodeId.setText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.labelNodeId.text"));
        this.nodeIdTextField.setText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.nodeIdTextField.text"));
        this.nodeIdTextField.setToolTipText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.nodeIdTextField.toolTipText"));
        this.labelDepth.setText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.labelDepth.text"));
        this.depthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "Max"}));
        this.okButton.setText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.okButton.text"));
        this.okButton.setMargin(new Insets(2, 7, 2, 7));
        this.withSelfCheckbox.setText(NbBundle.getMessage(EgoPanel.class, (String)"EgoPanel.withSelfCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelNodeId).addComponent(this.labelDepth)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.withSelfCheckbox).addComponent(this.depthComboBox, -2, 70, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.nodeIdTextField, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNodeId).addComponent(this.nodeIdTextField, -2, -1, -2).addComponent(this.okButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.depthComboBox, -2, -1, -2).addComponent(this.labelDepth)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.withSelfCheckbox).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

