/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.CardLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.gui.PanelWindowContainer;

class DockablePanel
extends JPanel {
    private final PanelWindowContainer panel;
    private final DockableWindowManagerImpl wm;
    static Point dragStart;

    DockablePanel(PanelWindowContainer panelWindowContainer) {
        super(new CardLayout());
        this.panel = panelWindowContainer;
        this.wm = panelWindowContainer.getDockableWindowManager();
        ResizeMouseHandler resizeMouseHandler = new ResizeMouseHandler();
        this.addMouseListener(resizeMouseHandler);
        this.addMouseMotionListener(resizeMouseHandler);
    }

    PanelWindowContainer getWindowContainer() {
        return this.panel;
    }

    void showDockable(String string) {
        ((CardLayout)this.getLayout()).show(this, string);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.panel.getPosition();
        int n = this.panel.getDimension();
        if (this.panel.getCurrent() == null) {
            return new Dimension(0, 0);
        }
        if (string.equals("top") || string.equals("bottom")) {
            if (n <= 0) {
                int n2 = super.getPreferredSize().height;
                this.panel.setDimension(n2);
            }
            return new Dimension(0, n + 10);
        }
        if (n <= 0) {
            int n3 = super.getPreferredSize().width;
            this.panel.setDimension(n3);
        }
        return new Dimension(n + 10, 0);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        String string = this.panel.getPosition();
        int n5 = this.panel.getDimension();
        if (string.equals("top") || string.equals("bottom")) {
            if (n5 != 0 && n4 <= 10) {
                this.panel.show((DockableWindowManagerImpl.Entry)null);
            } else {
                this.panel.setDimension(n4);
            }
        } else if (n5 != 0 && n3 <= 10) {
            this.panel.show((DockableWindowManagerImpl.Entry)null);
        } else {
            this.panel.setDimension(n3);
        }
        super.setBounds(n, n2, n3, n4);
    }

    private class ResizeMouseHandler
    extends MouseAdapter {
        boolean canDrag;
        private boolean continuousLayout;

        private ResizeMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.canDrag) {
                this.continuousLayout = UIManager.getBoolean("SplitPane.continuousLayout");
                DockablePanel.this.wm.setResizePos(DockablePanel.this.panel.getDimension(), DockablePanel.this.panel);
                dragStart = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.canDrag) {
                if (!this.continuousLayout) {
                    DockablePanel.this.panel.setDimension(DockablePanel.this.wm.resizePos + 10);
                }
                DockablePanel.this.wm.finishResizing();
                dragStart = null;
                DockablePanel.this.wm.revalidate();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Border border = DockablePanel.this.getBorder();
            if (border == null) {
                return;
            }
            String string = DockablePanel.this.panel.getPosition();
            Insets insets = border.getBorderInsets(DockablePanel.this);
            this.canDrag = false;
            switch (string) {
                case "top": {
                    if (mouseEvent.getY() < DockablePanel.this.getHeight() - insets.bottom) break;
                    this.canDrag = true;
                    break;
                }
                case "left": {
                    if (mouseEvent.getX() < DockablePanel.this.getWidth() - insets.right) break;
                    this.canDrag = true;
                    break;
                }
                case "bottom": {
                    if (mouseEvent.getY() > insets.top) break;
                    this.canDrag = true;
                    break;
                }
                case "right": {
                    if (mouseEvent.getX() > insets.left) break;
                    this.canDrag = true;
                }
            }
            if (dragStart == null) {
                if (this.canDrag) {
                    DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(this.getAppropriateCursor()));
                } else {
                    DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.canDrag) {
                return;
            }
            if (dragStart == null) {
                return;
            }
            int n = DockablePanel.this.panel.getDimension();
            String string = DockablePanel.this.panel.getPosition();
            int n2 = 0;
            switch (string) {
                case "top": {
                    n2 = mouseEvent.getY();
                    DockablePanel.this.wm.setResizePos(mouseEvent.getY() - DockablePanel.dragStart.y + n, DockablePanel.this.panel);
                    break;
                }
                case "left": {
                    n2 = mouseEvent.getX();
                    DockablePanel.this.wm.setResizePos(mouseEvent.getX() - DockablePanel.dragStart.x + n, DockablePanel.this.panel);
                    break;
                }
                case "bottom": {
                    n2 = n - mouseEvent.getY();
                    DockablePanel.this.wm.setResizePos(n - mouseEvent.getY() + DockablePanel.dragStart.y, DockablePanel.this.panel);
                    break;
                }
                case "right": {
                    n2 = n - mouseEvent.getX();
                    DockablePanel.this.wm.setResizePos(n - mouseEvent.getX() + DockablePanel.dragStart.x, DockablePanel.this.panel);
                }
            }
            if (this.continuousLayout) {
                DockablePanel.this.panel.setDimension(n2 + 10);
                DockablePanel.this.wm.revalidate();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (dragStart == null) {
                DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private int getAppropriateCursor() {
            String string;
            switch (string = DockablePanel.this.panel.getPosition()) {
                case "top": {
                    return 8;
                }
                case "left": {
                    return 10;
                }
                case "bottom": {
                    return 9;
                }
                case "right": {
                    return 11;
                }
            }
            throw new InternalError();
        }
    }
}

