/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Mediawiki;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public abstract class HelpAction
extends AbstractAction {
    protected HelpAction() {
        this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
        new ImageProvider("help", "internet").getResource().attachImageIcon(this, true);
        this.putValue("AcceleratorKey", HelpAction.getKeyStroke());
    }

    public static KeyStroke getKeyStroke() {
        return MainApplication.getMenu().help.getShortcut().getKeyStroke();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainApplication.worker.execute(HelpAction::displayGenericHelp);
    }

    public static void displayTagHelp(String key, String val) {
        String lang = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.OSM_WIKI);
        List<String> pages = Arrays.asList(String.format("%sTag:%s=%s", lang, key, val), String.format("Tag:%s=%s", key, val), String.format("%sKey:%s", lang, key), String.format("Key:%s", key), String.format("%sMap_Features", lang), "Map_Features");
        HelpAction.displayHelp(pages);
    }

    public static void displayRelationHelp(IRelation<?> rel) {
        String lang = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.OSM_WIKI);
        ArrayList<String> pages = new ArrayList<String>();
        String type = rel.get("type");
        if (type != null) {
            type = Utils.encodeUrl(type);
        }
        if (type != null && !type.isEmpty()) {
            pages.add(String.format("%sRelation:%s", lang, type));
            pages.add(String.format("Relation:%s", type));
        }
        pages.add(String.format("%sRelations", lang));
        pages.add("Relations");
        HelpAction.displayHelp(pages);
    }

    public static void displayGenericHelp() {
        String lang = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.OSM_WIKI);
        List<String> pages = Arrays.asList(String.format("%sMap_Features", lang), "Map_Features");
        HelpAction.displayHelp(pages);
    }

    public static void displayHelp(List<String> pages) {
        try {
            new Mediawiki(Config.getUrls().getOSMWiki()).findExistingPage(pages).ifPresent(page -> OpenBrowser.displayUrl(Config.getUrls().getOSMWiki() + "/wiki/" + page));
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e1) {
            Logging.error(e1);
        }
    }
}

