/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.KeyboardUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;

public final class Shortcut {
    private final String shortText;
    private String longText;
    private final int requestedKey;
    private final int requestedGroup;
    private int assignedKey;
    private int assignedModifier;
    private boolean assignedDefault;
    private boolean assignedUser;
    private boolean automatic;
    private boolean reset;
    private static final ShortcutCollection shortcuts = new ShortcutCollection();
    private static final Map<Integer, Integer> groups = new HashMap<Integer, Integer>();
    public static final int NONE = 5000;
    public static final int MNEMONIC = 5001;
    public static final int RESERVED = 5002;
    public static final int DIRECT = 5003;
    public static final int ALT = 5004;
    public static final int SHIFT = 5005;
    public static final int CTRL = 5006;
    public static final int ALT_SHIFT = 5007;
    public static final int ALT_CTRL = 5008;
    public static final int CTRL_SHIFT = 5009;
    public static final int ALT_CTRL_SHIFT = 5010;
    private static final int[] mods = new int[]{5008, 5007, 5009, 5010};
    private static final int[] keys = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123};
    private static boolean initdone;

    private Shortcut(String shortText, String longText, int requestedKey, int requestedGroup, int assignedKey, int assignedModifier, boolean assignedDefault, boolean assignedUser) {
        this.shortText = shortText;
        this.longText = longText;
        this.requestedKey = requestedKey;
        this.requestedGroup = requestedGroup;
        this.assignedKey = assignedKey;
        this.assignedModifier = assignedModifier;
        this.assignedDefault = assignedDefault;
        this.assignedUser = assignedUser;
        this.automatic = false;
        this.reset = false;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    private void setLongText(String longText) {
        this.longText = longText;
    }

    public int getAssignedKey() {
        return this.assignedKey;
    }

    public int getAssignedModifier() {
        return this.assignedModifier;
    }

    public boolean isAssignedDefault() {
        return this.assignedDefault;
    }

    public boolean isAssignedUser() {
        return this.assignedUser;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isChangeable() {
        return !this.automatic && !"core:none".equals(this.shortText);
    }

    private boolean isReset() {
        return this.reset;
    }

    public void setAutomatic() {
        this.automatic = true;
    }

    public void setAssignedModifier(int assignedModifier) {
        this.assignedModifier = assignedModifier;
    }

    public void setAssignedKey(int assignedKey) {
        this.assignedKey = assignedKey;
    }

    public void setAssignedUser(boolean assignedUser) {
        boolean bl = this.reset = (this.assignedUser || this.reset) && !assignedUser;
        if (assignedUser) {
            this.assignedDefault = false;
        } else if (this.reset) {
            this.assignedKey = this.requestedKey;
            this.assignedModifier = Shortcut.findModifier(this.requestedGroup, null);
        }
        this.assignedUser = assignedUser;
    }

    public KeyStroke getKeyStroke() {
        if (this.assignedModifier != -1) {
            return KeyStroke.getKeyStroke(this.assignedKey, this.assignedModifier);
        }
        return null;
    }

    private Shortcut(String prefString) {
        ArrayList<String> s = new ArrayList<String>(Config.getPref().getList(prefString));
        this.shortText = prefString.substring(15);
        this.longText = (String)s.get(0);
        this.requestedKey = Integer.parseInt((String)s.get(1));
        this.requestedGroup = Integer.parseInt((String)s.get(2));
        this.assignedKey = Integer.parseInt((String)s.get(3));
        this.assignedModifier = Integer.parseInt((String)s.get(4));
        this.assignedDefault = Boolean.parseBoolean((String)s.get(5));
        this.assignedUser = Boolean.parseBoolean((String)s.get(6));
    }

    private void saveDefault() {
        Config.getPref().getList("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.requestedKey), String.valueOf(Shortcut.getGroupModifier(this.requestedGroup)), String.valueOf(true), String.valueOf(false)));
    }

    private boolean save() {
        if (this.isAutomatic() || this.isReset() || !this.isAssignedUser()) {
            return Config.getPref().putList("shortcut.entry." + this.shortText, null);
        }
        return Config.getPref().putList("shortcut.entry." + this.shortText, Arrays.asList(this.longText, String.valueOf(this.requestedKey), String.valueOf(this.requestedGroup), String.valueOf(this.assignedKey), String.valueOf(this.assignedModifier), String.valueOf(this.assignedDefault), String.valueOf(this.assignedUser)));
    }

    private boolean isSame(int isKey, int isModifier) {
        return isKey == this.assignedKey && isModifier == this.assignedModifier && this.assignedModifier != Shortcut.getGroupModifier(5000);
    }

    public boolean isEvent(KeyEvent e) {
        KeyStroke ks = this.getKeyStroke();
        return ks != null && ks.equals(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiersEx()));
    }

    public void setMnemonic(JMenu menu) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            menu.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setMnemonic(AbstractButton button) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            button.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setFocusAccelerator(JTextComponent component) {
        if (this.assignedModifier == Shortcut.getGroupModifier(5001) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            component.setFocusAccelerator(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setAccelerator(AbstractAction action) {
        if (this.getKeyStroke() != null) {
            action.putValue("AcceleratorKey", this.getKeyStroke());
        }
    }

    public String getKeyText() {
        return Shortcut.getKeyText(this.getKeyStroke());
    }

    public static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String modifText = KeyEvent.getModifiersExText(keyStroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return modifText + '+' + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public void setTooltip(Action action, String tooltip) {
        Shortcut.setTooltip(action, tooltip, this.getKeyStroke());
    }

    public static void setTooltip(Action action, String tooltip, KeyStroke keyStroke) {
        action.putValue("ShortDescription", Shortcut.makeTooltip(tooltip, keyStroke));
    }

    public String toString() {
        return this.getKeyText();
    }

    public static Optional<Shortcut> findShortcut(int requestedKey, int modifier) {
        return Shortcut.findShortcutByKeyOrShortText(requestedKey, modifier, null);
    }

    private static Optional<Shortcut> findShortcutByKeyOrShortText(int requestedKey, int modifier, String shortText) {
        Predicate<Shortcut> sameKey = sc -> modifier != Shortcut.getGroupModifier(5000) && sc.isSame(requestedKey, modifier);
        Predicate<Shortcut> sameShortText = sc -> sc.getShortText().equals(shortText);
        return shortcuts.stream().filter(sameKey.or(sameShortText)).sorted(Comparator.comparingInt(sc -> sameShortText.test((Shortcut)sc) ? 0 : 1)).findAny();
    }

    public static List<Shortcut> listAll() {
        return shortcuts.stream().filter(c -> !"core:none".equals(c.shortText)).collect(Collectors.toList());
    }

    private static void doInit() {
        if (initdone) {
            return;
        }
        initdone = true;
        int commandDownMask = PlatformManager.getPlatform().getMenuShortcutKeyMaskEx();
        groups.put(5000, -1);
        groups.put(5001, 512);
        groups.put(5003, 0);
        groups.put(5004, 512);
        groups.put(5005, 64);
        groups.put(5006, commandDownMask);
        groups.put(5007, 576);
        groups.put(5008, 0x200 | commandDownMask);
        groups.put(5009, commandDownMask | 0x40);
        groups.put(5010, 0x200 | commandDownMask | 0x40);
        PlatformManager.getPlatform().initSystemShortcuts();
        Preferences.main().getAllPrefixCollectionKeys("shortcut.entry.").stream().map(Shortcut::new).filter(sc -> !Shortcut.findShortcut(sc.getAssignedKey(), sc.getAssignedModifier()).isPresent()).sorted(Comparator.comparing(sc -> sc.isAssignedUser() ? 1 : (sc.isAssignedDefault() ? 2 : 3))).forEachOrdered(shortcuts::replace);
    }

    private static int getGroupModifier(int group) {
        return Optional.ofNullable(groups.get(group)).orElse(-1);
    }

    private static int findModifier(int group, Integer modifier) {
        if (modifier == null && (modifier = Integer.valueOf(Shortcut.getGroupModifier(group))) == null) {
            modifier = Shortcut.getGroupModifier(5000);
        }
        return modifier;
    }

    public static boolean savePrefs() {
        return shortcuts.stream().map(Shortcut::save).reduce(Boolean.FALSE, Boolean::logicalOr);
    }

    public static Shortcut registerSystemShortcut(String shortText, String longText, int key, int modifier) {
        Optional<Shortcut> existing = Shortcut.findShortcutByKeyOrShortText(key, modifier, shortText);
        if (existing.isPresent() && shortText.equals(existing.get().getShortText())) {
            return existing.get();
        }
        if (existing.isPresent()) {
            Logging.error("CONFLICT WITH SYSTEM KEY " + shortText + ": " + existing.get());
            return null;
        }
        Shortcut shortcut = new Shortcut(shortText, longText, key, 5002, key, modifier, true, false);
        shortcuts.add(shortcut);
        return shortcut;
    }

    public static List<Shortcut> registerMultiShortcuts(String shortText, String longText, List<Character> characters, int requestedGroup) {
        ArrayList<Shortcut> result = new ArrayList<Shortcut>();
        int i = 1;
        Map<Integer, Integer> regularKeyCodes = KeyboardUtils.getRegularKeyCodesMap();
        for (Character c : characters) {
            Integer code = c.charValue();
            result.add(Shortcut.registerShortcut(shortText + " (" + i + ')', longText, regularKeyCodes.containsKey(code) ? regularKeyCodes.get(code) : (Shortcut.isDeadKey(code) ? code : c.charValue() | 0x1000000), requestedGroup));
            ++i;
        }
        return result;
    }

    static boolean isDeadKey(int keyCode) {
        return 128 <= keyCode && keyCode <= 143;
    }

    public static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup) {
        return Shortcut.registerShortcut(shortText, longText, requestedKey, requestedGroup, null);
    }

    private static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup, Integer modifier) {
        Shortcut.doInit();
        Integer defaultModifier = Shortcut.findModifier(requestedGroup, modifier);
        Optional<Shortcut> existing = Shortcut.findShortcutByKeyOrShortText(requestedKey, defaultModifier, shortText);
        if (existing.isPresent() && shortText.equals(existing.get().getShortText())) {
            Shortcut sc = existing.get();
            sc.setLongText(longText);
            sc.saveDefault();
            return sc;
        }
        if (existing.isPresent()) {
            int newmodifier;
            Shortcut conflict = existing.get();
            if (PlatformManager.isPlatformOsx() && !Shortcut.findShortcut(requestedKey, newmodifier = Shortcut.findNewOsxModifier(requestedGroup)).isPresent()) {
                Logging.info("Reassigning macOS shortcut '" + shortText + "' from Meta to Ctrl because of conflict with " + conflict);
                return Shortcut.reassignShortcut(shortText, longText, requestedKey, conflict, requestedGroup, requestedKey, newmodifier);
            }
            for (int m : mods) {
                for (int k : keys) {
                    int newmodifier2 = Shortcut.getGroupModifier(m);
                    if (Shortcut.findShortcut(k, newmodifier2).isPresent()) continue;
                    Logging.info("Reassigning shortcut '" + shortText + "' from " + modifier + " to " + newmodifier2 + " because of conflict with " + conflict);
                    return Shortcut.reassignShortcut(shortText, longText, requestedKey, conflict, m, k, newmodifier2);
                }
            }
        } else {
            Shortcut newsc = new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, defaultModifier, true, false);
            newsc.saveDefault();
            shortcuts.add(newsc);
            return newsc;
        }
        return null;
    }

    private static int findNewOsxModifier(int requestedGroup) {
        switch (requestedGroup) {
            case 5006: {
                return 128;
            }
            case 5008: {
                return 640;
            }
            case 5009: {
                return 192;
            }
            case 5010: {
                return 704;
            }
        }
        return 0;
    }

    private static Shortcut reassignShortcut(String shortText, String longText, int requestedKey, Shortcut conflict, int m, int k, int newmodifier) {
        Shortcut newsc = new Shortcut(shortText, longText, requestedKey, m, k, newmodifier, false, false);
        Logging.info(I18n.tr("Silent shortcut conflict: ''{0}'' moved by ''{1}'' to ''{2}''.", shortText, conflict.getShortText(), newsc.getKeyText()));
        newsc.saveDefault();
        shortcuts.add(newsc);
        return newsc;
    }

    public static KeyStroke getCopyKeyStroke() {
        return Shortcut.getKeyStrokeForShortKey("system:copy");
    }

    public static KeyStroke getPasteKeyStroke() {
        return Shortcut.getKeyStrokeForShortKey("system:paste");
    }

    public static KeyStroke getCutKeyStroke() {
        return Shortcut.getKeyStrokeForShortKey("system:cut");
    }

    private static KeyStroke getKeyStrokeForShortKey(String shortKey) {
        return shortcuts.stream().filter(sc -> shortKey.equals(sc.getShortText())).findAny().map(Shortcut::getKeyStroke).orElse(null);
    }

    public static String makeTooltip(String tooltip, KeyStroke keyStroke) {
        Optional<String> keyStrokeText = Optional.ofNullable(keyStroke).map(Shortcut::getKeyText).filter(text -> !text.isEmpty());
        String laf = UIManager.getLookAndFeel().getID();
        boolean canHtml = !PlatformManager.isPlatformOsx() || !laf.contains("Mac") && !laf.contains("Aqua");
        StringBuilder result = new StringBuilder(48);
        if (canHtml) {
            result.append("<html>");
        }
        result.append(tooltip);
        if (keyStrokeText.isPresent()) {
            result.append(' ');
            if (canHtml) {
                result.append("<font size='-2'>");
            }
            result.append('(').append(keyStrokeText.get()).append(')');
            if (canHtml) {
                result.append("</font>");
            }
        }
        if (canHtml) {
            result.append("&nbsp;</html>");
        }
        return result.toString();
    }

    private static class ShortcutCollection
    extends CopyOnWriteArrayList<Shortcut> {
        private static final long serialVersionUID = 1L;

        private ShortcutCollection() {
        }

        @Override
        public boolean add(Shortcut shortcut) {
            if (Logging.isDebugEnabled()) {
                if (this.stream().map(Shortcut::getShortText).anyMatch(shortcut.getShortText()::equals)) {
                    Logging.warn((Throwable)((Object)new AssertionError((Object)(shortcut.getShortText() + " already added"))));
                }
            }
            return super.add(shortcut);
        }

        void replace(Shortcut newShortcut) {
            Optional existing = Shortcut.findShortcutByKeyOrShortText(-1, 5000, newShortcut.shortText);
            if (existing.isPresent()) {
                this.replaceAll(sc -> existing.get() == sc ? newShortcut : sc);
            } else {
                this.add(newShortcut);
            }
        }
    }
}

