/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface PsiModificationTracker
extends ModificationTracker {
    public static final Key MODIFICATION_COUNT = Key.create("MODIFICATION_COUNT");
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static final Key OUT_OF_CODE_BLOCK_MODIFICATION_COUNT = MODIFICATION_COUNT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static final Key JAVA_STRUCTURE_MODIFICATION_COUNT = MODIFICATION_COUNT;
    public static final Topic<Listener> TOPIC = new Topic<Listener>(Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Override
    public long getModificationCount();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public long getOutOfCodeBlockModificationCount();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public long getJavaStructureModificationCount();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @NotNull
    public ModificationTracker getJavaStructureModificationTracker();

    @FunctionalInterface
    public static interface Listener {
        public void modificationCountChanged();
    }

    public static final class SERVICE {
        private SERVICE() {
        }

        public static PsiModificationTracker getInstance(Project project) {
            return ServiceManager.getService(project, PsiModificationTracker.class);
        }
    }
}

