/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.SuperCallCheckersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r*\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNotASupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findClosestClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "label", "", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
public final class FirNotASupertypeChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirNotASupertypeChecker INSTANCE = new FirNotASupertypeChecker();

    private FirNotASupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirTypeRef firTypeRef;
        FirSuperReference superReference;
        FirReference firReference;
        FirSuperReference firSuperReference;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirReference $this$safeAs$iv = expression2.getCalleeReference();
        boolean $i$f$safeAs = false;
        FirReference firReference2 = $this$safeAs$iv;
        if (!(firReference2 instanceof FirSuperReference)) {
            firReference2 = null;
        }
        if ((firSuperReference = (FirSuperReference)firReference2) == null) {
            firReference = null;
        } else {
            $this$safeAs$iv = firSuperReference;
            boolean bl = false;
            boolean bl2 = false;
            FirReference it = $this$safeAs$iv;
            boolean bl3 = false;
            firReference = SuperCallCheckersKt.hadExplicitTypeInSource((FirSuperReference)it) ? $this$safeAs$iv : null;
        }
        FirElement firElement = superReference = firReference;
        FirPureAbstractElement firPureAbstractElement = firElement == null ? null : ($this$safeAs$iv = (firTypeRef = firElement.getSuperTypeRef()) == null ? null : FirHelpersKt.toRegularClass(firTypeRef, context2.getSession()));
        if ($this$safeAs$iv == null) {
            return;
        }
        FirReference targetClass = $this$safeAs$iv;
        firElement = this.findClosestClass(context2, superReference.getLabelName());
        if (firElement == null) {
            return;
        }
        FirElement surrounding = firElement;
        if (!FirHelpersKt.isSupertypeOf((FirClass)((Object)targetClass), surrounding)) {
            this.report(reporter, expression2.getSource());
        }
    }

    private final FirClass<?> findClosestClass(CheckerContext $this$findClosestClass, String label) {
        for (FirDeclaration it : CollectionsKt.reversed((Iterable)$this$findClosestClass.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            FirClass firClass = (FirClass)it;
            Name name = firClass.getSymbol().getClassId().getShortClassName();
            Intrinsics.checkNotNullExpressionValue(name, "firClass.symbol.classId.shortClassName");
            Name className2 = name;
            if (label != null && (className2.isSpecial() || !Intrinsics.areEqual(className2.getIdentifier(), label))) continue;
            return firClass;
        }
        return null;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getNOT_A_SUPERTYPE().on(it));
        }
    }
}

