/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModifiersCheckerKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001JB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001d\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000bH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J6\u0010(\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0/H\u0002J.\u00100\u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u00102\u001a\u00020*2\u0006\u0010&\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J8\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u0006\u0010\"\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u00010%2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010&\u001a\u00020'H\u0002J*\u00108\u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u00102\u001a\u00020*2\b\u00107\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J&\u00109\u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u00102\u001a\u00020*2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0018\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\fH\u0002J9\u0010=\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000b2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0>\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010?JA\u0010@\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010:\u001a\u00020\u00162\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0>\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010AJ9\u0010B\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000b2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0>\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010?J9\u0010C\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000b2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0>\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010?J\u001e\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\b2\u0006\u0010&\u001a\u00020'J0\u0010G\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010H\u001a\u00020\f2\u0006\u0010I\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u001c\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00160\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore;", "", "()V", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "defaultVisibilityTargets", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "kotlin.jvm.PlatformType", "deprecatedModifierMap", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "deprecatedParentTargetMap", "", "deprecatedTargetMap", "featureDependencies", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "featureDependenciesTargets", "mutualCompatibility", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "possibleParentTargetPredicateMap", "Lorg/jetbrains/kotlin/resolve/TargetAllowedPredicate;", "possibleTargetMap", "getPossibleTargetMap", "()Ljava/util/Map;", "redundantTargetMap", "buildCompatibilityMap", "check", "", "listOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkCompatibility", "firstNode", "Lcom/intellij/lang/ASTNode;", "secondNode", "owner", "Lcom/intellij/psi/PsiElement;", "incorrectNodes", "", "checkLanguageLevelSupport", "", "node", "actualTargets", "checkModifierList", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "parentDescriptor", "checkParent", "checkTarget", "compatibility", "first", "second", "compatibilityForClassesRegister", "", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "compatibilityRegister", "(Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "deprecationRegister", "incompatibilityRegister", "isPossibleParentTarget", "modifier", "parentTarget", "redundantRegister", "sufficient", "redundant", "Compatibility", "frontend"})
public final class ModifierCheckerCore {
    @NotNull
    public static final ModifierCheckerCore INSTANCE = new ModifierCheckerCore();
    private static final EnumSet<KotlinTarget> defaultVisibilityTargets;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> possibleTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, List<LanguageFeature>> featureDependencies;
    @NotNull
    private static final Map<LanguageFeature, Set<KotlinTarget>> featureDependenciesTargets;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> deprecatedTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, KtModifierKeywordToken> deprecatedModifierMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> redundantTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, TargetAllowedPredicate> possibleParentTargetPredicateMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> deprecatedParentTargetMap;
    @NotNull
    private static final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> mutualCompatibility;
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    private ModifierCheckerCore() {
    }

    @NotNull
    public final Map<KtModifierKeywordToken, Set<KotlinTarget>> getPossibleTargetMap() {
        return possibleTargetMap;
    }

    public final boolean isPossibleParentTarget(@NotNull KtModifierKeywordToken modifier, @NotNull KotlinTarget parentTarget, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        Intrinsics.checkNotNullParameter((Object)parentTarget, "parentTarget");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Object object2 = deprecatedParentTargetMap.get(modifier);
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            if (it.contains((Object)parentTarget)) {
                return false;
            }
        }
        object2 = possibleParentTargetPredicateMap.get(modifier);
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            return it.isAllowed(parentTarget, languageVersionSettings);
        }
        return true;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> buildCompatibilityMap() {
        boolean bl = false;
        HashMap result2 = new HashMap();
        Map map = result2;
        Object object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "IN_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OUT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OUT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl2 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken2;
        ktModifierKeywordToken2 = KtTokens.PROTECTED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "PROTECTED_KEYWORD");
        object[1] = ktModifierKeywordToken2;
        ktModifierKeywordToken2 = KtTokens.PUBLIC_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "PUBLIC_KEYWORD");
        object[2] = ktModifierKeywordToken2;
        ktModifierKeywordToken2 = KtTokens.INTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "INTERNAL_KEYWORD");
        object[3] = ktModifierKeywordToken2;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl3 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "ABSTRACT_KEYWORD");
        object[0] = ktModifierKeywordToken3;
        ktModifierKeywordToken3 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken3;
        ktModifierKeywordToken3 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "FINAL_KEYWORD");
        object[2] = ktModifierKeywordToken3;
        ktModifierKeywordToken3 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "SEALED_KEYWORD");
        object[3] = ktModifierKeywordToken3;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl4 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken4, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken4;
        ktModifierKeywordToken4 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken4, "OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken4;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl5 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken5, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken5;
        ktModifierKeywordToken5 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken5, "INNER_KEYWORD");
        object[1] = ktModifierKeywordToken5;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl6 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken6, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken6;
        ktModifierKeywordToken6 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken6, "ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken6;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl7 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken7, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken7;
        ktModifierKeywordToken7 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken7, "SEALED_KEYWORD");
        object[1] = ktModifierKeywordToken7;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl8 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken8, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken8;
        ktModifierKeywordToken8 = KtTokens.INLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken8, "INLINE_KEYWORD");
        object[1] = ktModifierKeywordToken8;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl9 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken9 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken9, "DATA_KEYWORD");
        object[0] = ktModifierKeywordToken9;
        ktModifierKeywordToken9 = KtTokens.VALUE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken9, "VALUE_KEYWORD");
        object[1] = ktModifierKeywordToken9;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl10 = false;
        map.putAll(object);
        map = result2;
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(object, "ABSTRACT_KEYWORD");
        Object object2 = object;
        object = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(object, "OPEN_KEYWORD");
        object = this.redundantRegister((KtModifierKeywordToken)object2, (KtModifierKeywordToken)object);
        bl10 = false;
        map.putAll(object);
        map = result2;
        object = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(object, "SEALED_KEYWORD");
        Object object3 = object;
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(object, "ABSTRACT_KEYWORD");
        object = this.redundantRegister((KtModifierKeywordToken)object3, (KtModifierKeywordToken)object);
        bl10 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken10 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken10, "CONST_KEYWORD");
        object[0] = ktModifierKeywordToken10;
        ktModifierKeywordToken10 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken10, "ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken10;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl11 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken11 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken11, "CONST_KEYWORD");
        object[0] = ktModifierKeywordToken11;
        ktModifierKeywordToken11 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken11, "OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken11;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl12 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken12 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken12, "CONST_KEYWORD");
        object[0] = ktModifierKeywordToken12;
        ktModifierKeywordToken12 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken12, "OVERRIDE_KEYWORD");
        object[1] = ktModifierKeywordToken12;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl13 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken13 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken13, "PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken13;
        ktModifierKeywordToken13 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken13, "OVERRIDE_KEYWORD");
        object[1] = ktModifierKeywordToken13;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl14 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken14 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken14, "PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken14;
        ktModifierKeywordToken14 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken14, "OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken14;
        object = this.compatibilityForClassesRegister((KtModifierKeywordToken)object);
        boolean bl15 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken15 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken15, "PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken15;
        ktModifierKeywordToken15 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken15, "ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken15;
        object = this.compatibilityForClassesRegister((KtModifierKeywordToken)object);
        boolean bl16 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken16 = KtTokens.CROSSINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken16, "CROSSINLINE_KEYWORD");
        object[0] = ktModifierKeywordToken16;
        ktModifierKeywordToken16 = KtTokens.NOINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken16, "NOINLINE_KEYWORD");
        object[1] = ktModifierKeywordToken16;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl17 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken17 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken17, "SEALED_KEYWORD");
        object[0] = ktModifierKeywordToken17;
        ktModifierKeywordToken17 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken17, "INNER_KEYWORD");
        object[1] = ktModifierKeywordToken17;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl18 = false;
        map.putAll(object);
        map = result2;
        object = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken18 = KtTokens.HEADER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken18, "HEADER_KEYWORD");
        object[0] = ktModifierKeywordToken18;
        ktModifierKeywordToken18 = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken18, "EXPECT_KEYWORD");
        object[1] = ktModifierKeywordToken18;
        ktModifierKeywordToken18 = KtTokens.IMPL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken18, "IMPL_KEYWORD");
        object[2] = ktModifierKeywordToken18;
        ktModifierKeywordToken18 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken18, "ACTUAL_KEYWORD");
        object[3] = ktModifierKeywordToken18;
        object = this.incompatibilityRegister((KtModifierKeywordToken)object);
        boolean bl19 = false;
        map.putAll(object);
        return result2;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> redundantRegister(KtModifierKeywordToken sufficient, KtModifierKeywordToken redundant) {
        Pair[] pairArray = new Pair[]{TuplesKt.to(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(sufficient, redundant), Compatibility.REDUNDANT), TuplesKt.to(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(redundant, sufficient), Compatibility.REVERSE_REDUNDANT)};
        return MapsKt.mapOf(pairArray);
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> compatibilityRegister(Compatibility compatibility, KtModifierKeywordToken ... list2) {
        boolean bl = false;
        HashMap result2 = new HashMap();
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = list2;
        int n = 0;
        int n2 = ktModifierKeywordTokenArray.length;
        while (n < n2) {
            KtModifierKeywordToken first = ktModifierKeywordTokenArray[n];
            ++n;
            for (KtModifierKeywordToken second : list2) {
                if (Intrinsics.areEqual(first, second)) continue;
                Map map = result2;
                Pair<KtModifierKeywordToken, KtModifierKeywordToken> pair = new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(first, second);
                boolean bl2 = false;
                map.put(pair, compatibility);
            }
        }
        return result2;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> compatibilityForClassesRegister(KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[list2.length];
        System.arraycopy(list2, 0, ktModifierKeywordTokenArray, 0, list2.length);
        return this.compatibilityRegister(Compatibility.COMPATIBLE_FOR_CLASSES_ONLY, ktModifierKeywordTokenArray);
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> incompatibilityRegister(KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[list2.length];
        System.arraycopy(list2, 0, ktModifierKeywordTokenArray, 0, list2.length);
        return this.compatibilityRegister(Compatibility.INCOMPATIBLE, ktModifierKeywordTokenArray);
    }

    private final Compatibility compatibility(KtModifierKeywordToken first, KtModifierKeywordToken second) {
        Compatibility compatibility;
        return Intrinsics.areEqual(first, second) ? Compatibility.REPEATED : ((compatibility = mutualCompatibility.get(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(first, second))) == null ? Compatibility.COMPATIBLE : compatibility);
    }

    private final void checkCompatibility(BindingTrace trace, ASTNode firstNode, ASTNode secondNode, PsiElement owner, Set<ASTNode> incorrectNodes) {
        Compatibility compatibility;
        KtModifierKeywordToken first = (KtModifierKeywordToken)firstNode.getElementType();
        KtModifierKeywordToken second = (KtModifierKeywordToken)secondNode.getElementType();
        Compatibility compatibility2 = compatibility = this.compatibility(first, second);
        int n = WhenMappings.$EnumSwitchMapping$0[compatibility2.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.REPEATED_MODIFIER.on(secondNode.getPsi(), first));
                break;
            }
            case 3: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(secondNode.getPsi(), second, first));
                break;
            }
            case 4: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(firstNode.getPsi(), first, second));
                break;
            }
            case 5: {
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(firstNode.getPsi(), first, second));
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(secondNode.getPsi(), second, first));
                break;
            }
            case 6: 
            case 7: {
                if (compatibility == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof KtClassOrObject) {
                    return;
                }
                if (incorrectNodes.add(firstNode)) {
                    trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(firstNode.getPsi(), first, second));
                }
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(secondNode.getPsi(), second, first));
            }
        }
    }

    private final boolean checkTarget(BindingTrace trace, ASTNode node, List<? extends KotlinTarget> actualTargets) {
        Object element$iv;
        Set<KotlinTarget> set;
        boolean bl;
        Object $this$any$iv;
        KtModifierKeywordToken modifier;
        block15: {
            modifier = (KtModifierKeywordToken)node.getElementType();
            Set<KotlinTarget> set2 = possibleTargetMap.get(modifier);
            Set<Object> possibleTargets = set2 == null ? SetsKt.emptySet() : set2;
            $this$any$iv = actualTargets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                set = $this$any$iv.iterator();
                while (set.hasNext()) {
                    element$iv = set.next();
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!possibleTargets.contains((Object)it)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (!bl) {
            String $i$f$any;
            trace.report(Errors.WRONG_MODIFIER_TARGET.on(node.getPsi(), modifier, ($this$any$iv = CollectionsKt.firstOrNull(actualTargets)) == null ? "this" : (($i$f$any = ((KotlinTarget)((Object)$this$any$iv)).getDescription()) == null ? "this" : $i$f$any)));
            return false;
        }
        KtModifierKeywordToken deprecatedModifierReplacement = deprecatedModifierMap.get(modifier);
        set = deprecatedTargetMap.get(modifier);
        Object deprecatedTargets = set == null ? SetsKt.emptySet() : set;
        element$iv = redundantTargetMap.get(modifier);
        Set<Object> redundantTargets = element$iv == null ? SetsKt.emptySet() : element$iv;
        if (deprecatedModifierReplacement != null) {
            trace.report(Errors.DEPRECATED_MODIFIER.on(node.getPsi(), modifier, deprecatedModifierReplacement));
        } else {
            KotlinTarget it;
            Object element$iv2;
            boolean bl3;
            boolean $i$f$any2;
            Object $this$any$iv2;
            block16: {
                $this$any$iv2 = actualTargets;
                $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl3 = false;
                } else {
                    Iterator iterator2 = $this$any$iv2.iterator();
                    while (iterator2.hasNext()) {
                        element$iv2 = iterator2.next();
                        it = (KotlinTarget)((Object)element$iv2);
                        boolean bl4 = false;
                        if (!deprecatedTargets.contains((Object)it)) continue;
                        bl3 = true;
                        break block16;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                String $i$f$any2;
                trace.report(Errors.DEPRECATED_MODIFIER_FOR_TARGET.on(node.getPsi(), modifier, ($this$any$iv2 = CollectionsKt.firstOrNull(actualTargets)) == null ? "this" : (($i$f$any2 = ((KotlinTarget)((Object)$this$any$iv2)).getDescription()) == null ? "this" : $i$f$any2)));
            } else {
                boolean bl5;
                block17: {
                    $this$any$iv2 = actualTargets;
                    $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl5 = false;
                    } else {
                        Iterator iterator3 = $this$any$iv2.iterator();
                        while (iterator3.hasNext()) {
                            element$iv2 = iterator3.next();
                            it = (KotlinTarget)((Object)element$iv2);
                            boolean bl6 = false;
                            if (!redundantTargets.contains((Object)it)) continue;
                            bl5 = true;
                            break block17;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) {
                    String string2;
                    KotlinTarget kotlinTarget;
                    trace.report(Errors.REDUNDANT_MODIFIER_FOR_TARGET.on(node.getPsi(), modifier, (kotlinTarget = CollectionsKt.firstOrNull(actualTargets)) == null ? "this" : ((string2 = kotlinTarget.getDescription()) == null ? "this" : string2)));
                }
            }
        }
        return true;
    }

    private final boolean checkLanguageLevelSupport(BindingTrace trace, ASTNode node, LanguageVersionSettings languageVersionSettings, List<? extends KotlinTarget> actualTargets) {
        KtModifierKeywordToken modifier = (KtModifierKeywordToken)node.getElementType();
        List<LanguageFeature> list2 = featureDependencies.get(modifier);
        if (list2 == null) {
            return true;
        }
        List<LanguageFeature> dependencies2 = list2;
        block5: for (LanguageFeature dependency : dependencies2) {
            Set<KotlinTarget> restrictedTargets = featureDependenciesTargets.get((Object)dependency);
            if (restrictedTargets != null && CollectionsKt.intersect((Iterable)actualTargets, (Iterable)restrictedTargets).isEmpty()) continue;
            LanguageFeature.State featureSupport = languageVersionSettings.getFeatureSupport(dependency);
            if (dependency == LanguageFeature.Coroutines) {
                DiagnosticSink diagnosticSink = trace;
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue(psiElement, "node.psi");
                CoroutineCallCheckerKt.checkCoroutinesFeature(languageVersionSettings, diagnosticSink, psiElement);
                continue;
            }
            Pair<LanguageFeature, LanguageVersionSettings> diagnosticData = TuplesKt.to(dependency, languageVersionSettings);
            LanguageFeature.State state = featureSupport;
            int n = WhenMappings.$EnumSwitchMapping$1[state.ordinal()];
            switch (n) {
                case 1: {
                    trace.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(node.getPsi(), diagnosticData));
                    continue block5;
                }
                case 2: {
                    trace.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(node.getPsi(), diagnosticData));
                    return false;
                }
                case 3: {
                    trace.report(Errors.UNSUPPORTED_FEATURE.on(node.getPsi(), diagnosticData));
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean checkParent(BindingTrace trace, ASTNode node, DeclarationDescriptor parentDescriptor, LanguageVersionSettings languageVersionSettings) {
        String string2;
        KotlinTarget kotlinTarget;
        boolean bl;
        List<KotlinTarget> actualParents;
        KtModifierKeywordToken modifier;
        block11: {
            TargetAllowedPredicate $i$f$any2;
            modifier = (KtModifierKeywordToken)node.getElementType();
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            actualParents = declarationDescriptor instanceof ClassDescriptor ? KotlinTarget.Companion.classActualTargets((ClassDescriptor)parentDescriptor) : (declarationDescriptor instanceof PropertySetterDescriptor ? CollectionsKt.listOf(KotlinTarget.PROPERTY_SETTER) : (declarationDescriptor instanceof PropertyGetterDescriptor ? CollectionsKt.listOf(KotlinTarget.PROPERTY_GETTER) : (declarationDescriptor instanceof FunctionDescriptor ? CollectionsKt.listOf(KotlinTarget.FUNCTION) : CollectionsKt.listOf(KotlinTarget.FILE))));
            Set<KotlinTarget> deprecatedParents = deprecatedParentTargetMap.get(modifier);
            if (deprecatedParents != null) {
                boolean bl2;
                Object $this$any$iv;
                block10: {
                    $this$any$iv = actualParents;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    String $i$f$any2;
                    trace.report(Errors.DEPRECATED_MODIFIER_CONTAINING_DECLARATION.on(node.getPsi(), modifier, ($this$any$iv = CollectionsKt.firstOrNull(actualParents)) == null ? "this scope" : (($i$f$any2 = ((KotlinTarget)((Object)$this$any$iv)).getDescription()) == null ? "this scope" : $i$f$any2)));
                    return true;
                }
            }
            if (($i$f$any2 = possibleParentTargetPredicateMap.get(modifier)) == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = $i$f$any2;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any3 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, languageVersionSettings)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(node.getPsi(), modifier, (kotlinTarget = CollectionsKt.firstOrNull(actualParents)) == null ? "this scope" : ((string2 = kotlinTarget.getDescription()) == null ? "this scope" : string2)));
        return false;
    }

    private final void checkModifierList(KtModifierList list2, BindingTrace trace, DeclarationDescriptor parentDescriptor, List<? extends KotlinTarget> actualTargets, LanguageVersionSettings languageVersionSettings) {
        if (list2.getStub() != null) {
            return;
        }
        boolean bl = false;
        HashSet incorrectNodes = new HashSet();
        ASTNode[] children2 = list2.getNode().getChildren(MODIFIER_KEYWORD_SET);
        Intrinsics.checkNotNullExpressionValue(children2, "children");
        ASTNode[] aSTNodeArray = children2;
        int n = 0;
        int n2 = aSTNodeArray.length;
        while (n < n2) {
            int n3;
            Object object;
            ASTNode second = aSTNodeArray[n];
            ++n;
            for (ASTNode first : children2) {
                if (Intrinsics.areEqual(first, second)) break;
                Intrinsics.checkNotNullExpressionValue(first, "first");
                Intrinsics.checkNotNullExpressionValue(second, "second");
                PsiElement psiElement = list2.getOwner();
                Intrinsics.checkNotNullExpressionValue(psiElement, "list.owner");
                this.checkCompatibility(trace, first, second, psiElement, incorrectNodes);
            }
            if (incorrectNodes.contains(second)) continue;
            Intrinsics.checkNotNullExpressionValue(second, "second");
            if (!this.checkTarget(trace, second, actualTargets)) {
                object = incorrectNodes;
                n3 = 0;
                object.add(second);
                continue;
            }
            if (!this.checkParent(trace, second, parentDescriptor, languageVersionSettings)) {
                object = incorrectNodes;
                n3 = 0;
                object.add(second);
                continue;
            }
            if (this.checkLanguageLevelSupport(trace, second, languageVersionSettings, actualTargets)) continue;
            object = incorrectNodes;
            n3 = 0;
            object.add(second);
        }
    }

    public final void check(@NotNull KtModifierListOwner listOwner, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(listOwner, "listOwner");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (listOwner instanceof KtDeclarationWithBody) {
            for (KtParameter ktParameter : ((KtDeclarationWithBody)listOwner).getValueParameters()) {
                if (ktParameter.hasValOrVar()) continue;
                Intrinsics.checkNotNullExpressionValue(ktParameter, "parameter");
                this.check(ktParameter, trace, (DeclarationDescriptor)trace.get(BindingContext.VALUE_PARAMETER, ktParameter), languageVersionSettings);
            }
        }
        KtElement ktElement = listOwner;
        ClassDescriptor classDescriptor2 = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        List<KotlinTarget> actualTargets = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, classDescriptor2, bindingContext);
        KtModifierList ktModifierList = listOwner.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        Object object = ktModifierList;
        KtModifierList ktModifierList2 = object;
        object = descriptor2;
        this.checkModifierList(ktModifierList2, trace, object == null ? null : object.getContainingDeclaration(), actualTargets, languageVersionSettings);
    }

    static {
        Object[] objectArray = new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.TYPEALIAS};
        defaultVisibilityTargets = EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum[])objectArray);
        objectArray = new Pair[34];
        objectArray[0] = TuplesKt.to(KtTokens.ENUM_KEYWORD, EnumSet.of((Enum)KotlinTarget.ENUM_CLASS));
        objectArray[1] = TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.INTERFACE, (Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION));
        objectArray[2] = TuplesKt.to(KtTokens.OPEN_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.INTERFACE, (Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION));
        Object[] objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.OBJECT, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.MEMBER_FUNCTION};
        objectArray[3] = TuplesKt.to(KtTokens.FINAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum[])objectArray2));
        objectArray[4] = TuplesKt.to(KtTokens.SEALED_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.INTERFACE));
        objectArray[5] = TuplesKt.to(KtTokens.INNER_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY));
        objectArray[6] = TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION));
        objectArray[7] = TuplesKt.to(KtTokens.PRIVATE_KEYWORD, defaultVisibilityTargets);
        objectArray[8] = TuplesKt.to(KtTokens.PUBLIC_KEYWORD, defaultVisibilityTargets);
        objectArray[9] = TuplesKt.to(KtTokens.INTERNAL_KEYWORD, defaultVisibilityTargets);
        objectArray2 = new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.TYPEALIAS};
        objectArray[10] = TuplesKt.to(KtTokens.PROTECTED_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum[])objectArray2));
        objectArray[11] = TuplesKt.to(KtTokens.IN_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION));
        objectArray[12] = TuplesKt.to(KtTokens.OUT_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION));
        objectArray[13] = TuplesKt.to(KtTokens.REIFIED_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER));
        objectArray[14] = TuplesKt.to(KtTokens.VARARG_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER, (Enum)KotlinTarget.PROPERTY_PARAMETER));
        objectArray[15] = TuplesKt.to(KtTokens.COMPANION_KEYWORD, EnumSet.of((Enum)KotlinTarget.OBJECT));
        objectArray[16] = TuplesKt.to(KtTokens.LATEINIT_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.TOP_LEVEL_PROPERTY, (Enum)KotlinTarget.LOCAL_VARIABLE));
        objectArray[17] = TuplesKt.to(KtTokens.DATA_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS));
        objectArray[18] = TuplesKt.to(KtTokens.INLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION, (Enum)KotlinTarget.PROPERTY, (Enum)KotlinTarget.PROPERTY_GETTER, (Enum)KotlinTarget.PROPERTY_SETTER, (Enum)KotlinTarget.CLASS_ONLY));
        objectArray[19] = TuplesKt.to(KtTokens.NOINLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER));
        objectArray[20] = TuplesKt.to(KtTokens.TAILREC_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION));
        objectArray[21] = TuplesKt.to(KtTokens.SUSPEND_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_FUNCTION, (Enum)KotlinTarget.TOP_LEVEL_FUNCTION, (Enum)KotlinTarget.LOCAL_FUNCTION));
        objectArray[22] = TuplesKt.to(KtTokens.EXTERNAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION, (Enum)KotlinTarget.PROPERTY, (Enum)KotlinTarget.PROPERTY_GETTER, (Enum)KotlinTarget.PROPERTY_SETTER, (Enum)KotlinTarget.CLASS));
        objectArray[23] = TuplesKt.to(KtTokens.ANNOTATION_KEYWORD, EnumSet.of((Enum)KotlinTarget.ANNOTATION_CLASS));
        objectArray[24] = TuplesKt.to(KtTokens.CROSSINLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER));
        objectArray[25] = TuplesKt.to(KtTokens.CONST_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.TOP_LEVEL_PROPERTY));
        objectArray[26] = TuplesKt.to(KtTokens.OPERATOR_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION));
        objectArray[27] = TuplesKt.to(KtTokens.INFIX_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION));
        objectArray2 = new KotlinTarget[]{KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS};
        objectArray[28] = TuplesKt.to(KtTokens.HEADER_KEYWORD, EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, (Enum[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TYPEALIAS};
        objectArray[29] = TuplesKt.to(KtTokens.IMPL_KEYWORD, EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, (Enum[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS};
        objectArray[30] = TuplesKt.to(KtTokens.EXPECT_KEYWORD, EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, (Enum[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TYPEALIAS};
        objectArray[31] = TuplesKt.to(KtTokens.ACTUAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, (Enum[])objectArray2));
        objectArray[32] = TuplesKt.to(KtTokens.FUN_KEYWORD, EnumSet.of((Enum)KotlinTarget.INTERFACE));
        objectArray[33] = TuplesKt.to(KtTokens.VALUE_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY));
        possibleTargetMap = MapsKt.mapOf(objectArray);
        objectArray = new Pair[8];
        objectArray[0] = TuplesKt.to(KtTokens.SUSPEND_KEYWORD, CollectionsKt.listOf(LanguageFeature.Coroutines));
        objectArray2 = new LanguageFeature[]{LanguageFeature.InlineProperties, LanguageFeature.InlineClasses};
        objectArray[1] = TuplesKt.to(KtTokens.INLINE_KEYWORD, CollectionsKt.listOf(objectArray2));
        objectArray[2] = TuplesKt.to(KtTokens.HEADER_KEYWORD, CollectionsKt.listOf(LanguageFeature.MultiPlatformProjects));
        objectArray[3] = TuplesKt.to(KtTokens.IMPL_KEYWORD, CollectionsKt.listOf(LanguageFeature.MultiPlatformProjects));
        objectArray[4] = TuplesKt.to(KtTokens.EXPECT_KEYWORD, CollectionsKt.listOf(LanguageFeature.MultiPlatformProjects));
        objectArray[5] = TuplesKt.to(KtTokens.ACTUAL_KEYWORD, CollectionsKt.listOf(LanguageFeature.MultiPlatformProjects));
        objectArray2 = new LanguageFeature[]{LanguageFeature.LateinitTopLevelProperties, LanguageFeature.LateinitLocalVariables};
        objectArray[6] = TuplesKt.to(KtTokens.LATEINIT_KEYWORD, CollectionsKt.listOf(objectArray2));
        objectArray[7] = TuplesKt.to(KtTokens.FUN_KEYWORD, CollectionsKt.listOf(LanguageFeature.FunctionalInterfaceConversion));
        featureDependencies = MapsKt.mapOf(objectArray);
        objectArray = new Pair[6];
        objectArray2 = new KotlinTarget[]{KotlinTarget.PROPERTY, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER};
        objectArray[0] = TuplesKt.to(LanguageFeature.InlineProperties, SetsKt.setOf(objectArray2));
        objectArray[1] = TuplesKt.to(LanguageFeature.LateinitLocalVariables, SetsKt.setOf(KotlinTarget.LOCAL_VARIABLE));
        objectArray[2] = TuplesKt.to(LanguageFeature.LateinitTopLevelProperties, SetsKt.setOf(KotlinTarget.TOP_LEVEL_PROPERTY));
        objectArray[3] = TuplesKt.to(LanguageFeature.InlineClasses, SetsKt.setOf(KotlinTarget.CLASS_ONLY));
        objectArray[4] = TuplesKt.to(LanguageFeature.JvmInlineValueClasses, SetsKt.setOf(KotlinTarget.CLASS_ONLY));
        objectArray[5] = TuplesKt.to(LanguageFeature.FunctionalInterfaceConversion, SetsKt.setOf(KotlinTarget.INTERFACE));
        featureDependenciesTargets = MapsKt.mapOf(objectArray);
        boolean bl = false;
        deprecatedTargetMap = MapsKt.emptyMap();
        Pair[] pairArray = new Pair[]{TuplesKt.to(KtTokens.HEADER_KEYWORD, KtTokens.EXPECT_KEYWORD), TuplesKt.to(KtTokens.IMPL_KEYWORD, KtTokens.ACTUAL_KEYWORD)};
        deprecatedModifierMap = MapsKt.mapOf(pairArray);
        redundantTargetMap = MapsKt.mapOf(TuplesKt.to(KtTokens.OPEN_KEYWORD, EnumSet.of((Enum)KotlinTarget.INTERFACE)));
        pairArray = new Pair[8];
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.ENUM_CLASS};
        pairArray[0] = TuplesKt.to(KtTokens.INNER_KEYWORD, ModifiersCheckerKt.access$or(ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2), ModifiersCheckerKt.access$ifSupported(LanguageFeature.InnerClassInEnumEntryClass, KotlinTarget.ENUM_ENTRY, new KotlinTarget[0])));
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY};
        pairArray[1] = TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.COMPANION_OBJECT};
        pairArray[2] = TuplesKt.to(KtTokens.PROTECTED_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE};
        pairArray[3] = TuplesKt.to(KtTokens.INTERNAL_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE};
        pairArray[4] = TuplesKt.to(KtTokens.PRIVATE_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS};
        pairArray[5] = TuplesKt.to(KtTokens.COMPANION_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.FILE};
        pairArray[6] = TuplesKt.to(KtTokens.FINAL_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CLASS_ONLY, (KotlinTarget[])objectArray2));
        objectArray2 = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.CLASS};
        pairArray[7] = TuplesKt.to(KtTokens.VARARG_KEYWORD, ModifiersCheckerKt.access$always(KotlinTarget.CONSTRUCTOR, (KotlinTarget[])objectArray2));
        possibleParentTargetPredicateMap = MapsKt.mapOf(pairArray);
        boolean bl2 = false;
        deprecatedParentTargetMap = MapsKt.emptyMap();
        mutualCompatibility = INSTANCE.buildCompatibilityMap();
        objectArray2 = new TokenSet[2];
        objectArray2[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        objectArray2[1] = TokenSet.create(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])objectArray2);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "orSet(SOFT_KEYWORDS, TokenSet.create(IN_KEYWORD, FUN_KEYWORD))");
        MODIFIER_KEYWORD_SET = tokenSet;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "", "(Ljava/lang/String;I)V", "COMPATIBLE", "REDUNDANT", "REVERSE_REDUNDANT", "REPEATED", "DEPRECATED", "INCOMPATIBLE", "COMPATIBLE_FOR_CLASSES_ONLY", "frontend"})
    private static final class Compatibility
    extends Enum<Compatibility> {
        public static final /* enum */ Compatibility COMPATIBLE = new Compatibility();
        public static final /* enum */ Compatibility REDUNDANT = new Compatibility();
        public static final /* enum */ Compatibility REVERSE_REDUNDANT = new Compatibility();
        public static final /* enum */ Compatibility REPEATED = new Compatibility();
        public static final /* enum */ Compatibility DEPRECATED = new Compatibility();
        public static final /* enum */ Compatibility INCOMPATIBLE = new Compatibility();
        public static final /* enum */ Compatibility COMPATIBLE_FOR_CLASSES_ONLY = new Compatibility();
        private static final /* synthetic */ Compatibility[] $VALUES;

        public static Compatibility[] values() {
            Compatibility[] compatibilityArray = $VALUES;
            Compatibility[] compatibilityArray2 = new Compatibility[compatibilityArray.length];
            System.arraycopy(compatibilityArray, 0, compatibilityArray2, 0, compatibilityArray.length);
            return compatibilityArray2;
        }

        public static Compatibility valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(Compatibility.class, value2);
        }

        static {
            Compatibility[] compatibilityArray = new Compatibility[]{COMPATIBLE, REDUNDANT, REVERSE_REDUNDANT, REPEATED, DEPRECATED, INCOMPATIBLE, COMPATIBLE_FOR_CLASSES_ONLY};
            $VALUES = compatibilityArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Compatibility.values().length];
            nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            nArray[Compatibility.REPEATED.ordinal()] = 2;
            nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 6;
            nArray[Compatibility.INCOMPATIBLE.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LanguageFeature.State.values().length];
            nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 1;
            nArray[LanguageFeature.State.ENABLED_WITH_ERROR.ordinal()] = 2;
            nArray[LanguageFeature.State.DISABLED.ordinal()] = 3;
            nArray[LanguageFeature.State.ENABLED.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

