/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class SunMoonCalculator {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_HOUR = 3.8197186342054885;
    public static final double RAD_TO_DAY = 0.15915494309189535;
    public static final double AU = 1.49597870691E8;
    public static final double EARTH_RADIUS = 6378.1366;
    public static final double TWO_PI = Math.PI * 2;
    public static final double TWO_PI_INVERSE = 0.15915494309189535;
    public static final double FOUR_PI = Math.PI * 4;
    public static final double PI_OVER_TWO = 1.5707963267948966;
    public static final double SIDEREAL_DAY_LENGTH = 1.0027378119113546;
    public static final double JULIAN_DAYS_PER_CENTURY = 36525.0;
    public static final double SECONDS_PER_DAY = 86400.0;
    public static final double J2000 = 2451545.0;
    private ZonedDateTime sunriseZDT;
    private ZonedDateTime sunsetZDT;
    private ZonedDateTime sunriseGoldenHourZDT;
    private ZonedDateTime sunsetGoldenHourZDT;
    private ZonedDateTime sunriseCivilZDT;
    private ZonedDateTime sunsetCivilZDT;
    private ZonedDateTime sunriseBlueHourZDT;
    private ZonedDateTime sunsetBlueHourZDT;
    public double sunAz;
    public double sunEl;
    public double sunrise;
    public double sunset;
    public double sunTransit;
    public double sunTransitElev;
    public double sunDist;
    public double moonAz;
    public double moonEl;
    public double moonRise;
    public double moonSet;
    public double moonTransit;
    public double moonAge;
    public double moonTransitElev;
    public double moonDist;
    private double jd_UT = 0.0;
    private double t = 0.0;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double ttMinusUT = 0.0;
    private TWILIGHT twilight = TWILIGHT.HORIZON_34arcmin;
    private double slongitude = 0.0;
    private double sanomaly = 0.0;

    public SunMoonCalculator(int YEAR, int MONTH, int DAY, double LAT_DEG, double LNG_DEG) throws Exception {
        this(YEAR, MONTH, DAY, 0, 0, 0, LAT_DEG, LNG_DEG);
    }

    public SunMoonCalculator(int year, int month, int day, int h2, int m3, int s2, double latDeg, double lngDeg) throws Exception {
        this.sunriseZDT = ZonedDateTime.now();
        this.sunsetZDT = ZonedDateTime.now();
        this.sunriseGoldenHourZDT = ZonedDateTime.now();
        this.sunsetGoldenHourZDT = ZonedDateTime.now();
        this.sunriseCivilZDT = ZonedDateTime.now();
        this.sunsetCivilZDT = ZonedDateTime.now();
        this.sunriseBlueHourZDT = ZonedDateTime.now();
        this.sunsetBlueHourZDT = ZonedDateTime.now();
        this.latitude = lngDeg * (Math.PI / 180);
        this.longitude = latDeg * (Math.PI / 180);
        this.setDate(year, month, day, h2, m3, s2);
    }

    public static int[] getDate(double JULIAN_DAY) throws Exception {
        if (JULIAN_DAY < 2299160.0 && JULIAN_DAY >= 2299150.0) {
            throw new Exception("invalid julian day " + JULIAN_DAY + ". This date does not exist.");
        }
        double Z = Math.floor(JULIAN_DAY + 0.5);
        double F = JULIAN_DAY + 0.5 - Z;
        double A2 = Z;
        if (Z >= 2299161.0) {
            int a = (int)((Z - 1867216.25) / 36524.25);
            A2 += (double)(1 + a - a / 4);
        }
        double B = A2 + 1524.0;
        int C2 = (int)((B - 122.1) / 365.25);
        int D = (int)((double)C2 * 365.25);
        int E = (int)((B - (double)D) / 30.6001);
        double exactDay = F + B - (double)D - (double)((int)(30.6001 * (double)E));
        int day = (int)exactDay;
        int month = E < 14 ? E - 1 : E - 13;
        int year = C2 - 4715;
        if (month > 2) {
            // empty if block
        }
        double h2 = (exactDay - (double)day) * 86400.0 / 3600.0;
        int hour = (int)h2;
        double m3 = (h2 - (double)hour) * 60.0;
        int minute = (int)m3;
        int second = (int)((m3 - (double)minute) * 60.0);
        return new int[]{--year, month, day, hour, minute, second};
    }

    public static ZonedDateTime getZonedDateTime(double JULIAN_DAY, ZoneOffset ZONE_OFFSET) throws Exception {
        int[] date = SunMoonCalculator.getDate(JULIAN_DAY);
        int timeZoneOffset = ZONE_OFFSET.getTotalSeconds() / 3600;
        ZoneId zoneId = ZoneId.ofOffset("UTC", ZONE_OFFSET);
        return ZonedDateTime.of(date[0], date[1], date[2], (date[3] + timeZoneOffset) % 24, date[4], date[5], 0, zoneId);
    }

    public static String getDateAsString(double JULIAN_DAY) throws Exception {
        return SunMoonCalculator.getDateAsString(JULIAN_DAY, 0);
    }

    public static String getDateAsString(double JULIAN_DAY, int TIMEZONE_OFFSET) throws Exception {
        if (JULIAN_DAY == -1.0) {
            return "NO RISE/SET/TRANSIT FOR THIS OBSERVER/DATE";
        }
        int[] date = SunMoonCalculator.getDate(JULIAN_DAY);
        return date[0] + "/" + date[1] + "/" + date[2] + " " + (date[3] + TIMEZONE_OFFSET) % 24 + ":" + date[4] + ":" + date[5] + " UT";
    }

    public static double normalizeRadians(double r) {
        if (r < 0.0 && r >= Math.PI * -2) {
            return r + Math.PI * 2;
        }
        if (r >= Math.PI * 2 && r < Math.PI * 4) {
            return r - Math.PI * 2;
        }
        if (r >= 0.0 && r < Math.PI * 2) {
            return r;
        }
        if ((r -= Math.PI * 2 * Math.floor(r * 0.15915494309189535)) < 0.0) {
            r += Math.PI * 2;
        }
        return r;
    }

    public void setTwilight(TWILIGHT T) {
        this.twilight = T;
    }

    private void setUTDate(double JULIAN_DAY) {
        this.jd_UT = JULIAN_DAY;
        this.t = (JULIAN_DAY + this.ttMinusUT / 86400.0 - 2451545.0) / 36525.0;
    }

    public void setDate(LocalDate DATE2) throws Exception {
        this.setDate(DATE2.getYear(), DATE2.getMonthValue(), DATE2.getDayOfMonth());
    }

    public void setDate(LocalDateTime DATE_TIME) throws Exception {
        this.setDate(DATE_TIME.getYear(), DATE_TIME.getMonthValue(), DATE_TIME.getDayOfMonth(), DATE_TIME.getHour(), DATE_TIME.getMinute(), DATE_TIME.getSecond());
    }

    public void setDate(int year, int month, int day) throws Exception {
        this.setDate(year, month, day, 0, 0, 0);
    }

    public void setDate(int year, int month, int day, int h2, int m3, int s2) throws Exception {
        boolean julian = false;
        if (year < 1582 || year == 1582 && month <= 10 || year == 1582 && month == 10 && day < 15) {
            julian = true;
        }
        if (month < 3) {
            --year;
            month += 12;
        }
        int A2 = year / 100;
        double dayFraction = ((double)h2 + ((double)m3 + (double)s2 / 60.0) / 60.0) / 24.0;
        int B = julian ? 0 : 2 - A2 + A2 / 4;
        double jd = dayFraction + (double)((int)(365.25 * (double)(year + 4716))) + (double)((int)(30.6001 * (double)(month + 1))) + (double)day + (double)B - 1524.5;
        if (jd < 2299160.0 && jd >= 2299150.0) {
            throw new Exception("invalid julian day " + jd + ". This date does not exist.");
        }
        this.ttMinusUT = 0.0;
        if (year > -600 && year < 2200) {
            double x = (double)year + ((double)(month - 1) + (double)day / 30.0) / 12.0;
            double x2 = x * x;
            double x3 = x2 * x;
            double x4 = x3 * x;
            this.ttMinusUT = year < 1600 ? 10535.328003326353 - 9.995238627481024 * x + 0.003067307630020489 * x2 - 7.76340698361363E-6 * x3 + 3.1331045394223196E-9 * x4 + 8.225530854405553E-12 * x2 * x3 - 7.486164715632051E-15 * x4 * x2 + 1.9362461549678834E-18 * x4 * x3 - 8.489224937827653E-23 * x4 * x4 : -1027175.3477559977 + 2523.256625418965 * x - 1.885686849058459 * x2 + 5.869246227888417E-5 * x3 + 3.3379295816475025E-7 * x4 + 1.7758961671447929E-10 * x2 * x3 - 2.7889902806153024E-13 * x2 * x4 + 1.0224295822336825E-16 * x3 * x4 - 1.2528102370680435E-20 * x4 * x4;
        }
        this.setUTDate(jd);
    }

    public void calcSunAndMoon() {
        double jd = this.jd_UT;
        double[] out = this.doCalc(this.getSun());
        this.sunAz = out[0];
        this.sunEl = out[1];
        this.sunrise = out[2];
        this.sunset = out[3];
        this.sunTransit = out[4];
        this.sunTransitElev = out[5];
        this.sunDist = out[8];
        double sa = this.sanomaly;
        double sl = this.slongitude;
        int niter = 3;
        this.sunrise = this.obtainAccurateRiseSetTransit(this.sunrise, 2, niter, true);
        this.sunset = this.obtainAccurateRiseSetTransit(this.sunset, 3, niter, true);
        this.sunTransit = this.obtainAccurateRiseSetTransit(this.sunTransit, 4, niter, true);
        if (this.sunTransit == -1.0) {
            this.sunTransitElev = 0.0;
        } else {
            this.setUTDate(this.sunTransit);
            out = this.doCalc(this.getSun());
            this.sunTransitElev = out[5];
        }
        this.setUTDate(jd);
        this.sanomaly = sa;
        this.slongitude = sl;
        out = this.doCalc(this.getMoon());
        this.moonAz = out[0];
        this.moonEl = out[1];
        this.moonRise = out[2];
        this.moonSet = out[3];
        this.moonTransit = out[4];
        this.moonTransitElev = out[5];
        this.moonDist = out[8];
        double ma = this.moonAge;
        niter = 5;
        this.moonRise = this.obtainAccurateRiseSetTransit(this.moonRise, 2, niter, false);
        this.moonSet = this.obtainAccurateRiseSetTransit(this.moonSet, 3, niter, false);
        this.moonTransit = this.obtainAccurateRiseSetTransit(this.moonTransit, 4, niter, false);
        if (this.moonTransit == -1.0) {
            this.moonTransitElev = 0.0;
        } else {
            this.setUTDate(this.moonTransit);
            this.getSun();
            out = this.doCalc(this.getMoon());
            this.moonTransitElev = out[5];
        }
        this.setUTDate(jd);
        this.sanomaly = sa;
        this.slongitude = sl;
        this.moonAge = ma;
    }

    private double[] getSun() {
        double lon = 280.46645 + 36000.76983 * this.t + 3.032E-4 * this.t * this.t;
        double anom = 357.5291 + 35999.0503 * this.t - 1.559E-4 * this.t * this.t - 4.8E-7 * this.t * this.t * this.t;
        this.sanomaly = anom * (Math.PI / 180);
        double c = (1.9146 - 0.004817 * this.t - 1.4E-5 * this.t * this.t) * Math.sin(this.sanomaly);
        c += (0.019993 - 1.01E-4 * this.t) * Math.sin(2.0 * this.sanomaly);
        double M1 = (124.9 - 1934.134 * this.t + 0.002063 * this.t * this.t) * (Math.PI / 180);
        double M2 = (201.11 + 72001.5377 * this.t + 5.7E-4 * this.t * this.t) * (Math.PI / 180);
        double d = -0.00569 - 0.0047785 * Math.sin(M1) - 3.667E-4 * Math.sin(M2);
        this.slongitude = lon + (c += 2.9E-4 * Math.sin(3.0 * this.sanomaly)) + d;
        double slatitude = 0.0;
        double ecc = 0.016708617 - 4.2037E-5 * this.t - 1.236E-7 * this.t * this.t;
        double v = this.sanomaly + c * (Math.PI / 180);
        double sdistance = 1.000001018 * (1.0 - ecc * ecc) / (1.0 + ecc * Math.cos(v));
        return new double[]{this.slongitude, slatitude, sdistance, Math.atan(696000.0 / (1.49597870691E8 * sdistance))};
    }

    private double[] getMoon() {
        double phase = SunMoonCalculator.normalizeRadians((297.8502042 + 445267.1115168 * this.t - 0.00163 * this.t * this.t + this.t * this.t * this.t / 538841.0 - this.t * this.t * this.t * this.t / 6.5194E7) * (Math.PI / 180));
        double anomaly = 134.9634114 + 477198.8676313 * this.t + 0.008997 * this.t * this.t + this.t * this.t * this.t / 69699.0 - this.t * this.t * this.t * this.t / 1.4712E7;
        double node = 93.2720993 + 483202.0175273 * this.t - 0.0034029 * this.t * this.t - this.t * this.t * this.t / 3526000.0 + this.t * this.t * this.t * this.t / 8.6331E8;
        double E = 1.0 - (0.002495 + 7.52E-6 * (this.t + 1.0)) * (this.t + 1.0);
        double l = 218.31664563 + 481267.8811958 * this.t - 0.00146639 * this.t * this.t + this.t * this.t * this.t / 540135.03 - this.t * this.t * this.t * this.t / 6.51937704E7;
        l += 6.28875 * Math.sin(anomaly *= Math.PI / 180) + 1.274018 * Math.sin(2.0 * phase - anomaly) + 0.658309 * Math.sin(2.0 * phase);
        l += 0.213616 * Math.sin(2.0 * anomaly) - E * 0.185596 * Math.sin(this.sanomaly) - 0.114336 * Math.sin(2.0 * (node *= Math.PI / 180));
        l += 0.058793 * Math.sin(2.0 * phase - 2.0 * anomaly) + 0.057212 * E * Math.sin(2.0 * phase - anomaly - this.sanomaly) + 0.05332 * Math.sin(2.0 * phase + anomaly);
        l += 0.045874 * E * Math.sin(2.0 * phase - this.sanomaly) + 0.041024 * E * Math.sin(anomaly - this.sanomaly) - 0.034718 * Math.sin(phase) - E * 0.030465 * Math.sin(this.sanomaly + anomaly);
        l += 0.015326 * Math.sin(2.0 * (phase - node)) - 0.012528 * Math.sin(2.0 * node + anomaly) - 0.01098 * Math.sin(2.0 * node - anomaly) + 0.010674 * Math.sin(4.0 * phase - anomaly);
        l += 0.010034 * Math.sin(3.0 * anomaly) + 0.008548 * Math.sin(4.0 * phase - 2.0 * anomaly);
        l += -E * 0.00791 * Math.sin(this.sanomaly - anomaly + 2.0 * phase) - E * 0.006783 * Math.sin(2.0 * phase + this.sanomaly) + 0.005162 * Math.sin(anomaly - phase) + E * 0.005 * Math.sin(this.sanomaly + phase);
        l += 0.003862 * Math.sin(4.0 * phase) + E * 0.004049 * Math.sin(anomaly - this.sanomaly + 2.0 * phase) + 0.003996 * Math.sin(2.0 * (anomaly + phase)) + 0.003665 * Math.sin(2.0 * phase - 3.0 * anomaly);
        l += E * 0.002695 * Math.sin(2.0 * anomaly - this.sanomaly) + 0.002602 * Math.sin(anomaly - 2.0 * (node + phase));
        l += E * 0.002396 * Math.sin(2.0 * (phase - anomaly) - this.sanomaly) - 0.002349 * Math.sin(anomaly + phase);
        l += E * E * 0.002249 * Math.sin(2.0 * (phase - this.sanomaly)) - E * 0.002125 * Math.sin(2.0 * anomaly + this.sanomaly);
        l += -E * E * 0.002079 * Math.sin(2.0 * this.sanomaly) + E * E * 0.002059 * Math.sin(2.0 * (phase - this.sanomaly) - anomaly);
        l += -0.001773 * Math.sin(anomaly + 2.0 * (phase - node)) - 0.001595 * Math.sin(2.0 * (node + phase));
        double longitude = l += E * 0.00122 * Math.sin(4.0 * phase - this.sanomaly - anomaly) - 0.00111 * Math.sin(2.0 * (anomaly + node));
        double M1 = (124.9 - 1934.134 * this.t + 0.002063 * this.t * this.t) * (Math.PI / 180);
        double M2 = (201.11 + 72001.5377 * this.t + 5.7E-4 * this.t * this.t) * (Math.PI / 180);
        double d = -0.0047785 * Math.sin(M1) - 3.667E-4 * Math.sin(M2);
        double Psin = 29.530588853;
        this.moonAge = SunMoonCalculator.normalizeRadians(((longitude += d) - this.slongitude) * (Math.PI / 180)) * Psin / (Math.PI * 2);
        double parallax = 0.950724 + 0.051818 * Math.cos(anomaly) + 0.009531 * Math.cos(2.0 * phase - anomaly);
        parallax += 0.007843 * Math.cos(2.0 * phase) + 0.002824 * Math.cos(2.0 * anomaly);
        parallax += 8.57E-4 * Math.cos(2.0 * phase + anomaly) + E * 5.33E-4 * Math.cos(2.0 * phase - this.sanomaly);
        parallax += E * 4.01E-4 * Math.cos(2.0 * phase - anomaly - this.sanomaly) + E * 3.2E-4 * Math.cos(anomaly - this.sanomaly) - 2.71E-4 * Math.cos(phase);
        parallax += -E * 2.64E-4 * Math.cos(this.sanomaly + anomaly) - 1.98E-4 * Math.cos(2.0 * node - anomaly);
        double distance = 1.0 / Math.sin((parallax += 1.73E-4 * Math.cos(3.0 * anomaly) + 1.67E-4 * Math.cos(4.0 * phase - anomaly)) * (Math.PI / 180));
        l = 5.128189 * Math.sin(node) + 0.280606 * Math.sin(node + anomaly) + 0.277693 * Math.sin(anomaly - node);
        l += 0.173238 * Math.sin(2.0 * phase - node) + 0.055413 * Math.sin(2.0 * phase + node - anomaly);
        l += 0.046272 * Math.sin(2.0 * phase - node - anomaly) + 0.032573 * Math.sin(2.0 * phase + node);
        l += 0.017198 * Math.sin(2.0 * anomaly + node) + 0.009267 * Math.sin(2.0 * phase + anomaly - node);
        l += 0.008823 * Math.sin(2.0 * anomaly - node) + E * 0.008247 * Math.sin(2.0 * phase - this.sanomaly - node) + 0.004323 * Math.sin(2.0 * (phase - anomaly) - node);
        l += 0.0042 * Math.sin(2.0 * phase + node + anomaly) + E * 0.003372 * Math.sin(node - this.sanomaly - 2.0 * phase);
        l += E * 0.002472 * Math.sin(2.0 * phase + node - this.sanomaly - anomaly);
        l += E * 0.002222 * Math.sin(2.0 * phase + node - this.sanomaly);
        double latitude = l += E * 0.002072 * Math.sin(2.0 * phase - node - this.sanomaly - anomaly);
        return new double[]{longitude, latitude, distance * 6378.1366 / 1.49597870691E8, Math.atan(1737.4 / (distance * 6378.1366))};
    }

    private double[] doCalc(double[] POS) {
        double transitToday2;
        double t2 = this.t / 100.0;
        double tmp = t2 * (27.87 + t2 * (5.79 + t2 * 2.45));
        tmp = t2 * (-249.67 + t2 * (-39.05 + t2 * (7.12 + tmp)));
        tmp = t2 * (-1.55 + t2 * (1999.25 + t2 * (-51.38 + tmp)));
        tmp = t2 * (-4680.93 + tmp) / 3600.0;
        double angle = (23.4392911111111 + tmp) * (Math.PI / 180);
        double M1 = (124.9 - 1934.134 * this.t + 0.002063 * this.t * this.t) * (Math.PI / 180);
        double M2 = (201.11 + 72001.5377 * this.t + 5.7E-4 * this.t * this.t) * (Math.PI / 180);
        double d = 0.002558 * Math.cos(M1) - 1.5339E-4 * Math.cos(M2);
        angle += d * (Math.PI / 180);
        POS[0] = POS[0] * (Math.PI / 180);
        POS[1] = POS[1] * (Math.PI / 180);
        double cl = Math.cos(POS[1]);
        double x = POS[2] * Math.cos(POS[0]) * cl;
        double y = POS[2] * Math.sin(POS[0]) * cl;
        double z = POS[2] * Math.sin(POS[1]);
        tmp = y * Math.cos(angle) - z * Math.sin(angle);
        z = y * Math.sin(angle) + z * Math.cos(angle);
        y = tmp;
        double jd0 = Math.floor(this.jd_UT - 0.5) + 0.5;
        double T0 = (jd0 - 2451545.0) / 36525.0;
        double secs = (this.jd_UT - jd0) * 86400.0;
        double gmst = ((-6.2E-6 * T0 + 0.093104) * T0 + 8640184.812866) * T0 + 24110.54841;
        double msday = 1.0 + ((-1.86E-5 * T0 + 0.186208) * T0 + 8640184.812866) / 3.15576E9;
        gmst = (gmst + msday * secs) * 0.004166666666666667 * (Math.PI / 180);
        double lst = gmst + this.latitude;
        double radiusAU = 4.263520978299403E-5;
        double[] correction = new double[]{radiusAU * Math.cos(this.longitude) * Math.cos(lst), radiusAU * Math.cos(this.longitude) * Math.sin(lst), radiusAU * Math.sin(this.longitude)};
        double xtopo = x - correction[0];
        double ytopo = y - correction[1];
        double ztopo = z - correction[2];
        double ra = 0.0;
        double dec = 1.5707963267948966;
        if (ztopo < 0.0) {
            dec = -dec;
        }
        if (ytopo != 0.0 || xtopo != 0.0) {
            ra = Math.atan2(ytopo, xtopo);
            dec = Math.atan2(ztopo / Math.sqrt(xtopo * xtopo + ytopo * ytopo), 1.0);
        }
        double dist = Math.sqrt(xtopo * xtopo + ytopo * ytopo + ztopo * ztopo);
        double angh = lst - ra;
        double sinlat = Math.sin(this.longitude);
        double coslat = Math.cos(this.longitude);
        double sindec = Math.sin(dec);
        double cosdec = Math.cos(dec);
        double h2 = sinlat * sindec + coslat * cosdec * Math.cos(angh);
        double alt = Math.asin(h2);
        double azy = Math.sin(angh);
        double azx = Math.cos(angh) * sinlat - sindec * coslat / cosdec;
        double azi = Math.PI + Math.atan2(azy, azx);
        if (alt > -0.05235987755982989) {
            double r = 2.9089402642989493E-4 * Math.abs(Math.tan(1.5707963267948966 - (alt * 57.29577951308232 + 7.31 / (alt * 57.29577951308232 + 4.4)) * (Math.PI / 180)));
            double refr = r * 0.9992932862190813;
            alt = Math.min(alt + refr, 1.5707963267948966);
        }
        switch (this.twilight) {
            case GOLDEN_HOUR: {
                tmp = 0.10471975511965978;
                break;
            }
            case HORIZON_34arcmin: {
                tmp = -0.009890199094634533 - POS[3];
                break;
            }
            case BLUE_HOUR: {
                tmp = -0.06981317007977318;
                break;
            }
            case TWILIGHT_CIVIL: {
                tmp = -0.10471975511965978;
                break;
            }
            case TWILIGHT_NAUTICAL: {
                tmp = -0.20943951023931956;
                break;
            }
            case TWILIGHT_ASTRONOMICAL: {
                tmp = -0.3141592653589793;
            }
        }
        tmp = (Math.sin(tmp) - Math.sin(this.longitude) * Math.sin(dec)) / (Math.cos(this.longitude) * Math.cos(dec));
        double celestialHoursToEarthTime = 0.1587203964997833;
        double transit_time1 = celestialHoursToEarthTime * SunMoonCalculator.normalizeRadians(ra - lst);
        double transit_time2 = celestialHoursToEarthTime * (SunMoonCalculator.normalizeRadians(ra - lst) - Math.PI * 2);
        double transit_alt = Math.asin(Math.sin(dec) * Math.sin(this.longitude) + Math.cos(dec) * Math.cos(this.longitude));
        if (transit_alt > -0.05235987755982989) {
            double r = 2.9089402642989493E-4 * Math.abs(Math.tan(1.5707963267948966 - (transit_alt * 57.29577951308232 + 7.31 / (transit_alt * 57.29577951308232 + 4.4)) * (Math.PI / 180)));
            double refr = r * 0.9992932862190813;
            transit_alt = Math.min(transit_alt + refr, 1.5707963267948966);
        }
        double transit_time = transit_time1;
        double jdToday = Math.floor(this.jd_UT - 0.5) + 0.5;
        if (jdToday == (transitToday2 = Math.floor(this.jd_UT + transit_time2 - 0.5) + 0.5) && Math.abs(transit_time2) < Math.abs(transit_time1)) {
            transit_time = transit_time2;
        }
        double transit = this.jd_UT + transit_time;
        double rise = -1.0;
        double set = -1.0;
        if (Math.abs(tmp) <= 1.0) {
            double ang_hor = Math.abs(Math.acos(tmp));
            double rise_time1 = celestialHoursToEarthTime * SunMoonCalculator.normalizeRadians(ra - ang_hor - lst);
            double set_time1 = celestialHoursToEarthTime * SunMoonCalculator.normalizeRadians(ra + ang_hor - lst);
            double rise_time2 = celestialHoursToEarthTime * (SunMoonCalculator.normalizeRadians(ra - ang_hor - lst) - Math.PI * 2);
            double set_time2 = celestialHoursToEarthTime * (SunMoonCalculator.normalizeRadians(ra + ang_hor - lst) - Math.PI * 2);
            double rise_time = rise_time1;
            double riseToday2 = Math.floor(this.jd_UT + rise_time2 - 0.5) + 0.5;
            if (jdToday == riseToday2 && Math.abs(rise_time2) < Math.abs(rise_time1)) {
                rise_time = rise_time2;
            }
            double set_time = set_time1;
            double setToday2 = Math.floor(this.jd_UT + set_time2 - 0.5) + 0.5;
            if (jdToday == setToday2 && Math.abs(set_time2) < Math.abs(set_time1)) {
                set_time = set_time2;
            }
            rise = this.jd_UT + rise_time;
            set = this.jd_UT + set_time;
        }
        return new double[]{azi, alt, rise, set, transit, transit_alt, ra, dec, dist};
    }

    private double obtainAccurateRiseSetTransit(double riseSetJD, int INDEX, int N_ITER, boolean IS_SUN) {
        double step = -1.0;
        for (int i = 0; i < N_ITER; ++i) {
            if (riseSetJD == -1.0) {
                return riseSetJD;
            }
            this.setUTDate(riseSetJD);
            double[] out = IS_SUN ? this.doCalc(this.getSun()) : this.doCalc(this.getMoon());
            step = Math.abs(riseSetJD - out[INDEX]);
            riseSetJD = out[INDEX];
        }
        if (step > 1.1574074074074073E-5) {
            return -1.0;
        }
        return riseSetJD;
    }

    public double[] getMoonDiskOrientationAngles() {
        double[] outS = this.doCalc(this.getSun());
        double[] moonPos = this.getMoon();
        double[] outM = this.doCalc(moonPos);
        double moonLon = moonPos[0];
        double moonLat = moonPos[1];
        double moonRA = outM[6];
        double moonDEC = outM[7];
        double sunRA = outS[6];
        double sunDEC = outS[7];
        double F = (93.2720993 + 483202.0175273 * this.t - 0.0034029 * this.t * this.t - this.t * this.t * this.t / 3526000.0 + this.t * this.t * this.t * this.t / 8.6331E8) * (Math.PI / 180);
        double I = 0.026920307448610938;
        double omega = (125.044555 - 1934.1361849 * this.t + 0.0020762 * this.t * this.t + this.t * this.t * this.t / 467410.0 - this.t * this.t * this.t * this.t / 1.8999E7) * (Math.PI / 180);
        double eps = 0.4090927848297817;
        double W = moonLon - omega;
        double sinA = Math.sin(W) * Math.cos(moonLat) * Math.cos(I) - Math.sin(moonLat) * Math.sin(I);
        double cosA = Math.cos(W) * Math.cos(moonLat);
        double A2 = Math.atan2(sinA, cosA);
        double lp = SunMoonCalculator.normalizeRadians(A2 - F);
        double sinbp = -Math.sin(W) * Math.cos(moonLat) * Math.sin(I) - Math.sin(moonLat) * Math.cos(I);
        double bp = Math.asin(sinbp);
        double x = Math.sin(I) * Math.sin(omega);
        double y = Math.sin(I) * Math.cos(omega) * Math.cos(eps) - Math.cos(I) * Math.sin(eps);
        double w = Math.atan2(x, y);
        double sinp = Math.sqrt(x * x + y * y) * Math.cos(moonRA - w) / Math.cos(bp);
        double p = Math.asin(sinp);
        double bl = Math.PI + Math.atan2(Math.cos(sunDEC) * Math.sin(moonRA - sunRA), Math.cos(sunDEC) * Math.sin(moonDEC) * Math.cos(moonRA - sunRA) - Math.sin(sunDEC) * Math.cos(moonDEC));
        double jd0 = Math.floor(this.jd_UT - 0.5) + 0.5;
        double T0 = (jd0 - 2451545.0) / 36525.0;
        double secs = (this.jd_UT - jd0) * 86400.0;
        double gmst = ((-6.2E-6 * T0 + 0.093104) * T0 + 8640184.812866) * T0 + 24110.54841;
        double msday = 1.0 + ((-1.86E-5 * T0 + 0.186208) * T0 + 8640184.812866) / 3.15576E9;
        gmst = (gmst + msday * secs) * 0.004166666666666667 * (Math.PI / 180);
        double lst = gmst + this.latitude;
        y = Math.sin(lst - moonRA);
        x = Math.tan(this.longitude) * Math.cos(moonDEC) - Math.sin(moonDEC) * Math.cos(lst - moonRA);
        double par = x != 0.0 ? Math.atan2(y, x) : y / Math.abs(y) * 1.5707963267948966;
        return new double[]{lp, bp, p, bl, par};
    }

    public void calcEphemeris(ZoneId ZONE_ID) {
        try {
            this.setTwilight(TWILIGHT.HORIZON_34arcmin);
            this.calcSunAndMoon();
            LocalDateTime now = LocalDateTime.now();
            ZonedDateTime zdt = now.atZone(ZONE_ID);
            ZoneOffset zoneOffset = zdt.getOffset();
            this.sunriseZDT = SunMoonCalculator.getZonedDateTime(this.sunrise, zoneOffset);
            this.sunsetZDT = SunMoonCalculator.getZonedDateTime(this.sunset, zoneOffset);
            this.setTwilight(TWILIGHT.GOLDEN_HOUR);
            this.calcSunAndMoon();
            this.sunriseGoldenHourZDT = SunMoonCalculator.getZonedDateTime(this.sunrise, zoneOffset);
            this.sunsetGoldenHourZDT = SunMoonCalculator.getZonedDateTime(this.sunset, zoneOffset);
            this.setTwilight(TWILIGHT.TWILIGHT_CIVIL);
            this.calcSunAndMoon();
            this.sunriseCivilZDT = SunMoonCalculator.getZonedDateTime(this.sunrise, zoneOffset);
            this.sunsetCivilZDT = SunMoonCalculator.getZonedDateTime(this.sunset, zoneOffset);
            this.setTwilight(TWILIGHT.BLUE_HOUR);
            this.calcSunAndMoon();
            this.sunriseBlueHourZDT = SunMoonCalculator.getZonedDateTime(this.sunrise, zoneOffset);
            this.sunsetBlueHourZDT = SunMoonCalculator.getZonedDateTime(this.sunset, zoneOffset);
        }
        catch (Exception e) {
            this.sunriseZDT = ZonedDateTime.now();
            this.sunsetZDT = ZonedDateTime.now();
            this.sunriseGoldenHourZDT = ZonedDateTime.now();
            this.sunsetGoldenHourZDT = ZonedDateTime.now();
            this.sunriseCivilZDT = ZonedDateTime.now();
            this.sunsetCivilZDT = ZonedDateTime.now();
            this.sunriseBlueHourZDT = ZonedDateTime.now();
            this.sunsetBlueHourZDT = ZonedDateTime.now();
        }
    }

    public ZonedDateTime getSunrise() {
        return this.sunriseZDT;
    }

    public ZonedDateTime getSunset() {
        return this.sunsetZDT;
    }

    public ZonedDateTime getSunriseGoldenHour() {
        return this.sunriseGoldenHourZDT;
    }

    public ZonedDateTime getSunsetGoldenHour() {
        return this.sunsetGoldenHourZDT;
    }

    public ZonedDateTime getSunriseCivil() {
        return this.sunriseCivilZDT;
    }

    public ZonedDateTime getSunsetCivil() {
        return this.sunsetCivilZDT;
    }

    public ZonedDateTime getSunriseBlueHour() {
        return this.sunriseBlueHourZDT;
    }

    public ZonedDateTime getSunsetBlueHour() {
        return this.sunsetBlueHourZDT;
    }

    public static enum TWILIGHT {
        TWILIGHT_ASTRONOMICAL,
        TWILIGHT_NAUTICAL,
        TWILIGHT_CIVIL,
        BLUE_HOUR,
        HORIZON_34arcmin,
        GOLDEN_HOUR;

    }
}

