/* elementary-calendar.h generated by valac 0.52.0, the Vala compiler, do not modify */

#ifndef __CORE_ELEMENTARY_CALENDAR_H__
#define __CORE_ELEMENTARY_CALENDAR_H__

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libecal/libecal.h>
#include <libical-glib/libical-glib.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define MAYA_TYPE_BACKEND (maya_backend_get_type ())
#define MAYA_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_BACKEND, MayaBackend))
#define MAYA_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_BACKEND))
#define MAYA_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MAYA_TYPE_BACKEND, MayaBackendIface))

typedef struct _MayaBackend MayaBackend;
typedef struct _MayaBackendIface MayaBackendIface;

#define MAYA_TYPE_PLACEMENT_WIDGET (maya_placement_widget_get_type ())
#define MAYA_PLACEMENT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_PLACEMENT_WIDGET, MayaPlacementWidget))
#define MAYA_PLACEMENT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_PLACEMENT_WIDGET, MayaPlacementWidgetClass))
#define MAYA_IS_PLACEMENT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_PLACEMENT_WIDGET))
#define MAYA_IS_PLACEMENT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_PLACEMENT_WIDGET))
#define MAYA_PLACEMENT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_PLACEMENT_WIDGET, MayaPlacementWidgetClass))

typedef struct _MayaPlacementWidget MayaPlacementWidget;
typedef struct _MayaPlacementWidgetClass MayaPlacementWidgetClass;

#define MAYA_TYPE_BACKENDS_MANAGER (maya_backends_manager_get_type ())
#define MAYA_BACKENDS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_BACKENDS_MANAGER, MayaBackendsManager))
#define MAYA_BACKENDS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_BACKENDS_MANAGER, MayaBackendsManagerClass))
#define MAYA_IS_BACKENDS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_BACKENDS_MANAGER))
#define MAYA_IS_BACKENDS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_BACKENDS_MANAGER))
#define MAYA_BACKENDS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_BACKENDS_MANAGER, MayaBackendsManagerClass))

typedef struct _MayaBackendsManager MayaBackendsManager;
typedef struct _MayaBackendsManagerClass MayaBackendsManagerClass;
typedef struct _MayaBackendsManagerPrivate MayaBackendsManagerPrivate;

#define MAYA_TYPE_LOCAL_BACKEND (maya_local_backend_get_type ())
#define MAYA_LOCAL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_LOCAL_BACKEND, MayaLocalBackend))
#define MAYA_LOCAL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_LOCAL_BACKEND, MayaLocalBackendClass))
#define MAYA_IS_LOCAL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_LOCAL_BACKEND))
#define MAYA_IS_LOCAL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_LOCAL_BACKEND))
#define MAYA_LOCAL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_LOCAL_BACKEND, MayaLocalBackendClass))

typedef struct _MayaLocalBackend MayaLocalBackend;
typedef struct _MayaLocalBackendClass MayaLocalBackendClass;
typedef struct _MayaLocalBackendPrivate MayaLocalBackendPrivate;
typedef struct _MayaPlacementWidgetPrivate MayaPlacementWidgetPrivate;

#define CALENDAR_TYPE_EVENT_STORE (calendar_event_store_get_type ())
#define CALENDAR_EVENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_EVENT_STORE, CalendarEventStore))
#define CALENDAR_EVENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_EVENT_STORE, CalendarEventStoreClass))
#define CALENDAR_IS_EVENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_EVENT_STORE))
#define CALENDAR_IS_EVENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_EVENT_STORE))
#define CALENDAR_EVENT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_EVENT_STORE, CalendarEventStoreClass))

typedef struct _CalendarEventStore CalendarEventStore;
typedef struct _CalendarEventStoreClass CalendarEventStoreClass;
typedef struct _CalendarEventStorePrivate CalendarEventStorePrivate;

#define CALENDAR_UTIL_TYPE_DATE_RANGE (calendar_util_date_range_get_type ())
#define CALENDAR_UTIL_DATE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_UTIL_TYPE_DATE_RANGE, CalendarUtilDateRange))
#define CALENDAR_UTIL_DATE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_UTIL_TYPE_DATE_RANGE, CalendarUtilDateRangeClass))
#define CALENDAR_UTIL_IS_DATE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_UTIL_TYPE_DATE_RANGE))
#define CALENDAR_UTIL_IS_DATE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_UTIL_TYPE_DATE_RANGE))
#define CALENDAR_UTIL_DATE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_UTIL_TYPE_DATE_RANGE, CalendarUtilDateRangeClass))

typedef struct _CalendarUtilDateRange CalendarUtilDateRange;
typedef struct _CalendarUtilDateRangeClass CalendarUtilDateRangeClass;

#define CALENDAR_UTIL_TYPE_DATE_ITERATOR (calendar_util_date_iterator_get_type ())
#define CALENDAR_UTIL_DATE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIterator))
#define CALENDAR_UTIL_DATE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIteratorClass))
#define CALENDAR_UTIL_IS_DATE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_UTIL_TYPE_DATE_ITERATOR))
#define CALENDAR_UTIL_IS_DATE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_UTIL_TYPE_DATE_ITERATOR))
#define CALENDAR_UTIL_DATE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_UTIL_TYPE_DATE_ITERATOR, CalendarUtilDateIteratorClass))

typedef struct _CalendarUtilDateIterator CalendarUtilDateIterator;
typedef struct _CalendarUtilDateIteratorClass CalendarUtilDateIteratorClass;
typedef struct _CalendarUtilDateIteratorPrivate CalendarUtilDateIteratorPrivate;
typedef struct _CalendarUtilDateRangePrivate CalendarUtilDateRangePrivate;

struct _MayaBackendIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (MayaBackend* self);
	gchar* (*get_uid) (MayaBackend* self);
	GeeCollection* (*get_new_calendar_widget) (MayaBackend* self, ESource* to_edit);
	void (*add_new_calendar) (MayaBackend* self, const gchar* name, const gchar* color, gboolean set_default, GeeCollection* widgets);
	void (*modify_calendar) (MayaBackend* self, const gchar* name, const gchar* color, gboolean set_default, GeeCollection* widgets, ESource* source);
};

struct _MayaBackendsManager {
	GObject parent_instance;
	MayaBackendsManagerPrivate * priv;
	GeeArrayList* backends;
};

struct _MayaBackendsManagerClass {
	GObjectClass parent_class;
};

struct _MayaLocalBackend {
	GObject parent_instance;
	MayaLocalBackendPrivate * priv;
};

struct _MayaLocalBackendClass {
	GObjectClass parent_class;
};

struct _MayaPlacementWidget {
	GObject parent_instance;
	MayaPlacementWidgetPrivate * priv;
	GtkWidget* widget;
	gint row;
	gint column;
	gchar* ref_name;
	gboolean needed;
};

struct _MayaPlacementWidgetClass {
	GObjectClass parent_class;
};

struct _CalendarEventStore {
	GObject parent_instance;
	CalendarEventStorePrivate * priv;
	GQueue* calendar_trash;
};

struct _CalendarEventStoreClass {
	GObjectClass parent_class;
};

struct _CalendarUtilDateIterator {
	GObject parent_instance;
	CalendarUtilDateIteratorPrivate * priv;
};

struct _CalendarUtilDateIteratorClass {
	GObjectClass parent_class;
};

struct _CalendarUtilDateRange {
	GObject parent_instance;
	CalendarUtilDateRangePrivate * priv;
};

struct _CalendarUtilDateRangeClass {
	GObjectClass parent_class;
};

GType maya_placement_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaPlacementWidget, g_object_unref)
GType maya_backend_get_type (void) G_GNUC_CONST ;
gchar* maya_backend_get_name (MayaBackend* self);
gchar* maya_backend_get_uid (MayaBackend* self);
GeeCollection* maya_backend_get_new_calendar_widget (MayaBackend* self,
                                                     ESource* to_edit);
void maya_backend_add_new_calendar (MayaBackend* self,
                                    const gchar* name,
                                    const gchar* color,
                                    gboolean set_default,
                                    GeeCollection* widgets);
void maya_backend_modify_calendar (MayaBackend* self,
                                   const gchar* name,
                                   const gchar* color,
                                   gboolean set_default,
                                   GeeCollection* widgets,
                                   ESource* source);
GType maya_backends_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaBackendsManager, g_object_unref)
MayaBackendsManager* maya_backends_manager_get_default (void);
void maya_backends_manager_add_backend (MayaBackendsManager* self,
                                        MayaBackend* b);
void maya_backends_manager_remove_backend (MayaBackendsManager* self,
                                           MayaBackend* b);
GType maya_local_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaLocalBackend, g_object_unref)
void maya_local_backend_add_source (MayaLocalBackend* self,
                                    ESource* new_source,
                                    gboolean set_default,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
void maya_local_backend_add_source_finish (MayaLocalBackend* self,
                                           GAsyncResult* _res_);
void maya_local_backend_set_source_default (MayaLocalBackend* self,
                                            ESource* source,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
void maya_local_backend_set_source_default_finish (MayaLocalBackend* self,
                                                   GAsyncResult* _res_);
MayaLocalBackend* maya_local_backend_new (void);
MayaLocalBackend* maya_local_backend_construct (GType object_type);
MayaPlacementWidget* maya_placement_widget_new (void);
MayaPlacementWidget* maya_placement_widget_construct (GType object_type);
GeeLinkedList* maya_default_placement_widgets_get_user (gint row,
                                                        gboolean needed,
                                                        const gchar* entry_text,
                                                        const gchar* ph_text);
GeeLinkedList* maya_default_placement_widgets_get_email (gint row,
                                                         gboolean needed,
                                                         const gchar* entry_text,
                                                         const gchar* ph_text);
MayaPlacementWidget* maya_default_placement_widgets_get_keep_copy (gint row,
                                                                   gboolean default_value);
GType calendar_event_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarEventStore, g_object_unref)
CalendarEventStore* calendar_event_store_get_default (void);
CalendarEventStore* calendar_event_store_new (void);
CalendarEventStore* calendar_event_store_construct (GType object_type);
void calendar_event_store_open (CalendarEventStore* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
void calendar_event_store_open_finish (CalendarEventStore* self,
                                       GAsyncResult* _res_);
void calendar_event_store_add_event (CalendarEventStore* self,
                                     ESource* source,
                                     ECalComponent* event);
gboolean calendar_event_store_calclient_is_readonly (CalendarEventStore* self,
                                                     ESource* source);
void calendar_event_store_update_event (CalendarEventStore* self,
                                        ESource* source,
                                        ECalComponent* event,
                                        ECalObjModType mod_type);
void calendar_event_store_remove_event (CalendarEventStore* self,
                                        ESource* source,
                                        ECalComponent* event,
                                        ECalObjModType mod_type);
void calendar_event_store_trash_calendar (CalendarEventStore* self,
                                          ESource* source);
void calendar_event_store_restore_calendar (CalendarEventStore* self);
void calendar_event_store_delete_trashed_calendars (CalendarEventStore* self);
void calendar_event_store_change_month (CalendarEventStore* self,
                                        gint relative);
void calendar_event_store_change_year (CalendarEventStore* self,
                                       gint relative);
void calendar_event_store_load_all_sources (CalendarEventStore* self);
void calendar_event_store_add_source (CalendarEventStore* self,
                                      ESource* source);
void calendar_event_store_remove_source (CalendarEventStore* self,
                                         ESource* source);
GeeCollection* calendar_event_store_get_events (CalendarEventStore* self);
GType calendar_util_date_range_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarUtilDateRange, g_object_unref)
CalendarUtilDateRange* calendar_event_store_get_data_range (CalendarEventStore* self);
CalendarUtilDateRange* calendar_event_store_get_month_range (CalendarEventStore* self);
ESourceRegistry* calendar_event_store_get_registry (CalendarEventStore* self);
GDateTime* calendar_event_store_get_month_start (CalendarEventStore* self);
void calendar_event_store_set_month_start (CalendarEventStore* self,
                                           GDateTime* value);
gint calendar_event_store_get_num_weeks (CalendarEventStore* self);
GDateWeekday calendar_event_store_get_week_starts_on (CalendarEventStore* self);
void calendar_event_store_set_week_starts_on (CalendarEventStore* self,
                                              GDateWeekday value);
ECalComponent* calendar_event_store_get_drag_component (CalendarEventStore* self);
void calendar_event_store_set_drag_component (CalendarEventStore* self,
                                              ECalComponent* value);
GType calendar_util_date_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarUtilDateIterator, g_object_unref)
CalendarUtilDateIterator* calendar_util_date_iterator_new (CalendarUtilDateRange* range);
CalendarUtilDateIterator* calendar_util_date_iterator_construct (GType object_type,
                                                                 CalendarUtilDateRange* range);
GDateTime* calendar_util_date_iterator_get_current (CalendarUtilDateIterator* self);
void calendar_util_date_iterator_set_current (CalendarUtilDateIterator* self,
                                              GDateTime* value);
CalendarUtilDateRange* calendar_util_date_iterator_get_range (CalendarUtilDateIterator* self);
CalendarUtilDateRange* calendar_util_date_range_new (GDateTime* first,
                                                     GDateTime* last);
CalendarUtilDateRange* calendar_util_date_range_construct (GType object_type,
                                                           GDateTime* first,
                                                           GDateTime* last);
gboolean calendar_util_date_range_equals (CalendarUtilDateRange* self,
                                          CalendarUtilDateRange* other);
GeeList* calendar_util_date_range_to_list (CalendarUtilDateRange* self);
GDateTime* calendar_util_date_range_get_first_dt (CalendarUtilDateRange* self);
GDateTime* calendar_util_date_range_get_last_dt (CalendarUtilDateRange* self);
gboolean calendar_util_datetime_equal_func (GDateTime* a,
                                            GDateTime* b);
gboolean calendar_util_datetime_is_all_day (GDateTime* dtstart,
                                            GDateTime* dtend);
ICalTime* calendar_util_datetimes_to_icaltime (GDateTime* date,
                                               GDateTime* time_local,
                                               const gchar* timezone);
GDateTime* calendar_util_datetime_get_start_of_month (GDateTime* date);
GDateTime* calendar_util_datetime_strip_time (GDateTime* datetime);
gboolean calendar_util_ecalcomponent_equal_func (ECalComponent* a,
                                                 ECalComponent* b);
gint calendar_util_ecalcomponent_compare_func (ECalComponent* a,
                                               ECalComponent* b);
gboolean calendar_util_ecalcomponent_is_on_day (ECalComponent* component,
                                                GDateTime* day);
gboolean calendar_util_esource_equal_func (ESource* a,
                                           ESource* b);
void calendar_util_icalcomponent_get_local_datetimes (ICalComponent* component,
                                                      GDateTime* * start_date,
                                                      GDateTime* * end_date);
gboolean calendar_util_icalcomponent_is_in_range (ICalComponent* component,
                                                  CalendarUtilDateRange* range);
gboolean calendar_util_icalcomponent_is_multiday (ICalComponent* component);
GTimeZone* calendar_util_icaltime_get_timezone (ICalTime* date);
GDateTime* calendar_util_icaltime_to_datetime (ICalTime* date);
gint maya_util_compare_events (ECalComponent* comp1,
                               ECalComponent* comp2);
gchar* maya_util_get_source_location (ESource* source);
void maya_util_save_temp_selected_calendars (void);
ECalComponent* maya_util_copy_ecal_component (ECalComponent* original);
gboolean maya_gestures_utils_on_scroll_event (GdkEventScroll* event);
void maya_gestures_utils_reset_timer (GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void maya_gestures_utils_reset_timer_finish (GAsyncResult* _res_);
#define BUILD_APP_NAME "Calendar"
#define BUILD_EXEC_NAME "io.elementary.calendar"
#define BUILD_PLUGIN_DIR "/usr/lib/io.elementary.calendar/plugins"

G_END_DECLS

#endif
