/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class AbstractTaskDraw
implements TaskDraw {
    protected CenterBorderColor colors;
    protected int completion = 100;
    protected Url url;
    protected Display note;
    protected final TimeScale timeScale;
    private double y;
    protected final String prettyDisplay;
    protected final Day start;
    protected final ISkinParam skinParam;
    private final Task task;
    private final ToTaskDraw toTaskDraw;
    protected final double margin = 2.0;

    public final String toString() {
        return super.toString() + " " + this.task;
    }

    @Override
    public final void setColorsAndCompletion(CenterBorderColor colors, int completion, Url url, Display note) {
        this.colors = colors;
        this.completion = completion;
        this.url = url;
        this.note = note;
    }

    public AbstractTaskDraw(TimeScale timeScale, double y, String prettyDisplay, Day start, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw) {
        this.y = y;
        this.toTaskDraw = toTaskDraw;
        this.start = start;
        this.prettyDisplay = prettyDisplay;
        this.timeScale = timeScale;
        this.skinParam = skinParam;
        this.task = task;
    }

    protected final HColor getLineColor() {
        return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    protected final HColor getBackgroundColor() {
        return this.getStyle().value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    protected final FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet());
    }

    protected abstract Style getStyle();

    protected final double getShapeHeight() {
        return this.getHeightTask() - 4.0;
    }

    @Override
    public final double getHeightTask() {
        return this.getFontConfiguration().getFont().getSize2D() + 5.0;
    }

    @Override
    public TaskDraw getTrueRow() {
        return this.toTaskDraw.getTaskDraw(this.task.getRow());
    }

    @Override
    public final double getY() {
        if (this.task.getRow() == null) {
            return this.y;
        }
        return this.getTrueRow().getY();
    }

    @Override
    public void pushMe(double deltaY) {
        if (this.task.getRow() == null) {
            this.y += deltaY;
        }
    }

    @Override
    public final Task getTask() {
        return this.task;
    }

    @Override
    public final double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.getY();
        }
        if (direction == Direction.DOWN) {
            return this.getY() + this.getHeightTask();
        }
        return this.getY() + this.getHeightTask() / 2.0;
    }
}

