#ifndef RZ_CONFIGURE_H
#define RZ_CONFIGURE_H

#include "rz_version.h"

#define RZ_CHECKS_LEVEL 2
#define DEBUGGER 1
#define HAVE_DECL_ADDR_NO_RANDOMIZE 1
#define HAVE_ARC4RANDOM_UNIFORM 0
#define HAVE_EXPLICIT_BZERO 1
#define HAVE_EXPLICIT_MEMSET 0
#define HAVE_CLOCK_NANOSLEEP 1
#define HAVE_SIGACTION 1
#define HAVE_PIPE 1
#define HAVE_EXECV 1
#define HAVE_EXECVE 1
#define HAVE_EXECVP 1
#define HAVE_EXECL 1
#define HAVE_SYSTEM 1
#define HAVE_PIPE2 1

#ifdef RZ_MESON_VERSION
#define RZ_PREFIX "/usr"
#define RZ_LIBDIR "/usr/lib"
#define RZ_INCDIR "/usr/include/librz"
#define RZ_DATDIR "/usr/share"
#define RZ_WWWROOT "/usr/share/rizin/0.1.2/www"
#define RZ_PLUGINS "lib/rizin/0.1.2"
#define RZ_EXTRAS "lib/rizin-extras/0.1.2"
#define RZ_BINDINGS "lib/rizin-bindings/0.1.2"
#define RZ_DATDIR_RZ "share/rizin"
#define RZ_SDB "share/rizin/0.1.2"
#define RZ_ZIGNS "share/rizin/0.1.2/zigns"
#define RZ_THEMES "share/rizin/0.1.2/cons"
#define RZ_FORTUNES "share/rizin/0.1.2/fortunes"
#define RZ_FLAGS "share/rizin/0.1.2/flag"
#define RZ_HUD "share/rizin/0.1.2/hud"
#else
#if __WINDOWS__ || _MSC_VER
#define RZ_PREFIX "."
#define RZ_LIBDIR "lib"
#define RZ_INCDIR "include\\librz"
#define RZ_DATDIR "share"
#define RZ_WWWROOT "www"
#define RZ_PLUGINS "lib\\plugins"
#define RZ_EXTRAS "lib\\extras"
#define RZ_BINDINGS "lib\\bindings"
#else
#define RZ_PREFIX "/usr"
#define RZ_LIBDIR "/usr/lib"
#define RZ_INCDIR "/usr/include/librz/librz"
#define RZ_DATDIR "/usr/share"
#define RZ_WWWROOT RZ_DATDIR "/rizin/" RZ_VERSION "/www"
#define RZ_PLUGINS "lib/rizin/" RZ_VERSION
#define RZ_EXTRAS "lib/rizin-extras/" RZ_VERSION
#define RZ_BINDINGS "lib/rizin-bindings/" RZ_VERSION
#endif
#define RZ_DATDIR_RZ        RZ_JOIN_2_PATHS ("share", "rizin")
#define RZ_SDB              RZ_JOIN_3_PATHS ("share", "rizin", RZ_VERSION)
#define RZ_ZIGNS            RZ_JOIN_4_PATHS ("share", "rizin", RZ_VERSION, "zigns")
#define RZ_THEMES           RZ_JOIN_4_PATHS ("share", "rizin", RZ_VERSION, "cons")
#define RZ_FLAGS            RZ_JOIN_4_PATHS ("share", "rizin", RZ_VERSION, "flag")
#define RZ_FORTUNES         RZ_JOIN_3_PATHS ("share", "doc", "rizin")
#define RZ_HUD              RZ_JOIN_4_PATHS ("share", "rizin", RZ_VERSION, "hud")
#endif

#define RZ_SDB_FCNSIGN      RZ_JOIN_2_PATHS (RZ_SDB, "fcnsign")
#define RZ_SDB_OPCODES      RZ_JOIN_2_PATHS (RZ_SDB, "opcodes")
#define RZ_SDB_MAGIC        RZ_JOIN_2_PATHS (RZ_SDB, "magic")
#define RZ_SDB_FORMAT       RZ_JOIN_2_PATHS (RZ_SDB, "format")

#define RZ_HOME_CONFIGDIR   RZ_JOIN_2_PATHS (".config", "rizin")
#define RZ_HOME_DATADIR     RZ_JOIN_3_PATHS (".local", "share", "rizin")
#define RZ_HOME_CACHEDIR    RZ_JOIN_2_PATHS (".cache", "rizin")

#define RZ_HOME_THEMES      RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "cons")
#define RZ_HOME_PLUGINS     RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "plugins")
#define RZ_HOME_ZIGNS       RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "zigns")
#define RZ_HOME_PDB         RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "pdb")
#define RZ_HOME_PROJECTS    RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "projects")
#define RZ_HOME_WWWROOT     RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "www")
#define RZ_HOME_SDB_FCNSIGN RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "fcnsign")
#define RZ_HOME_SDB_FORMAT  RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "format")
#define RZ_HOME_HUD         RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "hud")
#define RZ_HOME_BINRC       RZ_JOIN_2_PATHS (RZ_HOME_DATADIR, "rc.d")
#define RZ_HOME_BIN         RZ_JOIN_3_PATHS (RZ_HOME_DATADIR, "prefix", "bin")

#define RZ_HOME_HISTORY     RZ_JOIN_2_PATHS (RZ_HOME_CACHEDIR, "history")

#define RZ_HOME_RC          RZ_JOIN_2_PATHS (RZ_HOME_CONFIGDIR, "rizinrc")
#define RZ_HOME_RC_DIR      RZ_JOIN_2_PATHS (RZ_HOME_CONFIGDIR, "rizinrc.d")
#define RZ_GLOBAL_RC        RZ_JOIN_2_PATHS (RZ_DATDIR_RZ, "rizinrc")

#define HAVE_LIB_MAGIC 1
#define USE_LIB_MAGIC 1
#define HAVE_LIB_XXHASH 1
#define USE_LIB_XXHASH 1

#ifndef HAVE_LIB_SSL
#define HAVE_LIB_SSL 1
#endif

#define HAVE_LIBUV 1

#define HAVE_PTRACE 1
#define USE_PTRACE_WRAP 1
#define HAVE_FORK 1
#define WANT_DYLINK 1
#define WITH_GPL 1

#if __APPLE__ && __POWERPC__
#define HAVE_JEMALLOC 0
#else
#define HAVE_JEMALLOC 1
#endif

#endif
