/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.javasound.JSAuralParameters;
import com.sun.j3d.audioengines.javasound.JSClip;
import com.sun.j3d.audioengines.javasound.JSDirectionalSample;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import com.sun.j3d.audioengines.javasound.JSSample;
import com.sun.j3d.audioengines.javasound.JSStream;
import com.sun.j3d.audioengines.javasound.JSThread;
import java.util.ArrayList;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class JavaSoundMixer
extends AudioEngine3DL2 {
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    JSAuralParameters auralParams = null;
    JSThread thread = new JSThread(Thread.currentThread().getThreadGroup(), this);
    protected float deviceGain = 1.0f;
    protected static final int NOT_PAUSED = 0;
    protected static final int PAUSE_PENDING = 1;
    protected static final int PAUSED = 2;
    protected static final int RESUME_PENDING = 3;
    protected int pause = 0;

    void debugPrint(String string) {
    }

    void debugPrintln(String string) {
    }

    public JavaSoundMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    @Override
    public int getTotalChannels() {
        if (this.thread != null) {
            return this.thread.getTotalChannels();
        }
        return 32;
    }

    @Override
    public boolean initialize() {
        if (this.thread == null) {
            return false;
        }
        this.thread.initialize();
        this.auralParams = new JSAuralParameters();
        return true;
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareSound(int n, MediaContainer mediaContainer) {
        int n2 = -1;
        int n3 = 1;
        if (mediaContainer == null) {
            return -1;
        }
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            int n4;
            n2 = n4 = this.samples.size();
            this.samples.ensureCapacity(n2 + 1);
            boolean bl = false;
            if (n == 3) {
                JSDirectionalSample jSDirectionalSample = new JSDirectionalSample();
                bl = jSDirectionalSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n3 == 2) {
                    this.samples.set(n2, jSDirectionalSample);
                } else {
                    this.samples.add(n2, jSDirectionalSample);
                }
                jSDirectionalSample.setDirtyFlags(65535);
                jSDirectionalSample.setSoundType(n);
                jSDirectionalSample.setSoundData(mediaContainer);
            } else if (n == 2) {
                JSPositionalSample jSPositionalSample = new JSPositionalSample();
                bl = jSPositionalSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n3 == 2) {
                    this.samples.set(n2, jSPositionalSample);
                } else {
                    this.samples.add(n2, jSPositionalSample);
                }
                jSPositionalSample.setDirtyFlags(65535);
                jSPositionalSample.setSoundType(n);
                jSPositionalSample.setSoundData(mediaContainer);
            } else {
                JSSample jSSample = null;
                jSSample = new JSSample();
                bl = jSSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n3 == 2) {
                    this.samples.set(n2, jSSample);
                } else {
                    this.samples.add(n2, jSSample);
                }
                jSSample.setDirtyFlags(65535);
                jSSample.setSoundType(n);
                jSSample.setSoundData(mediaContainer);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSound(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        jSSample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(n, null);
        }
    }

    @Override
    public void setVworldXfrm(int n, Transform3D transform3D) {
        super.setVworldXfrm(n, transform3D);
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        int n2 = jSSample.getSoundType();
        if (n2 == 3) {
            JSDirectionalSample jSDirectionalSample = null;
            jSDirectionalSample = (JSDirectionalSample)this.getSample(n);
            if (jSDirectionalSample == null) {
                return;
            }
            jSDirectionalSample.setXformedDirection();
            jSDirectionalSample.setXformedPosition();
            jSDirectionalSample.setVWrldXfrmFlag(true);
        } else if (n2 == 2) {
            JSPositionalSample jSPositionalSample = null;
            jSPositionalSample = (JSPositionalSample)this.getSample(n);
            if (jSPositionalSample == null) {
                return;
            }
            jSPositionalSample.setXformedPosition();
            jSPositionalSample.setVWrldXfrmFlag(true);
        }
    }

    @Override
    public void setPosition(int n, Point3d point3d) {
        super.setPosition(n, point3d);
        JSPositionalSample jSPositionalSample = null;
        jSPositionalSample = (JSPositionalSample)this.getSample(n);
        if (jSPositionalSample == null) {
            return;
        }
        int n2 = jSPositionalSample.getSoundType();
        if (n2 == 2 || n2 == 3) {
            jSPositionalSample.setXformedPosition();
        }
    }

    @Override
    public void setDirection(int n, Vector3d vector3d) {
        super.setDirection(n, vector3d);
        JSDirectionalSample jSDirectionalSample = null;
        jSDirectionalSample = (JSDirectionalSample)this.getSample(n);
        if (jSDirectionalSample == null) {
            return;
        }
        int n2 = jSDirectionalSample.getSoundType();
        if (n2 == 3) {
            jSDirectionalSample.setXformedDirection();
        }
    }

    @Override
    public void setReflectionCoefficient(float f) {
        super.setReflectionCoefficient(f);
        this.auralParams.reverbDirty |= JSAuralParameters.REFLECTION_COEFF_CHANGED;
    }

    @Override
    public void setReverbDelay(float f) {
        super.setReverbDelay(f);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_DELAY_CHANGED;
    }

    @Override
    public void setReverbOrder(int n) {
        super.setReverbOrder(n);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_ORDER_CHANGED;
    }

    @Override
    public int startSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null || this.thread == null) {
            return -1;
        }
        int n2 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            this.thread.muteSample(jSSample);
            if (n2 != 1) {
                this.setFilter(n, false, -1.0f);
            }
        } else {
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), this.auralParams);
            this.scaleSampleRate(n, jSSample.rateRatio);
            if (n2 != 1) {
                this.setFilter(n, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
        }
        boolean bl2 = this.thread.startSample(jSSample);
        jSSample.channel.startSample(jSSample.getLoopCount(), jSSample.getGain(), 0);
        if (!bl2) {
            return -1;
        }
        if (!bl) {
            if (this.auralParams.reverbDirty > 0) {
                float f = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(jSSample);
            }
            this.setReverb(jSSample);
        }
        return n;
    }

    @Override
    public int stopSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return -1;
        }
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        boolean bl = true;
        bl = this.thread.stopSample(jSSample);
        jSSample.channel.stopSample();
        if (!bl) {
            return -1;
        }
        jSSample.reset();
        return 0;
    }

    @Override
    public void pauseSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        this.thread.pauseSample(jSSample);
    }

    @Override
    public void unpauseSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        this.thread.unpauseSample(jSSample);
    }

    @Override
    public void updateSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null || this.thread == null) {
            return;
        }
        int n2 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            if (n2 != 1) {
                this.setFilter(n, false, -1.0f);
            }
            this.thread.muteSample(jSSample);
        } else {
            float f;
            if (this.auralParams.reverbDirty > 0) {
                f = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(jSSample);
            }
            this.setReverb(jSSample);
            f = 0.0f;
            if (!bl && this.auralParams.reverbFlag) {
                f = jSSample.getGain() * this.auralParams.reflectionCoefficient;
            }
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), this.auralParams);
            if (n2 != 1) {
                this.setFilter(n, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
            this.thread.setSampleGain(jSSample, this.auralParams);
            this.thread.setSampleRate(jSSample, this.auralParams);
            this.thread.setSampleDelay(jSSample, this.auralParams);
        }
    }

    @Override
    public void muteSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        jSSample.setMuteFlag(true);
        this.thread.muteSample(jSSample);
    }

    @Override
    public void unmuteSample(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        jSSample.setMuteFlag(false);
        this.auralParams.reverbDirty = 65535;
        jSSample.setDirtyFlags(65535);
        this.thread.unmuteSample(jSSample);
    }

    @Override
    public long getSampleDuration(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return -1L;
        }
        long l = jSSample != null ? jSSample.getDuration() : -1L;
        return l;
    }

    @Override
    public int getNumberOfChannelsUsed(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return 0;
        }
        return this.getNumberOfChannelsUsed(n, jSSample.getMuteFlag());
    }

    @Override
    public int getNumberOfChannelsUsed(int n, boolean bl) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return 0;
        }
        int n2 = jSSample.getSoundType();
        int n3 = jSSample.getDataType();
        if (n3 == 3 || n3 == 3) {
            return 1;
        }
        if (n2 == 1) {
            return 1;
        }
        return 3;
    }

    @Override
    public long getStartTime(int n) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return 0L;
        }
        if (jSSample.channel == null) {
            return 0L;
        }
        return jSSample.channel.startTime;
    }

    void scaleSampleRate(int n, float f) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null || this.thread == null) {
            return;
        }
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        if (n2 == 1 || n2 == 2) {
            this.thread.setSampleRate(jSSample, f);
        } else if (n2 == 3 || n2 == 3) {
            this.thread.setSampleRate(jSSample, f);
        }
    }

    void calcReverb(JSSample jSSample) {
        int n = jSSample.getDataType();
        int n2 = jSSample.getSoundType();
        float f = this.auralParams.decayTime;
        float f2 = this.auralParams.reverbDelay * this.auralParams.rolloff;
        float f3 = this.auralParams.reflectionCoefficient;
        int n3 = this.auralParams.reverbOrder;
        if (this.auralParams.reflectionCoefficient == 0.0f || this.auralParams.reverbCoefficient == 0.0f) {
            this.auralParams.reverbFlag = false;
        } else {
            float f4;
            this.auralParams.reverbFlag = true;
            if (n3 > 0 && (f4 = (float)n3 * f2) < f) {
                f = f4;
            }
            this.auralParams.reverbType = f2 < 100.0f ? (f <= 1500.0f ? 2 : 4) : (f2 < 500.0f ? (f <= 1500.0f ? 3 : 6) : (f <= 1500.0f ? 6 : 5));
        }
        this.auralParams.reverbDirty = 0;
    }

    void setReverb(JSSample jSSample) {
        int n = jSSample.getSoundType();
        int n2 = jSSample.getDataType();
        if (n == 3 || n == 2) {
            if (jSSample == null) {
                return;
            }
            JSPositionalSample jSPositionalSample = (JSPositionalSample)jSSample;
            if (jSPositionalSample.channel == null) {
                return;
            }
            if (n2 == 1) {
                JSStream jSStream = (JSStream)jSPositionalSample.channel;
                jSStream.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            } else if (n2 == 2) {
                JSClip jSClip = (JSClip)jSPositionalSample.channel;
                jSClip.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            }
        }
    }

    @Override
    public void setLoop(int n, int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        int n3 = jSSample.getDataType();
        if ((n3 == 1 || n3 == 2) && n2 == -1) {
            n2 = 0x7FFFFFF;
        }
        super.setLoop(n, n2);
    }

    void setFilter(int n, boolean bl, float f) {
        JSPositionalSample jSPositionalSample = null;
        jSPositionalSample = (JSPositionalSample)this.getSample(n);
        if (jSPositionalSample == null) {
            return;
        }
        if (jSPositionalSample.channel == null) {
            return;
        }
        int n2 = jSPositionalSample.getDataType();
        if (n2 == 3 || n2 == 3) {
            return;
        }
        if (n2 == 2) {
            JSClip jSClip = (JSClip)jSPositionalSample.channel;
            jSClip.setSampleFiltering(bl, f);
        } else {
            JSStream jSStream = (JSStream)jSPositionalSample.channel;
            jSStream.setSampleFiltering(bl, f);
        }
    }

    @Override
    public void setGain(float f) {
        float f2 = this.deviceGain;
        float f3 = f / f2;
        this.deviceGain = f;
    }

    @Override
    public void setRateScaleFactor(int n, float f) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n);
        if (jSSample == null) {
            return;
        }
        jSSample.setRateScaleFactor(f);
        this.scaleSampleRate(n, f);
    }

    @Override
    public void pause() {
        this.pause = 1;
    }

    @Override
    public void resume() {
        this.pause = 3;
    }
}

