#!/bin/bash

check() {
    if [ -n "$hostonly" ]; then
        if tpm2-totp calculate >/dev/null 2>&1; then
            return 0
        else
            dinfo "dracut module 'tpm2-totp' will not be installed because no TOTP is configured; run 'tpm2-totp generate'!"
        fi
    fi
    return 255
}

install() {
    inst_libdir_file 'libtss2-tcti-device.so*'
    if dracut_module_included "plymouth" && \
       find_binary /usr/lib/tpm2-totp/plymouth-tpm2-totp; then
        inst /usr/lib/tpm2-totp/plymouth-tpm2-totp /bin/show-tpm2-totp
        inst_library /label.so
        inst_simple "$(fc-match --format '%{file}')"
    else
        inst /usr/lib/tpm2-totp/show-tpm2-totp /bin/show-tpm2-totp
        inst tpm2-totp
        inst date
        inst_hook cleanup 70 "$moddir/cleanup-tpm2-totp.sh"
    fi
    inst_hook pre-udev 70 "$moddir/show-tpm2-totp.sh"
    dracut_need_initqueue
}

installkernel() {
    instmods =drivers/char/tpm
}
