/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableTag;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableTag
extends SqlAbstractTable
implements TableTag {
    private static final String TABLE_NAME = DbSQL.getSQL("tag.table_name");
    private static final String TAGID = DbSQL.getSQL("tag.field.tagid");
    private static final String HISTORYID = DbSQL.getSQL("tag.field.historyid");
    private static final String TAG = DbSQL.getSQL("tag.field.tag");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("tag.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordTag read(long tagId) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordTag insert(long historyId, String tag) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void delete(long historyId, String tag) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteTag = null;
        try {
            psDeleteTag = DbSQL.getSingleton().getPreparedStatement("tag.ps.delete");
            psDeleteTag.getPs().setLong(1, historyId);
            psDeleteTag.getPs().setString(2, tag);
            psDeleteTag.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteTag);
        }
    }

    @Override
    public List<RecordTag> getTagsForHistoryID(long historyId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetTagsForHistoryId = null;
        try {
            psGetTagsForHistoryId = DbSQL.getSingleton().getPreparedStatement("tag.ps.gettagsforhid");
            ArrayList<RecordTag> result = new ArrayList<RecordTag>();
            psGetTagsForHistoryId.getPs().setLong(1, historyId);
            try (ResultSet rs = psGetTagsForHistoryId.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordTag(rs.getLong(TAGID), rs.getLong(TAGID), rs.getString(TAG)));
                }
            }
            ArrayList<RecordTag> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetTagsForHistoryId);
        }
    }

    @Override
    public List<String> getAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllTags = null;
        try {
            psGetAllTags = DbSQL.getSingleton().getPreparedStatement("tag.ps.getalltags");
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet rs = psGetAllTags.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(TAG));
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllTags);
        }
    }

    @Override
    public void deleteTagsForHistoryID(long historyId) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteTagsForHistoryId = null;
        try {
            psDeleteTagsForHistoryId = DbSQL.getSingleton().getPreparedStatement("tag.ps.deletetagsforhid");
            psDeleteTagsForHistoryId.getPs().setLong(1, historyId);
            psDeleteTagsForHistoryId.getPs().execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteTagsForHistoryId);
        }
    }

    private RecordTag build(ResultSet rs) throws SQLException {
        RecordTag rt = null;
        if (rs.next()) {
            rt = new RecordTag(rs.getLong(TAGID), rs.getLong(HISTORYID), rs.getString(TAG));
        }
        return rt;
    }
}

