/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfAPI;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfDetectScanner;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.HttpMessageSender;
import org.zaproxy.zap.extension.anticsrf.OptionsAntiCsrfPanel;
import org.zaproxy.zap.extension.anticsrf.PopupMenuGenerateForm;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;

public class ExtensionAntiCSRF
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionAntiCSRF";
    public static final String TAG = "AntiCSRF";
    private Map<String, AntiCsrfToken> valueToToken = new HashMap<String, AntiCsrfToken>();
    private OptionsAntiCsrfPanel optionsAntiCsrfPanel = null;
    private PopupMenuGenerateForm popupMenuGenerateForm = null;
    private static Logger log = LogManager.getLogger(ExtensionAntiCSRF.class);
    private AntiCsrfParam antiCsrfParam;
    private AntiCsrfDetectScanner antiCsrfDetectScanner;
    private HistoryReferenceFactory historyReferenceFactory;

    public ExtensionAntiCSRF() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(50);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public void init() {
        this.antiCsrfParam = new AntiCsrfParam();
        this.antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("acsrf.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionPassiveScan extensionPassiveScan;
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.antiCsrfParam);
        final ExtensionHistory extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        this.historyReferenceFactory = extensionHistory != null ? new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int id) {
                return extensionHistory.getHistoryReference(id);
            }
        } : new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int id) throws HttpMalformedHeaderException, DatabaseException {
                return new HistoryReference(id);
            }
        };
        AntiCsrfToken.setHistoryReferenceFactory(this.historyReferenceFactory);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAntiCsrfPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuGenerateForm());
        }
        if ((extensionPassiveScan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class)) != null) {
            extensionPassiveScan.addPassiveScanner(this.antiCsrfDetectScanner);
        }
        AntiCsrfAPI api = new AntiCsrfAPI(this);
        api.addApiOptions(this.getParam());
        extensionHook.addApiImplementor(api);
    }

    @Override
    public void unload() {
        ExtensionPassiveScan extensionPassiveScan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class);
        if (extensionPassiveScan != null) {
            extensionPassiveScan.removePassiveScanner(this.antiCsrfDetectScanner);
        }
        super.unload();
    }

    private PopupMenuGenerateForm getPopupMenuGenerateForm() {
        if (this.popupMenuGenerateForm == null) {
            this.popupMenuGenerateForm = new PopupMenuGenerateForm(Constant.messages.getString("anticsrf.genForm.popup"));
        }
        return this.popupMenuGenerateForm;
    }

    private OptionsAntiCsrfPanel getOptionsAntiCsrfPanel() {
        if (this.optionsAntiCsrfPanel == null) {
            this.optionsAntiCsrfPanel = new OptionsAntiCsrfPanel();
        }
        return this.optionsAntiCsrfPanel;
    }

    protected AntiCsrfParam getParam() {
        return this.antiCsrfParam;
    }

    void setParam(AntiCsrfParam antiCsrfParam) {
        this.antiCsrfParam = antiCsrfParam;
    }

    public List<String> getAntiCsrfTokenNames() {
        return this.getParam().getTokensNames();
    }

    public void addAntiCsrfTokenName(String token) {
        this.getParam().addToken(token);
    }

    public void removeAntiCsrfTokenName(String token) {
        this.getParam().removeToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAntiCsrfToken(AntiCsrfToken token) {
        log.debug("registerAntiCsrfToken " + token.getMsg().getRequestHeader().getURI().toString() + " " + token.getValue());
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            try {
                HistoryReference hRef = token.getMsg().getHistoryRef();
                if (hRef == null) {
                    hRef = new HistoryReference(this.getModel().getSession(), 0, token.getMsg());
                    token.getMsg().setHistoryRef(null);
                }
                token.setHistoryReferenceId(hRef.getHistoryId());
                this.valueToToken.put(ExtensionAntiCSRF.getURLEncode(token.getValue()), token);
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                log.error("Failed to persist the message: ", (Throwable)e);
            }
        }
    }

    public boolean requestHasToken(HttpMessage msg) {
        return this.requestHasToken(msg.getRequestBody().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestHasToken(String reqBody) {
        Set<String> values;
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            values = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String token : values) {
            if (reqBody.indexOf(token) < 0) continue;
            return true;
        }
        return false;
    }

    public List<AntiCsrfToken> getTokens(HttpMessage msg) {
        return this.getTokens(msg.getRequestBody().toString(), msg.getRequestHeader().getURI().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AntiCsrfToken> getTokens(String reqBody, String targetUrl) {
        Set<String> values;
        ArrayList<AntiCsrfToken> tokens = new ArrayList<AntiCsrfToken>();
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            values = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String value : values) {
            if (reqBody.indexOf(value) < 0) continue;
            AntiCsrfToken token = this.valueToToken.get(value).clone();
            token.setTargetURL(targetUrl);
            tokens.add(token);
        }
        return tokens;
    }

    public String getTokenValue(HttpMessage tokenMsg, String tokenName) {
        Source source = new Source((CharSequence)tokenMsg.getResponseBody().toString());
        List formElements = source.getAllElements("form");
        if (formElements != null && formElements.size() > 0) {
            for (Element formElement : formElements) {
                List inputElements = formElement.getAllElements("input");
                if (inputElements == null || inputElements.size() <= 0) continue;
                for (Element inputElement : inputElements) {
                    String id = inputElement.getAttributeValue("ID");
                    if (id != null && id.equalsIgnoreCase(tokenName)) {
                        return inputElement.getAttributeValue("VALUE");
                    }
                    String name = inputElement.getAttributeValue("NAME");
                    if (name == null || !name.equalsIgnoreCase(tokenName)) continue;
                    return inputElement.getAttributeValue("VALUE");
                }
            }
        }
        return null;
    }

    public List<AntiCsrfToken> getTokensFromResponse(HttpMessage msg) {
        return this.getTokensFromResponse(msg, new Source((CharSequence)msg.getResponseBody().toString()));
    }

    public List<AntiCsrfToken> getTokensFromResponse(HttpMessage msg, Source source) {
        ArrayList<AntiCsrfToken> list = new ArrayList<AntiCsrfToken>();
        List formElements = source.getAllElements("form");
        if (formElements != null && formElements.size() > 0) {
            log.debug("Found " + formElements.size() + " forms");
            int formIndex = 0;
            for (Element formElement : formElements) {
                List inputElements = formElement.getAllElements("input");
                if (inputElements != null && inputElements.size() > 0) {
                    log.debug("Found " + inputElements.size() + " inputs");
                    for (Element inputElement : inputElements) {
                        String name;
                        String value = inputElement.getAttributeValue("VALUE");
                        if (value == null) continue;
                        String attId = inputElement.getAttributeValue("ID");
                        boolean found = false;
                        if (this.isKnownAntiCsrfToken(attId)) {
                            list.add(new AntiCsrfToken(msg, attId, value, formIndex));
                            found = true;
                        }
                        if (found || !this.isKnownAntiCsrfToken(name = inputElement.getAttributeValue("NAME"))) continue;
                        list.add(new AntiCsrfToken(msg, name, value, formIndex));
                    }
                }
                ++formIndex;
            }
        }
        return list;
    }

    private boolean isKnownAntiCsrfToken(String name) {
        if (name == null) {
            return false;
        }
        for (String tokenName : this.getAntiCsrfTokenNames()) {
            if ((!this.getParam().isPartialMatchingEnabled() || !StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)tokenName)) && !tokenName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionChanged(Session session) {
        if (session == null) {
            return;
        }
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            this.valueToToken.clear();
        }
        try {
            List<Integer> list = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15);
            HistoryFilter filter = new HistoryFilter();
            filter.setTags(Arrays.asList(TAG));
            AntiCsrfDetectScanner antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
            for (Integer i : list) {
                HistoryReference hRef = this.historyReferenceFactory.createHistoryReference(i);
                if (!filter.matches(hRef)) continue;
                HttpMessage msg = hRef.getHttpMessage();
                Source src = new Source((CharSequence)msg.getResponseBody().toString());
                if (!msg.isResponseFromTargetHost()) continue;
                antiCsrfDetectScanner.scanHttpResponseReceive(msg, hRef.getHistoryId(), src);
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAntiCsrfToken(String name) {
        if (name == null) {
            return false;
        }
        return this.getParam().getTokensNames().contains(name.toLowerCase());
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("anticsrf.desc");
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public String generateForm(int hrefId) throws Exception {
        HistoryReference hr;
        ExtensionHistory extHist = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        if (extHist != null && (hr = extHist.getHistoryReference(hrefId)) != null) {
            return this.generateForm(hr.getHttpMessage());
        }
        return null;
    }

    public String generateForm(HttpMessage msg) throws UnsupportedEncodingException {
        String requestUri = msg.getRequestHeader().getURI().toString();
        StringBuilder sb = new StringBuilder(300);
        sb.append("<html>\n");
        sb.append("<body>\n");
        sb.append("<h3>");
        String uriEscaped = StringEscapeUtils.escapeHtml((String)requestUri);
        sb.append(uriEscaped);
        sb.append("</h3>");
        sb.append("<form id=\"f1\" method=\"POST\" action=\"").append(uriEscaped).append("\">\n");
        sb.append("<table>\n");
        TreeSet<HtmlParameter> params = msg.getFormParams();
        for (HtmlParameter htmlParam : params) {
            String name = StringEscapeUtils.escapeHtml((String)ExtensionAntiCSRF.urlDecode(htmlParam.getName()));
            String value = StringEscapeUtils.escapeHtml((String)ExtensionAntiCSRF.urlDecode(htmlParam.getValue()));
            sb.append("<tr><td>\n");
            sb.append(name);
            sb.append("<td>");
            sb.append("<input name=\"");
            sb.append(name);
            sb.append("\" value=\"");
            sb.append(value);
            sb.append("\" size=\"100\">");
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
        sb.append("<input id=\"submit\" type=\"submit\" value=\"Submit\"/>\n");
        sb.append("</form>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value;
        }
    }

    public void regenerateAntiCsrfToken(HttpMessage message, HttpMessageSender httpSender) {
        List<AntiCsrfToken> tokens = this.getTokens(message);
        AntiCsrfToken antiCsrfToken = null;
        if (tokens.size() > 0) {
            antiCsrfToken = tokens.get(0);
        }
        if (antiCsrfToken == null) {
            return;
        }
        String tokenValue = null;
        try {
            HttpMessage tokenMsg = antiCsrfToken.getMsg().cloneAll();
            httpSender.sendAndReceive(tokenMsg);
            tokenValue = this.getTokenValue(tokenMsg, antiCsrfToken.getName());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (tokenValue != null) {
            log.debug("regenerateAntiCsrfToken replacing " + antiCsrfToken.getValue() + " with " + ExtensionAntiCSRF.getURLEncode(tokenValue));
            String replaced = message.getRequestBody().toString();
            replaced = replaced.replace(ExtensionAntiCSRF.getURLEncode(antiCsrfToken.getValue()), ExtensionAntiCSRF.getURLEncode(tokenValue));
            message.setRequestBody(replaced);
            this.registerAntiCsrfToken(new AntiCsrfToken(message, antiCsrfToken.getName(), tokenValue, antiCsrfToken.getFormIndex()));
        }
    }

    private static String getURLEncode(String msg) {
        String result = "";
        try {
            result = URLEncoder.encode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    static interface HistoryReferenceFactory {
        public HistoryReference createHistoryReference(int var1) throws DatabaseException, HttpMalformedHeaderException;
    }
}

