/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.empty;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyTileFactory
extends TileFactory {
    private BufferedImage emptyTile;
    HashMap<String, HashMap<String, Tile>> requiredTiles = new HashMap();

    public EmptyTileFactory() {
        this(new TileFactoryInfo("EmptyTileFactory 256x256", 1, 15, 17, 256, true, true, "", "x", "y", "z"));
    }

    public EmptyTileFactory(TileFactoryInfo info) {
        super(info);
        int tileSize = info.getTileSize(info.getMinimumZoomLevel());
        this.emptyTile = new BufferedImage(tileSize, tileSize, 2);
        Graphics2D g = this.emptyTile.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, tileSize, tileSize);
        g.setColor(Color.WHITE);
        g.drawOval(10, 10, tileSize - 20, tileSize - 20);
        g.fillOval(70, 50, 20, 20);
        g.fillOval(tileSize - 90, 50, 20, 20);
        g.fillOval(tileSize / 2 - 10, tileSize / 2 - 10, 20, 20);
        g.dispose();
    }

    @Override
    public Tile getTile(String key, String mapName) {
        return this.requiredTiles.get(mapName).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequiredTiles(Collection<Tile> tiles, String mapName) {
        HashMap<String, HashMap<String, Tile>> hashMap = this.requiredTiles;
        synchronized (hashMap) {
            HashMap<String, Tile> requiredTilesForMap = this.requiredTiles.get(mapName);
            if (requiredTilesForMap == null) {
                requiredTilesForMap = new HashMap();
                this.requiredTiles.put(mapName, requiredTilesForMap);
            }
            for (Tile tile : tiles) {
                if (requiredTilesForMap.containsKey(tile.getKey())) continue;
                tile.setImage(this.emptyTile);
                requiredTilesForMap.put(tile.getKey(), tile);
            }
            this.requiredTiles.notifyAll();
        }
    }
}

