/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.filemode;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.NodeAdapter;
import freemind.modes.filemode.FileEdgeModel;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

public class FileNodeModel
extends NodeAdapter {
    private File file;
    private Color color;

    public FileNodeModel(File file, FreeMindMain frame, MindMap map) {
        super(frame, map);
        this.setEdge(new FileEdgeModel(this, this.getFrame()));
        this.file = file;
        this.setFolded(!file.isFile());
    }

    @Override
    public String getStyle() {
        return "fork";
    }

    File getFile() {
        return this.file;
    }

    @Override
    public Color getColor() {
        if (this.color == null) {
            this.color = this.isLeaf() ? Color.BLACK : Color.GRAY;
        }
        return this.color;
    }

    @Override
    public String toString() {
        String name = this.file.getName();
        if (name.equals("")) {
            name = "Root";
        }
        return name;
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public boolean hasChildren() {
        return !this.file.isFile() || this.children != null && !this.children.isEmpty();
    }

    @Override
    public ListIterator childrenFolded() {
        if (!this.isRoot() && (this.isFolded() || this.isLeaf())) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return this.childrenUnfolded();
    }

    @Override
    public ListIterator childrenUnfolded() {
        if (this.children != null) {
            return this.children.listIterator();
        }
        try {
            String[] files = this.file.list();
            if (files != null) {
                this.children = new LinkedList();
                String path = this.file.getPath();
                for (int i = 0; i < files.length; ++i) {
                    File childFile = new File(path, files[i]);
                    if (childFile.isHidden()) continue;
                    FileNodeModel fileNodeModel = new FileNodeModel(childFile, this.getFrame(), this.getMap());
                    fileNodeModel.setLeft(this.isNewChildLeft());
                    this.insert(fileNodeModel, this.getChildCount());
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.children != null ? this.children.listIterator() : Collections.EMPTY_LIST.listIterator();
    }

    @Override
    public boolean isLeaf() {
        return this.file.isFile();
    }

    @Override
    public String getLink() {
        try {
            return Tools.fileToUrl(this.file).toString();
        }
        catch (MalformedURLException e) {
            Resources.getInstance().logException(e);
            return this.file.toString();
        }
    }

    @Override
    public boolean isWriteable() {
        return false;
    }
}

