/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.NumberUtils;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class Altitude {
    private boolean _valid = false;
    private int _value = 0;
    private Unit _unit = null;
    private String _stringValue = null;
    public static final Altitude NONE = new Altitude(null, null);

    public Altitude(String string, Unit unit) {
        this._unit = unit;
        if (string != null && !string.equals("")) {
            try {
                this._stringValue = string;
                this._value = (int)Double.parseDouble(string.trim());
                this._valid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Altitude(int n, Unit unit) {
        this._value = n;
        this._unit = unit;
        this._valid = true;
        this._stringValue = "" + n;
    }

    public Altitude clone() {
        return new Altitude(this._stringValue, this._unit);
    }

    public void reset(Altitude altitude) {
        this._stringValue = altitude._stringValue;
        this._value = altitude._value;
        this._unit = altitude._unit;
        this._valid = altitude._valid;
    }

    public boolean isValid() {
        return this._valid;
    }

    public int getValue() {
        return this._value;
    }

    public int getValue(Unit unit) {
        if (unit == null) {
            return this.getValue();
        }
        return (int)(this.getMetricValue() * unit.getMultFactorFromStd());
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getMetricValue() {
        if (this._unit == UnitSetLibrary.UNITS_METRES || this._unit == null) {
            return this._value;
        }
        return (double)this._value / this._unit.getMultFactorFromStd();
    }

    public String getStringValue(Unit unit) {
        if (!this._valid) {
            return "";
        }
        if (!(unit != this._unit && unit != null || this._stringValue == null || this._stringValue.equals(""))) {
            return this._stringValue;
        }
        return "" + this.getValue(unit);
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, int n, int n2) {
        return Altitude.interpolate(altitude, altitude2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, double d) {
        if (altitude == null || altitude2 == null || !altitude.isValid() || !altitude2.isValid()) {
            return NONE;
        }
        Unit unit = altitude.getUnit();
        int n = altitude.getValue();
        int n2 = altitude2.getValue(unit);
        int n3 = n + (int)((double)(n2 - n) * d);
        return new Altitude(n3, unit);
    }

    public void addOffset(double d, Unit unit, int n) {
        int n2 = NumberUtils.getDecimalPlaces(this._stringValue);
        if (n2 < n) {
            n2 = n;
        }
        double d2 = d;
        if (unit != this._unit && unit != null) {
            d2 = d / unit.getMultFactorFromStd() * this._unit.getMultFactorFromStd();
        }
        if (this._stringValue == null) {
            System.err.println("*** Altitude.addOffset - how did the string value get to be null?");
        }
        double d3 = Double.parseDouble(this._stringValue.trim()) + d2;
        this._value = (int)d3;
        this._stringValue = NumberUtils.formatNumberUk(d3, n2);
    }
}

