/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.olc;

import tim.prune.function.olc.ParseException;

class CoordPair {
    private static final String ALPHABET = "23456789CFGHJMPQRVWX";
    public double lat = 0.0;
    public double lon = 0.0;
    public static CoordPair PADDING = new CoordPair(-1.0, -1.0);

    public CoordPair(double d, double d2) {
        this.lat = d;
        this.lon = d2;
    }

    public static CoordPair decode(char c, char c2) throws ParseException {
        boolean bl;
        boolean bl2 = c == '0';
        boolean bl3 = bl = c2 == '0';
        if (bl2 && bl) {
            return PADDING;
        }
        if (bl2 || bl) {
            throw new ParseException();
        }
        double d = CoordPair.decodeChar(c);
        double d2 = CoordPair.decodeChar(c2);
        return new CoordPair(d / 20.0, d2 / 20.0);
    }

    public static CoordPair decode(char c) throws ParseException {
        int n = CoordPair.decodeChar(c);
        int n2 = n / 4;
        int n3 = n % 4;
        return new CoordPair((double)n2 / 5.0, (double)n3 / 4.0);
    }

    private static int decodeChar(char c) throws ParseException {
        int n = ALPHABET.indexOf(c);
        if (n < 0) {
            throw new ParseException();
        }
        return n;
    }
}

