/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.FileInfo;
import tim.prune.data.PhotoList;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoLoad
implements UndoOperation {
    private int _cropIndex = -1;
    private int _numLoaded = -1;
    private DataPoint[] _contents = null;
    private PhotoList _photoList = null;
    private FileInfo _oldFileInfo = null;
    private int _numPhotos = -1;
    private int _numAudios = -1;

    public UndoLoad(int n, int n2) {
        this._cropIndex = n;
        this._numLoaded = n2;
        this._contents = null;
    }

    public UndoLoad(TrackInfo trackInfo, int n, PhotoList photoList) {
        this._cropIndex = -1;
        this._numLoaded = n;
        this._contents = trackInfo.getTrack().cloneContents();
        this._oldFileInfo = trackInfo.getFileInfo().clone();
        this._photoList = photoList;
    }

    @Override
    public String getDescription() {
        String string = I18nManager.getText("undo.load");
        if (this._numLoaded > 0) {
            string = String.valueOf(string) + " (" + this._numLoaded + ")";
        }
        return string;
    }

    public void setNumPhotosAudios(int n, int n2) {
        this._numPhotos = n;
        this._numAudios = n2;
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        if (this._oldFileInfo == null) {
            trackInfo.getFileInfo().removeSource();
        } else {
            trackInfo.setFileInfo(this._oldFileInfo);
        }
        if (this._contents == null) {
            trackInfo.getTrack().cropTo(this._cropIndex);
        } else {
            if (this._photoList != null) {
                trackInfo.getPhotoList().restore(this._photoList);
            }
            if (this._numPhotos > -1) {
                trackInfo.getPhotoList().cropTo(this._numPhotos);
            }
            if (this._numAudios > -1) {
                trackInfo.getAudioList().cropTo(this._numAudios);
            }
            if (!trackInfo.getTrack().replaceContents(this._contents)) {
                throw new UndoException(this.getDescription());
            }
        }
        trackInfo.getSelection().clearAll();
    }
}

