# arr-filter [![NPM version](https://img.shields.io/npm/v/arr-filter.svg?style=flat)](https://www.npmjs.com/package/arr-filter) [![NPM monthly downloads](https://img.shields.io/npm/dm/arr-filter.svg?style=flat)](https://npmjs.org/package/arr-filter)  [![NPM total downloads](https://img.shields.io/npm/dt/arr-filter.svg?style=flat)](https://npmjs.org/package/arr-filter) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/arr-filter.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/arr-filter)

> Faster alternative to javascript's native filter method.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save arr-filter
```

## Usage

```js
var filter = require('arr-filter');

filter(['a', {a: 'b'}, 1, 'b', 2, {c: 'd'}, 'c'], function (ele) {
  return typeof ele === 'string';
});
//=> ['a', 'b', 'c']
```

## Why another array filter?

[array-filter](https://github.com/juliangruber/array-filter) is pretty popular, but it's tuned to be used in older browsers and it falls back on native `.filter()` when available, which is much slower. See [jsperf results](http://jsperf.com/array-filter-while-vs-for/2). The functions used in the benchmarks are the top performers from a dozen or so other functions.

## About

### Related projects

* [arr-map](https://www.npmjs.com/package/arr-map): Faster, node.js focused alternative to JavaScript's native array map. | [homepage](https://github.com/jonschlinkert/arr-map "Faster, node.js focused alternative to JavaScript's native array map.")
* [array-each](https://www.npmjs.com/package/array-each): Loop over each item in an array and call the given function on every element. | [homepage](https://github.com/jonschlinkert/array-each "Loop over each item in an array and call the given function on every element.")
* [collection-map](https://www.npmjs.com/package/collection-map): Returns an array of mapped values from an array or object. | [homepage](https://github.com/jonschlinkert/collection-map "Returns an array of mapped values from an array or object.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.2, on February 26, 2017._