/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class MapMode
extends JosmAction
implements MouseListener,
MouseMotionListener,
PreferenceChangedListener {
    protected final Cursor cursor;
    protected boolean ctrl;
    protected boolean alt;
    protected boolean shift;

    protected MapMode(String name, String iconName, String tooltip, Shortcut shortcut, Cursor cursor) {
        super(name, "mapmode/" + iconName, tooltip, shortcut, false);
        this.cursor = cursor;
        this.putValue("active", Boolean.FALSE);
    }

    protected MapMode(String name, String iconName, String tooltip, Cursor cursor) {
        this.putValue("Name", name);
        new ImageProvider("mapmode", iconName).getResource().attachImageIcon(this);
        this.putValue("ShortDescription", tooltip);
        this.cursor = cursor;
    }

    public void enterMode() {
        Logging.debug("Entering map mode: {0}", this.getValue("Name"));
        this.putValue("active", Boolean.TRUE);
        Config.getPref().addPreferenceChangeListener(this);
        this.readPreferences();
        MainApplication.getMap().mapView.setNewCursor(this.cursor, (Object)this);
        MainApplication.getMap().statusLine.setAutoLength(true);
        this.updateStatusLine();
    }

    public void exitMode() {
        Logging.debug("Exiting map mode: {0}", this.getValue("Name"));
        this.putValue("active", Boolean.FALSE);
        Config.getPref().removePreferenceChangeListener(this);
        MainApplication.getMap().mapView.resetCursor(this);
        MainApplication.getMap().statusLine.setAutoLength(true);
    }

    protected void updateStatusLine() {
        MapFrame map = MainApplication.getMap();
        if (map != null && map.statusLine != null) {
            map.statusLine.setHelpText(this.getModeHelpText());
            map.statusLine.repaint();
        }
    }

    public String getModeHelpText() {
        return "";
    }

    protected void readPreferences() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (MainApplication.isDisplayingMapView()) {
            MainApplication.getMap().selectMapMode(this);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l != null;
    }

    protected void updateKeyModifiers(InputEvent e) {
        this.updateKeyModifiersEx(e.getModifiersEx());
    }

    protected void updateKeyModifiers(MouseEvent e) {
        this.updateKeyModifiersEx(e.getModifiersEx());
    }

    protected void updateKeyModifiers(ActionEvent e) {
        this.updateKeyModifiersEx(MapMode.mapOldModifiers(e.getModifiers()));
    }

    protected void updateKeyModifiersEx(int modifiers) {
        this.ctrl = (modifiers & 0x80) != 0;
        this.alt = (modifiers & 0x2200) != 0;
        this.shift = (modifiers & 0x40) != 0;
    }

    private static int mapOldModifiers(int modifiers) {
        if ((modifiers & 2) != 0) {
            modifiers |= 0x80;
        }
        if ((modifiers & 8) != 0) {
            modifiers |= 0x200;
        }
        if ((modifiers & 0x20) != 0) {
            modifiers |= 0x2000;
        }
        if ((modifiers & 1) != 0) {
            modifiers |= 0x40;
        }
        return modifiers;
    }

    protected void requestFocusInMapView() {
        if (this.isEnabled()) {
            MainApplication.getMap().mapView.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        this.readPreferences();
    }

    protected boolean isEditableDataLayer(Layer l) {
        return l instanceof OsmDataLayer && !((OsmDataLayer)l).isLocked();
    }
}

