/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class ClipboardUtils {
    private static Clipboard clipboard;

    private ClipboardUtils() {
    }

    public static synchronized Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (HeadlessException | SecurityException e) {
                Logging.warn("Using fake clipboard.", e);
                clipboard = new Clipboard("fake");
            }
        }
        return clipboard;
    }

    public static Clipboard getSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return Toolkit.getDefaultToolkit().getSystemSelection();
    }

    public static String getClipboardStringContent() {
        try {
            Transferable t = ClipboardUtils.getClipboardContent();
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logging.error(ex);
        }
        return null;
    }

    public static synchronized Transferable getClipboardContent() {
        return ClipboardUtils.getClipboardContent(ClipboardUtils.getClipboard());
    }

    public static Transferable getClipboardContent(Clipboard clipboard) {
        Transferable t = null;
        for (int tries = 0; t == null && tries < 10; ++tries) {
            try {
                t = clipboard.getContents(null);
                continue;
            }
            catch (IllegalStateException e) {
                Logging.trace("Clipboard unavailable.", e);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Logging.log(Logging.LEVEL_WARN, "InterruptedException in " + Utils.class.getSimpleName() + " while getting clipboard content", ex);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (NullPointerException e) {
                Logging.error(e);
            }
        }
        return t;
    }

    public static boolean copyString(String s) {
        return ClipboardUtils.copy(new StringSelection(s));
    }

    public static boolean copy(Transferable transferable) {
        return GuiHelper.runInEDTAndWaitAndReturn(() -> {
            try {
                ClipboardUtils.getClipboard().setContents(transferable, new DoNothingClipboardOwner());
                return Boolean.TRUE;
            }
            catch (IllegalStateException ex) {
                Logging.error(ex);
                return Boolean.FALSE;
            }
        });
    }

    public static DataFlavor newDataFlavor(Class<?> c, String humanPresentableName) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + c.getName(), humanPresentableName, c.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean clear() {
        return ClipboardUtils.copy(new StringSelection(""));
    }

    private static final class DoNothingClipboardOwner
    implements ClipboardOwner {
        private DoNothingClipboardOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clpbrd, Transferable t) {
        }
    }
}

