/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.util.TableHelper;

public class SelectionSynchronizer
implements ListSelectionListener {
    private final Set<ListSelectionModel> participants;
    private boolean preventRecursion;
    private BiFunction<Integer, ListSelectionModel, IntStream> selectionIndexMapper = (i, model) -> IntStream.of((int)i);

    public SelectionSynchronizer() {
        this.participants = new HashSet<ListSelectionModel>();
    }

    public void participateInSynchronizedSelection(ListSelectionModel model) {
        if (model == null) {
            return;
        }
        if (this.participants.contains(model)) {
            return;
        }
        this.participants.add(model);
        model.addListSelectionListener(this);
    }

    void setSelectionIndexMapper(BiFunction<Integer, ListSelectionModel, IntStream> selectionIndexMapper) {
        this.selectionIndexMapper = Objects.requireNonNull(selectionIndexMapper);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.preventRecursion) {
            return;
        }
        this.preventRecursion = true;
        ListSelectionModel referenceModel = (ListSelectionModel)e.getSource();
        int[] selectedIndices = TableHelper.getSelectedIndices(referenceModel);
        for (ListSelectionModel model : this.participants) {
            if (model == referenceModel) continue;
            TableHelper.setSelectedIndices(model, Arrays.stream(selectedIndices).flatMap(i -> this.selectionIndexMapper.apply(i, referenceModel)));
        }
        this.preventRecursion = false;
    }
}

