/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public final class GraphicUtils {
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 1, 1);
    public static final Color SELECTION_COLOR = new Color(166, 202, 240);
    public static final Color TOOLTIP_COLOR = new Color(166, 202, 240);
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static Hashtable<String, Image> imageCache = new Hashtable();

    private GraphicUtils() {
    }

    public static void centerWindowOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = window.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        window.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static void drawHighlightBorder(Graphics g, int x, int y, int width, int height, boolean raised, Color shadow, Color highlight) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(raised ? highlight : shadow);
        g.drawLine(0, 0, width - 2, 0);
        g.drawLine(0, 1, 0, height - 2);
        g.setColor(raised ? shadow : highlight);
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 2, height - 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public static Insets getHighlightBorderInsets() {
        return HIGHLIGHT_INSETS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImageIcon(Image image) {
        if (image == null) {
            return null;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return new ImageIcon(image);
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, MouseEvent event) {
        Component source = (Component)event.getSource();
        Point topLeftSource = source.getLocationOnScreen();
        Point ptRet = GraphicUtils.getPopupMenuShowPoint(popup, topLeftSource.x + event.getX(), topLeftSource.y + event.getY());
        ptRet.translate(-topLeftSource.x, -topLeftSource.y);
        return ptRet;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, int x, int y) {
        Dimension sizeMenu = popup.getPreferredSize();
        Point bottomRightMenu = new Point(x + sizeMenu.width, y + sizeMenu.height);
        for (Rectangle screenBounds : GraphicUtils.getScreenBounds()) {
            if (screenBounds.x > x || x > screenBounds.x + screenBounds.width) continue;
            Dimension sizeScreen = screenBounds.getSize();
            sizeScreen.height -= 32;
            int xOffset = 0;
            if (bottomRightMenu.x > screenBounds.x + sizeScreen.width) {
                xOffset = -sizeMenu.width;
            }
            int yOffset = 0;
            if (bottomRightMenu.y > screenBounds.y + sizeScreen.height) {
                yOffset = sizeScreen.height - bottomRightMenu.y;
            }
            return new Point(x + xOffset, y + yOffset);
        }
        return new Point(x, y);
    }

    public static void centerWindowOnComponent(Window window, Component over) {
        if (over == null || !over.isShowing()) {
            GraphicUtils.centerWindowOnScreen(window);
            return;
        }
        Point parentLocation = over.getLocationOnScreen();
        Dimension parentSize = over.getSize();
        Dimension size = window.getSize();
        int x = parentLocation.x + (parentSize.width - size.width) / 2;
        int y = parentLocation.y + (parentSize.height - size.height) / 2;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (x + size.width > screenSize.width) {
            x = screenSize.width - size.width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + size.height > screenSize.height) {
            y = screenSize.height - size.height;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static boolean isAncestorOfFocusedComponent(Component c) {
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = cont.getComponent(i);
                if (!GraphicUtils.isAncestorOfFocusedComponent(child)) continue;
                return true;
            }
        }
        return false;
    }

    public static Component getFocusableComponentOrChild(Component c, boolean deepest) {
        if (c != null && c.isEnabled() && c.isVisible() && c instanceof Container) {
            JComponent jc;
            Container cont = (Container)c;
            if (!deepest && c instanceof JComponent && (jc = (JComponent)c).isRequestFocusEnabled()) {
                return jc;
            }
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = cont.getComponent(i);
                Component focused = GraphicUtils.getFocusableComponentOrChild(child, deepest);
                if (focused == null) continue;
                return focused;
            }
            if (c instanceof JComponent) {
                JComponent jc2;
                if (deepest && (jc2 = (JComponent)c).isRequestFocusEnabled()) {
                    return jc2;
                }
            } else {
                return c;
            }
        }
        return null;
    }

    public static Component focusComponentOrChild(Component c) {
        return GraphicUtils.focusComponentOrChild(c, false);
    }

    public static Component focusComponentOrChild(Component c, boolean deepest) {
        Component focusable = GraphicUtils.getFocusableComponentOrChild(c, deepest);
        if (focusable != null) {
            focusable.requestFocus();
        }
        return focusable;
    }

    public static Image loadFromResource(String imageName, Class cls) {
        try {
            URL url = cls.getResource(imageName);
            if (url == null) {
                return null;
            }
            Image image = imageCache.get(url.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(url);
                imageCache.put(url.toString(), image);
            }
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Rectangle[] getScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        Rectangle[] screenBounds = new Rectangle[screenDevices.length];
        for (int i = 0; i < screenDevices.length; ++i) {
            GraphicsDevice screenDevice = screenDevices[i];
            GraphicsConfiguration defaultConfiguration = screenDevice.getDefaultConfiguration();
            screenBounds[i] = defaultConfiguration.getBounds();
        }
        return screenBounds;
    }

    public static final void makeSameSize(JComponent[] comps) {
        if (comps.length == 0) {
            return;
        }
        int max = 0;
        for (int i = 0; i < comps.length; ++i) {
            int w = comps[i].getPreferredSize().width;
            max = Math.max(w, max);
        }
        Dimension dim = new Dimension(max, comps[0].getPreferredSize().height);
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setPreferredSize(dim);
        }
    }

    public static final String toHTMLColor(Color c) {
        int color = c.getRGB();
        String s = Integer.toHexString(color |= 0xFF000000);
        return s.substring(2);
    }

    public static final String createToolTip(String text, int width) {
        String htmlColor = GraphicUtils.toHTMLColor(TOOLTIP_COLOR);
        String toolTip = "<html><table width=" + width + " bgColor=" + htmlColor + "><tr><td><b>" + text + "</b></td></tr></table></table>";
        return toolTip;
    }

    public static final String createToolTip(String text) {
        String htmlColor = GraphicUtils.toHTMLColor(TOOLTIP_COLOR);
        String toolTip = "<html><table  bgColor=" + htmlColor + "><tr><td><b>" + text + "</b></td></tr></table></table>";
        return toolTip;
    }
}

