/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.utils.MTRandom;

public class NoisyInputStream
extends InputStream {
    private final MTRandom rnd;
    private final InputStream source;

    public NoisyInputStream(InputStream source, byte[] pass) {
        this.source = source;
        this.rnd = new MTRandom(pass);
    }

    private byte getNextByte() {
        return (byte)this.rnd.nextInt();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public int read() throws IOException {
        int b = this.source.read();
        if (b == -1) {
            return -1;
        }
        b = (b ^ this.getNextByte()) & 0xFF;
        return b;
    }
}

