/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolPerson
extends USymbol {
    USymbolPerson() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.PERSON;
    }

    private void drawRect(UGraphic ug, double width, double height, boolean shadowing, double roundCorner, double diagonalCorner) {
        UEllipse head = new UEllipse(this.headSize(), this.headSize());
        URectangle body = new URectangle(width, height - this.headSize()).rounded(this.headSize());
        if (shadowing) {
            body.setDeltaShadow(3.0);
            head.setDeltaShadow(1.0);
        }
        double posx = (width - this.headSize()) / 2.0;
        ug.apply(UTranslate.dx(posx)).draw(head);
        ug.apply(UTranslate.dy(this.headSize())).draw(body);
    }

    private double headSize() {
        return 20.0;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolPerson.this.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                USymbol.Margin margin = USymbolPerson.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + USymbolPerson.this.headSize())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return Dimension2DDouble.delta(USymbolPerson.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel)), 0.0, USymbolPerson.this.headSize());
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, final HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolPerson.this.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner(), 0.0);
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolPerson.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolPerson.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = labelAlignment == HorizontalAlignment.LEFT ? 3.0 : (labelAlignment == HorizontalAlignment.RIGHT ? width - dimTitle.getWidth() - 3.0 : (width - dimTitle.getWidth()) / 2.0);
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

