/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandReferenceOverSeveral
extends SingleLineCommand2<SequenceDiagram> {
    public CommandReferenceOverSeveral() {
        super(CommandReferenceOverSeveral.getConcat());
    }

    private static RegexConcat getConcat() {
        return RegexConcat.build(CommandReferenceOverSeveral.class.getName(), RegexLeaf.start(), new RegexLeaf("ref"), new RegexLeaf("REF", "(#\\w+)?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTS", "(([\\p{L}0-9_.@]+|[%g][^%g]+[%g])([%s]*,[%s]*([\\p{L}0-9_.@]+|[%g][^%g]+[%g]))*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("URL", "\\[\\[([^|]*)(?:\\|([^|]*))?\\]\\]")), new RegexLeaf("TEXT", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String s1 = arg.get("REF", 0);
        HColor backColorElement = s1 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s1);
        List<String> participants = StringUtils.splitComma(arg.get("PARTS", 0));
        String url = arg.get("URL", 0);
        String title = arg.get("URL", 1);
        String text = StringUtils.trin(arg.get("TEXT", 0));
        ArrayList<Participant> p = new ArrayList<Participant>();
        for (String s : participants) {
            p.add(diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s)));
        }
        Display strings = Display.getWithNewlines(text);
        Url u = null;
        if (url != null) {
            u = new Url(url, title);
        }
        HColor backColorGeneral = null;
        Reference ref = new Reference(p, u, strings, backColorGeneral, backColorElement, diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addReference(ref);
        return CommandExecutionResult.ok();
    }
}

