/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileBlock;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;
    private static int defaultTileSize = 128;

    public static int getDefaultTileSize() {
        return defaultTileSize;
    }

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle rectangle, Map map) {
        super(rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Map map) {
        super(cachableRed, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        super(cachableRed, rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, null, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, TileStore tileStore, Map map) {
        super.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = tileStore;
        if (this.tiles == null) {
            this.tiles = this.createTileStore();
        }
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, Map map) {
        super(list, rectangle, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(list, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(list, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(list, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    public TileStore getTileStore() {
        return this.tiles;
    }

    protected void setTileStore(TileStore tileStore) {
        this.tiles = tileStore;
    }

    protected TileStore createTileStore() {
        return TileCache.getTileMap(this);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRasterByBlocks(writableRaster);
        return writableRaster;
    }

    public Raster getData(Rectangle rectangle) {
        int n = this.getXTile(rectangle.x);
        int n2 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n3 = this.getYTile(rectangle.y);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n == n2 && n3 == n4) {
            Raster raster = this.getTile(n, n3);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        return super.getData(rectangle);
    }

    public Raster getTile(int n, int n2) {
        return this.tiles.getTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int n, int n2, Raster raster) {
        this.tiles.setTile(n, n2, raster);
    }

    public void copyToRasterByBlocks(WritableRaster writableRaster) {
        Raster raster;
        int n;
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n2 = this.getXTile(rectangle2.x);
        int n3 = this.getYTile(rectangle2.y);
        int n4 = this.getXTile(rectangle2.x + rectangle2.width - 1);
        int n5 = this.getYTile(rectangle2.y + rectangle2.height - 1);
        if (n2 < this.minTileX) {
            n2 = this.minTileX;
        }
        if (n3 < this.minTileY) {
            n3 = this.minTileY;
        }
        if (n4 >= this.minTileX + this.numXTiles) {
            n4 = this.minTileX + this.numXTiles - 1;
        }
        if (n5 >= this.minTileY + this.numYTiles) {
            n5 = this.minTileY + this.numYTiles - 1;
        }
        if (n4 < n2 || n5 < n3) {
            return;
        }
        int n6 = n2;
        int n7 = n4;
        int n8 = n3;
        int n9 = n5;
        int n10 = n2 * this.tileWidth + this.tileGridXOff;
        if (n10 < rectangle2.x && rectangle.x != rectangle2.x) {
            ++n6;
        }
        if ((n = n3 * this.tileHeight + this.tileGridYOff) < rectangle2.y && rectangle.y != rectangle2.y) {
            ++n8;
        }
        if ((n10 = (n4 + 1) * this.tileWidth + this.tileGridXOff - 1) >= rectangle2.x + rectangle2.width && rectangle.x + rectangle.width != rectangle2.x + rectangle2.width) {
            --n7;
        }
        if ((n = (n5 + 1) * this.tileHeight + this.tileGridYOff - 1) >= rectangle2.y + rectangle2.height && rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) {
            --n9;
        }
        int n11 = n7 - n6 + 1;
        int n12 = n9 - n8 + 1;
        boolean[] blArray = null;
        if (n11 > 0 && n12 > 0) {
            blArray = new boolean[n11 * n12];
        }
        boolean[] blArray2 = new boolean[2 * (n4 - n2 + 1) + 2 * (n5 - n3 + 1)];
        int n13 = 0;
        int n14 = 0;
        for (int i = n3; i <= n5; ++i) {
            for (int j = n2; j <= n4; ++j) {
                boolean bl2;
                raster = this.tiles.getTileNoCompute(j, i);
                boolean bl3 = bl2 = raster != null;
                if (i >= n8 && i <= n9 && j >= n6 && j <= n7) {
                    blArray[j - n6 + (i - n8) * n11] = bl2;
                } else {
                    blArray2[n13++] = bl2;
                }
                if (!bl2) continue;
                ++n14;
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        if (n11 > 0 && n12 > 0) {
            TileBlock tileBlock = new TileBlock(n6, n8, n11, n12, blArray, 0, 0, n11, n12);
            this.drawBlock(tileBlock, writableRaster);
        }
        Thread thread = Thread.currentThread();
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        n13 = 0;
        for (n = n3; n <= n5; ++n) {
            for (n10 = n2; n10 <= n4; ++n10) {
                Raster raster2 = this.tiles.getTileNoCompute(n10, n);
                if (n >= n8 && n <= n9 && n10 >= n6 && n10 <= n7) {
                    if (raster2 != null) continue;
                    raster = this.makeTile(n10, n);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(writableRaster, (WritableRaster)raster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(writableRaster, (WritableRaster)raster);
                    }
                    this.tiles.setTile(n10, n, raster);
                    continue;
                }
                if (blArray2[n13++]) continue;
                raster2 = this.getTile(n10, n);
                if (HaltingThread.hasBeenHalted(thread)) {
                    return;
                }
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster2, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster2, writableRaster);
            }
        }
    }

    public void copyToRaster(WritableRaster writableRaster) {
        Raster raster;
        int n;
        int n2;
        Rectangle rectangle = writableRaster.getBounds();
        int n3 = this.getXTile(rectangle.x);
        int n4 = this.getYTile(rectangle.y);
        int n5 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n6 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n3 < this.minTileX) {
            n3 = this.minTileX;
        }
        if (n4 < this.minTileY) {
            n4 = this.minTileY;
        }
        if (n5 >= this.minTileX + this.numXTiles) {
            n5 = this.minTileX + this.numXTiles - 1;
        }
        if (n6 >= this.minTileY + this.numYTiles) {
            n6 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n7 = n5 - n3 + 1;
        boolean[] blArray = new boolean[n7 * (n6 - n4 + 1)];
        for (n2 = n4; n2 <= n6; ++n2) {
            for (n = n3; n <= n5; ++n) {
                raster = this.tiles.getTileNoCompute(n, n2);
                if (raster == null) continue;
                blArray[n - n3 + (n2 - n4) * n7] = true;
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        for (n2 = n4; n2 <= n6; ++n2) {
            for (n = n3; n <= n5; ++n) {
                if (blArray[n - n3 + (n2 - n4) * n7]) continue;
                raster = this.getTile(n, n2);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
    }

    protected void drawBlock(TileBlock tileBlock, WritableRaster writableRaster) {
        TileBlock[] tileBlockArray = tileBlock.getBestSplit();
        if (tileBlockArray == null) {
            return;
        }
        this.drawBlockInPlace(tileBlockArray, writableRaster);
    }

    protected void drawBlockAndCopy(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        int n;
        Object object;
        int n2;
        int n3;
        if (tileBlockArray.length == 1) {
            TileBlock tileBlock = tileBlockArray[0];
            n3 = tileBlock.getXLoc() * this.tileWidth + this.tileGridXOff;
            n2 = tileBlock.getYLoc() * this.tileHeight + this.tileGridYOff;
            if (n3 == writableRaster.getMinX() && n2 == writableRaster.getMinY()) {
                this.drawBlockInPlace(tileBlockArray, writableRaster);
                return;
            }
        }
        int n4 = this.tileWidth;
        n3 = this.tileHeight;
        n2 = 0;
        for (int i = 0; i < tileBlockArray.length; ++i) {
            object = tileBlockArray[i];
            n = ((TileBlock)object).getWidth() * n4 * (((TileBlock)object).getHeight() * n3);
            if (n <= n2) continue;
            n2 = n;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(n2);
        object = new int[]{0xFF0000, 65280, 255, -16777216};
        n = GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false) ? 1 : 0;
        Thread thread = Thread.currentThread();
        for (int i = 0; i < tileBlockArray.length; ++i) {
            TileBlock tileBlock = tileBlockArray[i];
            int n5 = tileBlock.getXLoc() * n4 + this.tileGridXOff;
            int n6 = tileBlock.getYLoc() * n3 + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n5, n6, tileBlock.getWidth() * n4, tileBlock.getHeight() * n3);
            rectangle = rectangle.intersection(this.bounds);
            Point point = new Point(rectangle.x, rectangle.y);
            WritableRaster writableRaster2 = Raster.createPackedRaster(dataBufferInt, rectangle.width, rectangle.height, rectangle.width, (int[])object, point);
            this.genRect(writableRaster2);
            if (n != 0) {
                GraphicsUtil.copyData_INT_PACK(writableRaster2, writableRaster);
            } else {
                GraphicsUtil.copyData_FALLBACK(writableRaster2, writableRaster);
            }
            if (!HaltingThread.hasBeenHalted(thread)) continue;
            return;
        }
    }

    protected void drawBlockInPlace(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        Thread thread = Thread.currentThread();
        int n = this.tileWidth;
        int n2 = this.tileHeight;
        for (int i = 0; i < tileBlockArray.length; ++i) {
            TileBlock tileBlock = tileBlockArray[i];
            int n3 = tileBlock.getXLoc() * n + this.tileGridXOff;
            int n4 = tileBlock.getYLoc() * n2 + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n3, n4, tileBlock.getWidth() * n, tileBlock.getHeight() * n2);
            rectangle = rectangle.intersection(this.bounds);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            this.genRect(writableRaster2);
            if (!HaltingThread.hasBeenHalted(thread)) continue;
            return;
        }
    }
}

