/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.merge;

import java.util.Set;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.action.OntologyFormatPage;
import org.protege.editor.owl.ui.ontology.wizard.create.OntologyIDPanel;
import org.protege.editor.owl.ui.ontology.wizard.create.PhysicalLocationPanel;
import org.protege.editor.owl.ui.ontology.wizard.merge.MergeTypePage;
import org.protege.editor.owl.ui.ontology.wizard.merge.SelectOntologiesPage;
import org.protege.editor.owl.ui.ontology.wizard.merge.SelectTargetOntologyPage;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class MergeOntologiesWizard
extends Wizard {
    private SelectOntologiesPage selectOntologiesPage;
    private OntologyIDPanel IDPanel;
    private PhysicalLocationPanel physicalLocationPanel;
    private OWLModelManager owlModelManager;
    private SelectTargetOntologyPage selectTargetOntologyPage;
    private OntologyFormatPage ontologyFormatPage;

    public MergeOntologiesWizard(OWLEditorKit editorKit) {
        this.setTitle("Create ontology wizard");
        this.owlModelManager = editorKit.getModelManager();
        this.selectOntologiesPage = new SelectOntologiesPage(editorKit, "Select ontologies to merge");
        this.registerWizardPanel("SelectOntologiesPage", (WizardPanel)this.selectOntologiesPage);
        this.selectOntologiesPage.setInstructions("Please select the ontologies that you want to merge into another ontology.");
        this.registerWizardPanel("MergeTypePage", (WizardPanel)new MergeTypePage(editorKit));
        this.IDPanel = new OntologyIDPanel(editorKit);
        this.registerWizardPanel("ONTOLOGY_ID_PANEL", (WizardPanel)this.IDPanel);
        this.physicalLocationPanel = new PhysicalLocationPanel((EditorKit)editorKit);
        this.registerWizardPanel(PhysicalLocationPanel.ID, (WizardPanel)this.physicalLocationPanel);
        this.ontologyFormatPage = new OntologyFormatPage((EditorKit)editorKit);
        this.registerWizardPanel("ONTOLOGY_FORMAT_PANEL", (WizardPanel)this.ontologyFormatPage);
        this.selectTargetOntologyPage = new SelectTargetOntologyPage(editorKit, "Select ontology to merge into");
        this.registerWizardPanel("SelectTargetOntologyPage", (WizardPanel)this.selectTargetOntologyPage);
        this.selectTargetOntologyPage.setInstructions("Please select the target ontology to merge into");
        this.setCurrentPanel("SelectOntologiesPage");
    }

    public Set<OWLOntology> getOntologiesToMerge() {
        return this.selectOntologiesPage.getOntologies();
    }

    public OWLOntology getOntologyToMergeInto() {
        OWLOntology ont = this.selectTargetOntologyPage.getOntology();
        if (ont == null) {
            try {
                OWLOntologyID id = this.IDPanel.getOntologyID();
                ont = this.owlModelManager.createNewOntology(id, this.physicalLocationPanel.getLocationURL());
                this.owlModelManager.getOWLOntologyManager().setOntologyFormat(ont, this.ontologyFormatPage.getFormat());
            }
            catch (OWLOntologyCreationException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
        return ont;
    }
}

