/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.update.PluginDocumentParseException;
import org.protege.editor.core.update.PluginInfo;

public class PluginInfoDocumentParser {
    public static final String ID_PROPERTY_NAME = "id";
    private static final String LABEL_PROPERTY_NAME = "name";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final String DOWNLOAD_PROPERTY_NAME = "download";
    public static final String DOC_PROPERTY_NAME = "readme";
    private static final String LICENSE_PROPERTY_NAME = "license";
    private static final String AUTHOR_PROPERTY_NAME = "author";
    private final URL updateFileLocation;

    public PluginInfoDocumentParser(URL updateFileLocation) {
        this.updateFileLocation = (URL)Preconditions.checkNotNull((Object)updateFileLocation);
    }

    public PluginInfo parseDocument(Optional<Bundle> bundle) throws PluginDocumentParseException {
        try {
            Version version;
            Properties properties = new Properties();
            BufferedInputStream inputStream = new BufferedInputStream(this.updateFileLocation.openStream());
            properties.load(inputStream);
            inputStream.close();
            String id = properties.getProperty(ID_PROPERTY_NAME);
            if (id == null) {
                throw new PluginDocumentParseException(String.format("The plugin update document at %s is not valid.  Reason: No plugin Id given.", this.updateFileLocation));
            }
            if (bundle.isPresent() && !id.equals(bundle.get().getSymbolicName())) {
                throw new PluginDocumentParseException(String.format("The plugin update document at %s has a plugin id (%s) that does not match the expected id (%s)", this.updateFileLocation, id, bundle.get().getSymbolicName()));
            }
            String versionString = properties.getProperty(VERSION_PROPERTY_NAME);
            if (versionString == null) {
                throw new PluginDocumentParseException(String.format("The plugin update document at %s is missing a version string.", this.updateFileLocation));
            }
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException e) {
                throw new PluginDocumentParseException(String.format("The plugin update document at %s contains an illegal version string (%s).", this.updateFileLocation, versionString), e);
            }
            String downloadURLStr = properties.getProperty(DOWNLOAD_PROPERTY_NAME);
            if (downloadURLStr == null) {
                throw new PluginDocumentParseException(String.format("The plugin update document at %s does not contain a download URL", this.updateFileLocation));
            }
            URL downloadURL = new URL(downloadURLStr);
            PluginInfo info = new PluginInfo(id, version, downloadURL);
            String readmeStr = properties.getProperty(DOC_PROPERTY_NAME);
            if (readmeStr != null) {
                info.setReadmeURI(new URL(readmeStr));
            }
            info.setLicense(properties.getProperty(LICENSE_PROPERTY_NAME));
            info.setAuthor(properties.getProperty(AUTHOR_PROPERTY_NAME));
            info.setLabel(properties.getProperty(LABEL_PROPERTY_NAME));
            return info;
        }
        catch (IOException e) {
            throw new PluginDocumentParseException("The plugin document could not be loaded due to a network error: " + e.getClass().getSimpleName() + ", " + e.getMessage(), e);
        }
    }
}

