from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Interface import *
from OCC.Core.TCollection import *
from OCC.Core.gp import *
from OCC.Core.TColStd import *
from OCC.Core.Message import *


class IGESData_Array1OfDirPart:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> IGESData_DirPart: ...
    def __setitem__(self, index: int, value: IGESData_DirPart) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[IGESData_DirPart]: ...
    def next(self) -> IGESData_DirPart: ...
    __next__ = next
    def Init(self, theValue: IGESData_DirPart) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> IGESData_DirPart: ...
    def Last(self) -> IGESData_DirPart: ...
    def Value(self, theIndex: int) -> IGESData_DirPart: ...
    def SetValue(self, theIndex: int, theValue: IGESData_DirPart) -> None: ...

class IGESData_Array1OfIGESEntity:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IGESData_ReadStage(IntEnum):
	IGESData_ReadDir: int = ...
	IGESData_ReadOwn: int = ...
	IGESData_ReadAssocs: int = ...
	IGESData_ReadProps: int = ...
	IGESData_ReadEnd: int = ...
IGESData_ReadDir = IGESData_ReadStage.IGESData_ReadDir
IGESData_ReadOwn = IGESData_ReadStage.IGESData_ReadOwn
IGESData_ReadAssocs = IGESData_ReadStage.IGESData_ReadAssocs
IGESData_ReadProps = IGESData_ReadStage.IGESData_ReadProps
IGESData_ReadEnd = IGESData_ReadStage.IGESData_ReadEnd

class IGESData_DefList(IntEnum):
	IGESData_DefNone: int = ...
	IGESData_DefOne: int = ...
	IGESData_DefSeveral: int = ...
	IGESData_ErrorOne: int = ...
	IGESData_ErrorSeveral: int = ...
IGESData_DefNone = IGESData_DefList.IGESData_DefNone
IGESData_DefOne = IGESData_DefList.IGESData_DefOne
IGESData_DefSeveral = IGESData_DefList.IGESData_DefSeveral
IGESData_ErrorOne = IGESData_DefList.IGESData_ErrorOne
IGESData_ErrorSeveral = IGESData_DefList.IGESData_ErrorSeveral

class IGESData_Status(IntEnum):
	IGESData_EntityOK: int = ...
	IGESData_EntityError: int = ...
	IGESData_ReferenceError: int = ...
	IGESData_TypeError: int = ...
IGESData_EntityOK = IGESData_Status.IGESData_EntityOK
IGESData_EntityError = IGESData_Status.IGESData_EntityError
IGESData_ReferenceError = IGESData_Status.IGESData_ReferenceError
IGESData_TypeError = IGESData_Status.IGESData_TypeError

class IGESData_DefType(IntEnum):
	IGESData_DefVoid: int = ...
	IGESData_DefValue: int = ...
	IGESData_DefReference: int = ...
	IGESData_DefAny: int = ...
	IGESData_ErrorVal: int = ...
	IGESData_ErrorRef: int = ...
IGESData_DefVoid = IGESData_DefType.IGESData_DefVoid
IGESData_DefValue = IGESData_DefType.IGESData_DefValue
IGESData_DefReference = IGESData_DefType.IGESData_DefReference
IGESData_DefAny = IGESData_DefType.IGESData_DefAny
IGESData_ErrorVal = IGESData_DefType.IGESData_ErrorVal
IGESData_ErrorRef = IGESData_DefType.IGESData_ErrorRef

class igesdata:
	@staticmethod
	def Init() -> None: ...
	@staticmethod
	def Protocol() -> IGESData_Protocol: ...

class IGESData_BasicEditor:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, protocol: IGESData_Protocol) -> None: ...
	@overload
	def __init__(self, model: IGESData_IGESModel, protocol: IGESData_Protocol) -> None: ...
	def ApplyUnit(self, enforce: Optional[bool] = False) -> None: ...
	def AutoCorrect(self, ent: IGESData_IGESEntity) -> bool: ...
	def AutoCorrectModel(self) -> int: ...
	def ComputeStatus(self) -> None: ...
	@staticmethod
	def DraftingMax() -> int: ...
	@staticmethod
	def DraftingName(flag: int) -> str: ...
	@staticmethod
	def IGESVersionMax() -> int: ...
	@staticmethod
	def IGESVersionName(flag: int) -> str: ...
	@overload
	def Init(self, protocol: IGESData_Protocol) -> None: ...
	@overload
	def Init(self, model: IGESData_IGESModel, protocol: IGESData_Protocol) -> None: ...
	def Model(self) -> IGESData_IGESModel: ...
	def SetUnitFlag(self, flag: int) -> bool: ...
	def SetUnitName(self, name: str) -> bool: ...
	def SetUnitValue(self, val: float) -> bool: ...
	@staticmethod
	def UnitFlagName(flag: int) -> str: ...
	@staticmethod
	def UnitFlagValue(flag: int) -> float: ...
	@staticmethod
	def UnitNameFlag(name: str) -> int: ...

class IGESData_DefSwitch:
	def __init__(self) -> None: ...
	def DefType(self) -> IGESData_DefType: ...
	def SetRank(self, val: int) -> None: ...
	def SetReference(self) -> None: ...
	def SetVoid(self) -> None: ...
	def Value(self) -> int: ...

class IGESData_DirChecker:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, atype: int) -> None: ...
	@overload
	def __init__(self, atype: int, aform: int) -> None: ...
	@overload
	def __init__(self, atype: int, aform1: int, aform2: int) -> None: ...
	def BlankStatusIgnored(self) -> None: ...
	def BlankStatusRequired(self, val: int) -> None: ...
	def Check(self, ach: Interface_Check, ent: IGESData_IGESEntity) -> None: ...
	def CheckTypeAndForm(self, ach: Interface_Check, ent: IGESData_IGESEntity) -> None: ...
	def Color(self, crit: IGESData_DefType) -> None: ...
	def Correct(self, ent: IGESData_IGESEntity) -> bool: ...
	def GraphicsIgnored(self, hierarchy: Optional[int] = -1) -> None: ...
	def HierarchyStatusIgnored(self) -> None: ...
	def HierarchyStatusRequired(self, val: int) -> None: ...
	def IsSet(self) -> bool: ...
	def LineFont(self, crit: IGESData_DefType) -> None: ...
	def LineWeight(self, crit: IGESData_DefType) -> None: ...
	def SetDefault(self) -> None: ...
	def Structure(self, crit: IGESData_DefType) -> None: ...
	def SubordinateStatusIgnored(self) -> None: ...
	def SubordinateStatusRequired(self, val: int) -> None: ...
	def UseFlagIgnored(self) -> None: ...
	def UseFlagRequired(self, val: int) -> None: ...

class IGESData_DirPart:
	def __init__(self) -> None: ...
	def Init(self, i1: int, i2: int, i3: int, i4: int, i5: int, i6: int, i7: int, i8: int, i9: int, i19: int, i11: int, i12: int, i13: int, i14: int, i15: int, i16: int, i17: int, res1: str, res2: str, label: str, subscript: str) -> None: ...
	def Type(self) -> IGESData_IGESType: ...
	def Values(self, res1: str, res2: str, label: str, subscript: str) -> Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...

class IGESData_FileRecognizer(Standard_Transient):
	def Add(self, reco: IGESData_FileRecognizer) -> None: ...
	def Evaluate(self, akey: IGESData_IGESType, res: IGESData_IGESEntity) -> bool: ...
	def Result(self) -> IGESData_IGESEntity: ...

class IGESData_GeneralModule(Interface_GeneralModule):
	def CanCopy(self, CN: int, ent: Standard_Transient) -> bool: ...
	def CheckCase(self, CN: int, ent: Standard_Transient, shares: Interface_ShareTool, ach: Interface_Check) -> None: ...
	def CopyCase(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> None: ...
	def DirChecker(self, CN: int, ent: IGESData_IGESEntity) -> IGESData_DirChecker: ...
	def FillSharedCase(self, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def ListImpliedCase(self, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def Name(self, CN: int, ent: Standard_Transient, shares: Interface_ShareTool) -> TCollection_HAsciiString: ...
	def NewVoid(self, CN: int, entto: Standard_Transient) -> bool: ...
	def OwnCheckCase(self, CN: int, ent: IGESData_IGESEntity, shares: Interface_ShareTool, ach: Interface_Check) -> None: ...
	def OwnCopyCase(self, CN: int, entfrom: IGESData_IGESEntity, entto: IGESData_IGESEntity, TC: Interface_CopyTool) -> None: ...
	def OwnDeleteCase(self, CN: int, ent: IGESData_IGESEntity) -> None: ...
	def OwnImpliedCase(self, CN: int, ent: IGESData_IGESEntity, iter: Interface_EntityIterator) -> None: ...
	def OwnRenewCase(self, CN: int, entfrom: IGESData_IGESEntity, entto: IGESData_IGESEntity, TC: Interface_CopyTool) -> None: ...
	def OwnSharedCase(self, CN: int, ent: IGESData_IGESEntity, iter: Interface_EntityIterator) -> None: ...
	def RenewImpliedCase(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> None: ...
	def WhenDeleteCase(self, CN: int, ent: Standard_Transient, dispatched: bool) -> None: ...

class IGESData_GlobalNodeOfSpecificLib(Standard_Transient):
	def __init__(self) -> None: ...
	def Add(self, amodule: IGESData_SpecificModule, aprotocol: IGESData_Protocol) -> None: ...
	def Module(self) -> IGESData_SpecificModule: ...
	def Next(self) -> IGESData_GlobalNodeOfSpecificLib: ...
	def Protocol(self) -> IGESData_Protocol: ...

class IGESData_GlobalNodeOfWriterLib(Standard_Transient):
	def __init__(self) -> None: ...
	def Add(self, amodule: IGESData_ReadWriteModule, aprotocol: IGESData_Protocol) -> None: ...
	def Module(self) -> IGESData_ReadWriteModule: ...
	def Next(self) -> IGESData_GlobalNodeOfWriterLib: ...
	def Protocol(self) -> IGESData_Protocol: ...

class IGESData_GlobalSection:
	def __init__(self) -> None: ...
	def ApplicationProtocol(self) -> TCollection_HAsciiString: ...
	def AuthorName(self) -> TCollection_HAsciiString: ...
	def CompanyName(self) -> TCollection_HAsciiString: ...
	def CopyRefs(self) -> None: ...
	def Date(self) -> TCollection_HAsciiString: ...
	def DraftingStandard(self) -> int: ...
	def EndMark(self) -> str: ...
	def FileName(self) -> TCollection_HAsciiString: ...
	def HasApplicationProtocol(self) -> bool: ...
	def HasLastChangeDate(self) -> bool: ...
	def HasMaxCoord(self) -> bool: ...
	def IGESVersion(self) -> int: ...
	def Init(self, params: Interface_ParamSet, ach: Interface_Check) -> None: ...
	def IntegerBits(self) -> int: ...
	def InterfaceVersion(self) -> TCollection_HAsciiString: ...
	def LastChangeDate(self) -> TCollection_HAsciiString: ...
	def LineWeightGrad(self) -> int: ...
	def MaxCoord(self) -> float: ...
	def MaxDigitsDouble(self) -> int: ...
	def MaxDigitsSingle(self) -> int: ...
	def MaxLineWeight(self) -> float: ...
	def MaxMaxCoord(self, val: Optional[float] = 0.0) -> None: ...
	def MaxMaxCoords(self, xyz: gp_XYZ) -> None: ...
	def MaxPower10Double(self) -> int: ...
	def MaxPower10Single(self) -> int: ...
	@overload
	@staticmethod
	def NewDateString(year: int, month: int, day: int, hour: int, minut: int, second: int, mode: Optional[int] = -1) -> TCollection_HAsciiString: ...
	@overload
	@staticmethod
	def NewDateString(date: TCollection_HAsciiString, mode: Optional[int] = 1) -> TCollection_HAsciiString: ...
	def Params(self) -> Interface_ParamSet: ...
	def ReceiveName(self) -> TCollection_HAsciiString: ...
	def Resolution(self) -> float: ...
	def Scale(self) -> float: ...
	def SendName(self) -> TCollection_HAsciiString: ...
	def Separator(self) -> str: ...
	def SetApplicationProtocol(self, val: TCollection_HAsciiString) -> None: ...
	def SetAuthorName(self, val: TCollection_HAsciiString) -> None: ...
	def SetCompanyName(self, val: TCollection_HAsciiString) -> None: ...
	def SetDate(self, val: TCollection_HAsciiString) -> None: ...
	def SetDraftingStandard(self, val: int) -> None: ...
	def SetEndMark(self, val: str) -> None: ...
	def SetFileName(self, val: TCollection_HAsciiString) -> None: ...
	def SetIGESVersion(self, val: int) -> None: ...
	def SetIntegerBits(self, val: int) -> None: ...
	def SetInterfaceVersion(self, val: TCollection_HAsciiString) -> None: ...
	@overload
	def SetLastChangeDate(self) -> None: ...
	@overload
	def SetLastChangeDate(self, val: TCollection_HAsciiString) -> None: ...
	def SetLineWeightGrad(self, val: int) -> None: ...
	def SetMaxCoord(self, val: Optional[float] = 0.0) -> None: ...
	def SetMaxDigitsDouble(self, val: int) -> None: ...
	def SetMaxDigitsSingle(self, val: int) -> None: ...
	def SetMaxLineWeight(self, val: float) -> None: ...
	def SetMaxPower10Double(self, val: int) -> None: ...
	def SetMaxPower10Single(self, val: int) -> None: ...
	def SetReceiveName(self, val: TCollection_HAsciiString) -> None: ...
	def SetResolution(self, val: float) -> None: ...
	def SetScale(self, val: float) -> None: ...
	def SetSendName(self, val: TCollection_HAsciiString) -> None: ...
	def SetSeparator(self, val: str) -> None: ...
	def SetSystemId(self, val: TCollection_HAsciiString) -> None: ...
	def SetUnitFlag(self, val: int) -> None: ...
	def SetUnitName(self, val: TCollection_HAsciiString) -> None: ...
	def SystemId(self) -> TCollection_HAsciiString: ...
	def TranslatedFromHollerith(self, astr: TCollection_HAsciiString) -> TCollection_HAsciiString: ...
	def UnitFlag(self) -> int: ...
	def UnitName(self) -> TCollection_HAsciiString: ...
	def UnitValue(self) -> float: ...

class IGESData_IGESDumper:
	def __init__(self, model: IGESData_IGESModel, protocol: IGESData_Protocol) -> None: ...

class IGESData_IGESEntity(Standard_Transient):
	def AddProperty(self, ent: IGESData_IGESEntity) -> None: ...
	def ArePresentAssociativities(self) -> bool: ...
	def ArePresentProperties(self) -> bool: ...
	def Associate(self, ent: IGESData_IGESEntity) -> None: ...
	def Associativities(self) -> Interface_EntityIterator: ...
	def BlankStatus(self) -> int: ...
	def CResValues(self, res1: str, res2: str) -> bool: ...
	def Color(self) -> IGESData_ColorEntity: ...
	def CompoundLocation(self) -> gp_GTrsf: ...
	def DefColor(self) -> IGESData_DefType: ...
	def DefLevel(self) -> IGESData_DefList: ...
	def DefLineFont(self) -> IGESData_DefType: ...
	def DefView(self) -> IGESData_DefList: ...
	def DirFieldEntity(self, fieldnum: int) -> IGESData_IGESEntity: ...
	def Dissociate(self, ent: IGESData_IGESEntity) -> None: ...
	def FormNumber(self) -> int: ...
	def HasLabelDisplay(self) -> bool: ...
	def HasName(self) -> bool: ...
	def HasOneParent(self) -> bool: ...
	def HasShortLabel(self) -> bool: ...
	def HasStructure(self) -> bool: ...
	def HasSubScriptNumber(self) -> bool: ...
	def HasTransf(self) -> bool: ...
	def HierarchyStatus(self) -> int: ...
	def IGESType(self) -> IGESData_IGESType: ...
	def InitColor(self, ent: IGESData_ColorEntity, rank: Optional[int] = 0) -> None: ...
	def InitDirFieldEntity(self, fieldnum: int, ent: IGESData_IGESEntity) -> None: ...
	def InitLevel(self, ent: IGESData_LevelListEntity, val: Optional[int] = 0) -> None: ...
	def InitLineFont(self, ent: IGESData_LineFontEntity, rank: Optional[int] = 0) -> None: ...
	def InitMisc(self, str: IGESData_IGESEntity, lab: IGESData_LabelDisplayEntity, weightnum: int) -> None: ...
	def InitStatus(self, blank: int, subordinate: int, useflag: int, hierarchy: int) -> None: ...
	def InitTransf(self, ent: IGESData_TransfEntity) -> None: ...
	def InitView(self, ent: IGESData_ViewKindEntity) -> None: ...
	def LabelDisplay(self) -> IGESData_LabelDisplayEntity: ...
	def Level(self) -> int: ...
	def LevelList(self) -> IGESData_LevelListEntity: ...
	def LineFont(self) -> IGESData_LineFontEntity: ...
	def LineWeight(self) -> float: ...
	def LineWeightNumber(self) -> int: ...
	def Location(self) -> gp_GTrsf: ...
	def NameValue(self) -> TCollection_HAsciiString: ...
	def NbAssociativities(self) -> int: ...
	def NbProperties(self) -> int: ...
	def NbTypedAssociativities(self, atype: Standard_Type) -> int: ...
	def NbTypedProperties(self, atype: Standard_Type) -> int: ...
	def Properties(self) -> Interface_EntityIterator: ...
	def RankColor(self) -> int: ...
	def RankLineFont(self) -> int: ...
	def RemoveProperty(self, ent: IGESData_IGESEntity) -> None: ...
	def SetLabel(self, label: TCollection_HAsciiString, sub: Optional[int] = -1) -> None: ...
	def SetLineWeight(self, defw: float, maxw: float, gradw: int) -> None: ...
	def ShortLabel(self) -> TCollection_HAsciiString: ...
	def SingleView(self) -> IGESData_ViewKindEntity: ...
	def Structure(self) -> IGESData_IGESEntity: ...
	def SubScriptNumber(self) -> int: ...
	def SubordinateStatus(self) -> int: ...
	def Transf(self) -> IGESData_TransfEntity: ...
	def TypeNumber(self) -> int: ...
	def TypedAssociativity(self, atype: Standard_Type) -> IGESData_IGESEntity: ...
	def TypedProperty(self, atype: Standard_Type, anum: Optional[int] = 0) -> IGESData_IGESEntity: ...
	def UniqueParent(self) -> IGESData_IGESEntity: ...
	def UseFlag(self) -> int: ...
	def VectorLocation(self) -> gp_GTrsf: ...
	def View(self) -> IGESData_ViewKindEntity: ...
	def ViewList(self) -> IGESData_ViewKindEntity: ...

class IGESData_IGESModel(Interface_InterfaceModel):
	def __init__(self) -> None: ...
	def AddStartLine(self, line: str, atnum: Optional[int] = 0) -> None: ...
	def ApplyStatic(self, param: Optional[str] = "") -> bool: ...
	def ClearHeader(self) -> None: ...
	def ClearLabels(self) -> None: ...
	def ClearStartSection(self) -> None: ...
	def DNum(self, ent: IGESData_IGESEntity) -> int: ...
	def Entity(self, num: int) -> IGESData_IGESEntity: ...
	def GetFromAnother(self, other: Interface_InterfaceModel) -> None: ...
	def GlobalSection(self) -> IGESData_GlobalSection: ...
	def NbStartLines(self) -> int: ...
	def NewEmptyModel(self) -> Interface_InterfaceModel: ...
	def SetGlobalSection(self, header: IGESData_GlobalSection) -> None: ...
	def SetLineWeights(self, defw: float) -> None: ...
	def SetStartSection(self, list: TColStd_HSequenceOfHAsciiString, copy: Optional[bool] = True) -> None: ...
	def StartLine(self, num: int) -> str: ...
	def StartSection(self) -> TColStd_HSequenceOfHAsciiString: ...
	def StringLabel(self, ent: Standard_Transient) -> TCollection_HAsciiString: ...
	def VerifyCheck(self, ach: Interface_Check) -> None: ...

class IGESData_IGESReaderData(Interface_FileReaderData):
	def __init__(self, nbe: int, nbp: int) -> None: ...
	def AddGlobal(self, atype: Interface_ParamType, aval: str) -> None: ...
	def AddStartLine(self, aval: str) -> None: ...
	def DefaultLineWeight(self) -> float: ...
	def DirPart(self, num: int) -> IGESData_DirPart: ...
	def DirType(self, num: int) -> IGESData_IGESType: ...
	def DirValues(self, num: int, res1: str, res2: str, label: str, subs: str) -> Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...
	def FindNextRecord(self, num: int) -> int: ...
	def GlobalCheck(self) -> Interface_Check: ...
	def GlobalSection(self) -> IGESData_GlobalSection: ...
	def NbEntities(self) -> int: ...
	def SetDefaultLineWeight(self, defw: float) -> None: ...
	def SetDirPart(self, num: int, i1: int, i2: int, i3: int, i4: int, i5: int, i6: int, i7: int, i8: int, i9: int, i10: int, i11: int, i12: int, i13: int, i14: int, i15: int, i16: int, i17: int, res1: str, res2: str, label: str, subs: str) -> None: ...
	def SetEntityNumbers(self) -> None: ...
	def SetGlobalSection(self) -> None: ...
	def StartSection(self) -> TColStd_HSequenceOfHAsciiString: ...

class IGESData_IGESReaderTool(Interface_FileReaderTool):
	def __init__(self, reader: IGESData_IGESReaderData, protocol: IGESData_Protocol) -> None: ...
	def AnalyseRecord(self, num: int, anent: Standard_Transient, acheck: Interface_Check) -> bool: ...
	def BeginRead(self, amodel: Interface_InterfaceModel) -> None: ...
	def EndRead(self, amodel: Interface_InterfaceModel) -> None: ...
	def Prepare(self, reco: IGESData_FileRecognizer) -> None: ...
	def ReadAssocs(self, ent: IGESData_IGESEntity, IR: IGESData_IGESReaderData, PR: IGESData_ParamReader) -> None: ...
	def ReadDir(self, ent: IGESData_IGESEntity, IR: IGESData_IGESReaderData, DP: IGESData_DirPart, ach: Interface_Check) -> None: ...
	def ReadOwnParams(self, ent: IGESData_IGESEntity, IR: IGESData_IGESReaderData, PR: IGESData_ParamReader) -> None: ...
	def ReadProps(self, ent: IGESData_IGESEntity, IR: IGESData_IGESReaderData, PR: IGESData_ParamReader) -> None: ...
	def Recognize(self, num: int, ach: Interface_Check, ent: Standard_Transient) -> bool: ...

class IGESData_IGESType:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, atype: int, aform: int) -> None: ...
	def Form(self) -> int: ...
	def IsEqual(self, another: IGESData_IGESType) -> bool: ...
	def Nullify(self) -> None: ...
	def Type(self) -> int: ...

class IGESData_IGESWriter:
	@overload
	def __init__(self, amodel: IGESData_IGESModel) -> None: ...
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, other: IGESData_IGESWriter) -> None: ...
	def Associativities(self, anent: IGESData_IGESEntity) -> None: ...
	def DirPart(self, anent: IGESData_IGESEntity) -> None: ...
	def EndEntity(self) -> None: ...
	def FloatWriter(self) -> Interface_FloatWriter: ...
	def OwnParams(self, anent: IGESData_IGESEntity) -> None: ...
	def Properties(self, anent: IGESData_IGESEntity) -> None: ...
	def SectionG(self, header: IGESData_GlobalSection) -> None: ...
	def SectionS(self) -> None: ...
	def SectionStrings(self, numsec: int) -> TColStd_HSequenceOfHAsciiString: ...
	def SectionT(self) -> None: ...
	def SectionsDP(self) -> None: ...
	def SendBoolean(self, val: bool) -> None: ...
	def SendModel(self, protocol: IGESData_Protocol) -> None: ...
	def SendStartLine(self, startline: str) -> None: ...
	def SendString(self, val: TCollection_HAsciiString) -> None: ...
	def SendVoid(self) -> None: ...
	def GetWriteMode(self) -> int: ...
	def SetWriteMode(self, value: int) -> None: ...

class IGESData_NodeOfSpecificLib(Standard_Transient):
	def __init__(self) -> None: ...
	def AddNode(self, anode: IGESData_GlobalNodeOfSpecificLib) -> None: ...
	def Module(self) -> IGESData_SpecificModule: ...
	def Next(self) -> IGESData_NodeOfSpecificLib: ...
	def Protocol(self) -> IGESData_Protocol: ...

class IGESData_NodeOfWriterLib(Standard_Transient):
	def __init__(self) -> None: ...
	def AddNode(self, anode: IGESData_GlobalNodeOfWriterLib) -> None: ...
	def Module(self) -> IGESData_ReadWriteModule: ...
	def Next(self) -> IGESData_NodeOfWriterLib: ...
	def Protocol(self) -> IGESData_Protocol: ...

class IGESData_ParamCursor:
	@overload
	def __init__(self, num: int) -> None: ...
	@overload
	def __init__(self, num: int, nb: int, size: Optional[int] = 1) -> None: ...
	def Advance(self) -> bool: ...
	def Count(self) -> int: ...
	def ItemSize(self) -> int: ...
	def Limit(self) -> int: ...
	def Offset(self) -> int: ...
	def SetAdvance(self, advance: bool) -> None: ...
	def SetOne(self, autoadv: Optional[bool] = True) -> None: ...
	def SetTerm(self, size: int, autoadv: Optional[bool] = True) -> None: ...
	def SetXY(self, autoadv: Optional[bool] = True) -> None: ...
	def SetXYZ(self, autoadv: Optional[bool] = True) -> None: ...
	def Start(self) -> int: ...
	def TermSize(self) -> int: ...

class IGESData_ParamReader:
	def __init__(self, list: Interface_ParamList, ach: Interface_Check, base: Optional[int] = 1, nbpar: Optional[int] = 0, num: Optional[int] = 0) -> None: ...
	@overload
	def AddFail(self, afail: str, bfail: Optional[str] = "") -> None: ...
	@overload
	def AddFail(self, af: TCollection_HAsciiString, bf: TCollection_HAsciiString) -> None: ...
	@overload
	def AddWarning(self, awarn: str, bwarn: Optional[str] = "") -> None: ...
	@overload
	def AddWarning(self, aw: TCollection_HAsciiString, bw: TCollection_HAsciiString) -> None: ...
	def CCheck(self) -> Interface_Check: ...
	def Check(self) -> Interface_Check: ...
	def Clear(self) -> None: ...
	def Current(self) -> IGESData_ParamCursor: ...
	def CurrentList(self, nb: int, size: Optional[int] = 1) -> IGESData_ParamCursor: ...
	def CurrentNumber(self) -> int: ...
	def DefinedElseSkip(self) -> bool: ...
	def EndAll(self) -> None: ...
	def EntityNumber(self) -> int: ...
	def HasFailed(self) -> bool: ...
	def IsCheckEmpty(self) -> bool: ...
	def IsParamDefined(self, num: int) -> bool: ...
	def IsParamEntity(self, num: int) -> bool: ...
	def Mend(self, pref: Optional[str] = "") -> None: ...
	def NbParams(self) -> int: ...
	def NextStage(self) -> None: ...
	def ParamEntity(self, IR: IGESData_IGESReaderData, num: int) -> IGESData_IGESEntity: ...
	def ParamNumber(self, num: int) -> int: ...
	def ParamType(self, num: int) -> Interface_ParamType: ...
	def ParamValue(self, num: int) -> str: ...
	@overload
	def ReadBoolean(self, PC: IGESData_ParamCursor, amsg: Message_Msg, exact: Optional[bool] = True) -> Tuple[bool, bool]: ...
	@overload
	def ReadBoolean(self, PC: IGESData_ParamCursor, mess: str, exact: Optional[bool] = True) -> Tuple[bool, bool]: ...
	@overload
	def ReadEntList(self, IR: IGESData_IGESReaderData, PC: IGESData_ParamCursor, amsg: Message_Msg, val: Interface_EntityList, ord: Optional[bool] = True) -> bool: ...
	@overload
	def ReadEntList(self, IR: IGESData_IGESReaderData, PC: IGESData_ParamCursor, mess: str, val: Interface_EntityList, ord: Optional[bool] = True) -> bool: ...
	@overload
	def ReadEnts(self, IR: IGESData_IGESReaderData, PC: IGESData_ParamCursor, amsg: Message_Msg, val: IGESData_HArray1OfIGESEntity, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadEnts(self, IR: IGESData_IGESReaderData, PC: IGESData_ParamCursor, mess: str, val: IGESData_HArray1OfIGESEntity, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadInteger(self, PC: IGESData_ParamCursor) -> Tuple[bool, int]: ...
	@overload
	def ReadInteger(self, PC: IGESData_ParamCursor, mess: str) -> Tuple[bool, int]: ...
	@overload
	def ReadInts(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: TColStd_HArray1OfInteger, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadInts(self, PC: IGESData_ParamCursor, mess: str, val: TColStd_HArray1OfInteger, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadReal(self, PC: IGESData_ParamCursor) -> Tuple[bool, float]: ...
	@overload
	def ReadReal(self, PC: IGESData_ParamCursor, mess: str) -> Tuple[bool, float]: ...
	@overload
	def ReadReals(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: TColStd_HArray1OfReal, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadReals(self, PC: IGESData_ParamCursor, mess: str, val: TColStd_HArray1OfReal, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadText(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: TCollection_HAsciiString) -> bool: ...
	@overload
	def ReadText(self, PC: IGESData_ParamCursor, mess: str, val: TCollection_HAsciiString) -> bool: ...
	@overload
	def ReadTexts(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: Interface_HArray1OfHAsciiString, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadTexts(self, PC: IGESData_ParamCursor, mess: str, val: Interface_HArray1OfHAsciiString, index: Optional[int] = 1) -> bool: ...
	@overload
	def ReadXY(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: gp_XY) -> bool: ...
	@overload
	def ReadXY(self, PC: IGESData_ParamCursor, mess: str, val: gp_XY) -> bool: ...
	@overload
	def ReadXYZ(self, PC: IGESData_ParamCursor, amsg: Message_Msg, val: gp_XYZ) -> bool: ...
	@overload
	def ReadXYZ(self, PC: IGESData_ParamCursor, mess: str, val: gp_XYZ) -> bool: ...
	@overload
	def ReadingEntityNumber(self, num: int) -> Tuple[bool, int]: ...
	@overload
	def ReadingEntityNumber(self, num: int, mess: str) -> Tuple[bool, int]: ...
	@overload
	def ReadingReal(self, num: int) -> Tuple[bool, float]: ...
	@overload
	def ReadingReal(self, num: int, mess: str) -> Tuple[bool, float]: ...
	def SendFail(self, amsg: Message_Msg) -> None: ...
	def SendWarning(self, amsg: Message_Msg) -> None: ...
	def SetCurrentNumber(self, num: int) -> None: ...
	def Stage(self) -> IGESData_ReadStage: ...

class IGESData_Protocol(Interface_Protocol):
	def __init__(self) -> None: ...
	def IsSuitableModel(self, model: Interface_InterfaceModel) -> bool: ...
	def IsUnknownEntity(self, ent: Standard_Transient) -> bool: ...
	def NbResources(self) -> int: ...
	def NewModel(self) -> Interface_InterfaceModel: ...
	def Resource(self, num: int) -> Interface_Protocol: ...
	def TypeNumber(self, atype: Standard_Type) -> int: ...
	def UnknownEntity(self) -> Standard_Transient: ...

class IGESData_ReadWriteModule(Interface_ReaderModule):
	def CaseIGES(self, typenum: int, formnum: int) -> int: ...
	def CaseNum(self, data: Interface_FileReaderData, num: int) -> int: ...
	def Read(self, CN: int, data: Interface_FileReaderData, num: int, ach: Interface_Check, ent: Standard_Transient) -> None: ...
	def ReadOwnParams(self, CN: int, ent: IGESData_IGESEntity, IR: IGESData_IGESReaderData, PR: IGESData_ParamReader) -> None: ...
	def WriteOwnParams(self, CN: int, ent: IGESData_IGESEntity, IW: IGESData_IGESWriter) -> None: ...

class IGESData_SpecificLib:
	@overload
	def __init__(self, aprotocol: IGESData_Protocol) -> None: ...
	@overload
	def __init__(self) -> None: ...
	def AddProtocol(self, aprotocol: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Module(self) -> IGESData_SpecificModule: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Protocol(self) -> IGESData_Protocol: ...
	def Select(self, obj: IGESData_IGESEntity, module: IGESData_SpecificModule) -> Tuple[bool, int]: ...
	def SetComplete(self) -> None: ...
	@staticmethod
	def SetGlobal(amodule: IGESData_SpecificModule, aprotocol: IGESData_Protocol) -> None: ...
	def Start(self) -> None: ...

class IGESData_SpecificModule(Standard_Transient):
	def OwnCorrect(self, CN: int, ent: IGESData_IGESEntity) -> bool: ...

class IGESData_ToolLocation(Standard_Transient):
	def __init__(self, amodel: IGESData_IGESModel, protocol: IGESData_Protocol) -> None: ...
	def AnalyseLocation(self, loc: gp_GTrsf, result: gp_Trsf) -> bool: ...
	@staticmethod
	def ConvertLocation(prec: float, loc: gp_GTrsf, result: gp_Trsf, uni: Optional[float] = 1) -> bool: ...
	def EffectiveLocation(self, ent: IGESData_IGESEntity) -> gp_GTrsf: ...
	def ExplicitLocation(self, ent: IGESData_IGESEntity) -> gp_GTrsf: ...
	def HasParent(self, ent: IGESData_IGESEntity) -> bool: ...
	def HasParentByAssociativity(self, ent: IGESData_IGESEntity) -> bool: ...
	def HasTransf(self, ent: IGESData_IGESEntity) -> bool: ...
	def IsAmbiguous(self, ent: IGESData_IGESEntity) -> bool: ...
	def IsAssociativity(self, ent: IGESData_IGESEntity) -> bool: ...
	def IsTransf(self, ent: IGESData_IGESEntity) -> bool: ...
	def Load(self) -> None: ...
	def Parent(self, ent: IGESData_IGESEntity) -> IGESData_IGESEntity: ...
	def ParentLocation(self, ent: IGESData_IGESEntity) -> gp_GTrsf: ...
	def ResetDependences(self, child: IGESData_IGESEntity) -> None: ...
	def SetOwnAsDependent(self, ent: IGESData_IGESEntity) -> None: ...
	def SetParentAssoc(self, parent: IGESData_IGESEntity, child: IGESData_IGESEntity) -> None: ...
	def SetPrecision(self, prec: float) -> None: ...
	def SetReference(self, parent: IGESData_IGESEntity, child: IGESData_IGESEntity) -> None: ...

class IGESData_WriterLib:
	@overload
	def __init__(self, aprotocol: IGESData_Protocol) -> None: ...
	@overload
	def __init__(self) -> None: ...
	def AddProtocol(self, aprotocol: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Module(self) -> IGESData_ReadWriteModule: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Protocol(self) -> IGESData_Protocol: ...
	def Select(self, obj: IGESData_IGESEntity, module: IGESData_ReadWriteModule) -> Tuple[bool, int]: ...
	def SetComplete(self) -> None: ...
	@staticmethod
	def SetGlobal(amodule: IGESData_ReadWriteModule, aprotocol: IGESData_Protocol) -> None: ...
	def Start(self) -> None: ...

class IGESData_ColorEntity(IGESData_IGESEntity):
	pass

class IGESData_DefaultGeneral(IGESData_GeneralModule):
	def __init__(self) -> None: ...
	def DirChecker(self, CN: int, ent: IGESData_IGESEntity) -> IGESData_DirChecker: ...
	def NewVoid(self, CN: int, entto: Standard_Transient) -> bool: ...
	def OwnCheckCase(self, CN: int, ent: IGESData_IGESEntity, shares: Interface_ShareTool, ach: Interface_Check) -> None: ...
	def OwnCopyCase(self, CN: int, entfrom: IGESData_IGESEntity, entto: IGESData_IGESEntity, TC: Interface_CopyTool) -> None: ...
	def OwnSharedCase(self, CN: int, ent: IGESData_IGESEntity, iter: Interface_EntityIterator) -> None: ...

class IGESData_DefaultSpecific(IGESData_SpecificModule):
	def __init__(self) -> None: ...

class IGESData_FileProtocol(IGESData_Protocol):
	def __init__(self) -> None: ...
	def Add(self, protocol: IGESData_Protocol) -> None: ...
	def NbResources(self) -> int: ...
	def Resource(self, num: int) -> Interface_Protocol: ...

class IGESData_LabelDisplayEntity(IGESData_IGESEntity):
	pass

class IGESData_LevelListEntity(IGESData_IGESEntity):
	def HasLevelNumber(self, level: int) -> bool: ...
	def LevelNumber(self, num: int) -> int: ...
	def NbLevelNumbers(self) -> int: ...

class IGESData_LineFontEntity(IGESData_IGESEntity):
	pass

class IGESData_NameEntity(IGESData_IGESEntity):
	def Value(self) -> TCollection_HAsciiString: ...

class IGESData_SingleParentEntity(IGESData_IGESEntity):
	def Child(self, num: int) -> IGESData_IGESEntity: ...
	def NbChildren(self) -> int: ...
	def SingleParent(self) -> IGESData_IGESEntity: ...

class IGESData_TransfEntity(IGESData_IGESEntity):
	def Value(self) -> gp_GTrsf: ...

class IGESData_UndefinedEntity(IGESData_IGESEntity):
	def __init__(self) -> None: ...
	def ChangeableContent(self) -> Interface_UndefinedContent: ...
	def DefColor(self) -> IGESData_DefType: ...
	def DefLevel(self) -> IGESData_DefList: ...
	def DefLineFont(self) -> IGESData_DefType: ...
	def DefView(self) -> IGESData_DefList: ...
	def DirStatus(self) -> int: ...
	def HasSubScriptNumber(self) -> bool: ...
	def IsOKDirPart(self) -> bool: ...
	def ReadDir(self, IR: IGESData_IGESReaderData, DP: IGESData_DirPart, ach: Interface_Check) -> bool: ...
	def ReadOwnParams(self, IR: IGESData_IGESReaderData, PR: IGESData_ParamReader) -> None: ...
	def SetNewContent(self, cont: Interface_UndefinedContent) -> None: ...
	def SetOKDirPart(self) -> None: ...
	def UndefinedContent(self) -> Interface_UndefinedContent: ...
	def WriteOwnParams(self, IW: IGESData_IGESWriter) -> None: ...

class IGESData_ViewKindEntity(IGESData_IGESEntity):
	def IsSingle(self) -> bool: ...
	def NbViews(self) -> int: ...
	def ViewItem(self, num: int) -> IGESData_ViewKindEntity: ...

class IGESData_FreeFormatEntity(IGESData_UndefinedEntity):
	def __init__(self) -> None: ...
	def AddEntities(self, ents: IGESData_HArray1OfIGESEntity) -> None: ...
	def AddEntity(self, ptype: Interface_ParamType, ent: IGESData_IGESEntity, negative: Optional[bool] = False) -> None: ...
	@overload
	def AddLiteral(self, ptype: Interface_ParamType, val: TCollection_HAsciiString) -> None: ...
	@overload
	def AddLiteral(self, ptype: Interface_ParamType, val: str) -> None: ...
	def AddNegativePointers(self, list: TColStd_HSequenceOfInteger) -> None: ...
	def ClearNegativePointers(self) -> None: ...
	def IsNegativePointer(self, num: int) -> bool: ...
	def IsParamEntity(self, num: int) -> bool: ...
	def NbParams(self) -> int: ...
	def NegativePointers(self) -> TColStd_HSequenceOfInteger: ...
	def ParamData(self, num: int, ptype: Interface_ParamType, ent: IGESData_IGESEntity, val: TCollection_HAsciiString) -> bool: ...
	def ParamEntity(self, num: int) -> IGESData_IGESEntity: ...
	def ParamType(self, num: int) -> Interface_ParamType: ...
	def ParamValue(self, num: int) -> TCollection_HAsciiString: ...
	def SetFormNumber(self, formnum: int) -> None: ...
	def SetTypeNumber(self, typenum: int) -> None: ...
	def WriteOwnParams(self, IW: IGESData_IGESWriter) -> None: ...

# harray1 classes

class IGESData_HArray1OfIGESEntity(IGESData_Array1OfIGESEntity, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> IGESData_Array1OfIGESEntity: ...

# harray2 classes
# hsequence classes

igesdata_Init = igesdata.Init
igesdata_Protocol = igesdata.Protocol
IGESData_BasicEditor_DraftingMax = IGESData_BasicEditor.DraftingMax
IGESData_BasicEditor_DraftingName = IGESData_BasicEditor.DraftingName
IGESData_BasicEditor_IGESVersionMax = IGESData_BasicEditor.IGESVersionMax
IGESData_BasicEditor_IGESVersionName = IGESData_BasicEditor.IGESVersionName
IGESData_BasicEditor_UnitFlagName = IGESData_BasicEditor.UnitFlagName
IGESData_BasicEditor_UnitFlagValue = IGESData_BasicEditor.UnitFlagValue
IGESData_BasicEditor_UnitNameFlag = IGESData_BasicEditor.UnitNameFlag
IGESData_GlobalSection_NewDateString = IGESData_GlobalSection.NewDateString
IGESData_GlobalSection_NewDateString = IGESData_GlobalSection.NewDateString
IGESData_SpecificLib_SetGlobal = IGESData_SpecificLib.SetGlobal
IGESData_ToolLocation_ConvertLocation = IGESData_ToolLocation.ConvertLocation
IGESData_WriterLib_SetGlobal = IGESData_WriterLib.SetGlobal
