from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Intf import *
from OCC.Core.Adaptor3d import *
from OCC.Core.math import *
from OCC.Core.Adaptor2d import *
from OCC.Core.gp import *
from OCC.Core.IntSurf import *
from OCC.Core.Geom2d import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *
from OCC.Core.Bnd import *
from OCC.Core.IntAna import *

IntPatch_SearchPnt = NewType('IntPatch_SearchPnt', Intf_InterferencePolygon2d)

class IntPatch_SequenceOfIWLineOfTheIWalking:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IntPatch_SequenceOfLine:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IntPatch_SequenceOfPathPointOfTheSOnBounds:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> IntPatch_ThePathPointOfTheSOnBounds: ...
    def Last(self) -> IntPatch_ThePathPointOfTheSOnBounds: ...
    def Length(self) -> int: ...
    def Append(self, theItem: IntPatch_ThePathPointOfTheSOnBounds) -> IntPatch_ThePathPointOfTheSOnBounds: ...
    def Prepend(self, theItem: IntPatch_ThePathPointOfTheSOnBounds) -> IntPatch_ThePathPointOfTheSOnBounds: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> IntPatch_ThePathPointOfTheSOnBounds: ...
    def SetValue(self, theIndex: int, theValue: IntPatch_ThePathPointOfTheSOnBounds) -> None: ...

class IntPatch_SequenceOfPoint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> IntPatch_Point: ...
    def Last(self) -> IntPatch_Point: ...
    def Length(self) -> int: ...
    def Append(self, theItem: IntPatch_Point) -> IntPatch_Point: ...
    def Prepend(self, theItem: IntPatch_Point) -> IntPatch_Point: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> IntPatch_Point: ...
    def SetValue(self, theIndex: int, theValue: IntPatch_Point) -> None: ...

class IntPatch_SequenceOfSegmentOfTheSOnBounds:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> IntPatch_TheSegmentOfTheSOnBounds: ...
    def Last(self) -> IntPatch_TheSegmentOfTheSOnBounds: ...
    def Length(self) -> int: ...
    def Append(self, theItem: IntPatch_TheSegmentOfTheSOnBounds) -> IntPatch_TheSegmentOfTheSOnBounds: ...
    def Prepend(self, theItem: IntPatch_TheSegmentOfTheSOnBounds) -> IntPatch_TheSegmentOfTheSOnBounds: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> IntPatch_TheSegmentOfTheSOnBounds: ...
    def SetValue(self, theIndex: int, theValue: IntPatch_TheSegmentOfTheSOnBounds) -> None: ...

class IntPatch_SpecPntType(IntEnum):
	IntPatch_SPntNone: int = ...
	IntPatch_SPntSeamU: int = ...
	IntPatch_SPntSeamV: int = ...
	IntPatch_SPntSeamUV: int = ...
	IntPatch_SPntPoleSeamU: int = ...
	IntPatch_SPntPole: int = ...
IntPatch_SPntNone = IntPatch_SpecPntType.IntPatch_SPntNone
IntPatch_SPntSeamU = IntPatch_SpecPntType.IntPatch_SPntSeamU
IntPatch_SPntSeamV = IntPatch_SpecPntType.IntPatch_SPntSeamV
IntPatch_SPntSeamUV = IntPatch_SpecPntType.IntPatch_SPntSeamUV
IntPatch_SPntPoleSeamU = IntPatch_SpecPntType.IntPatch_SPntPoleSeamU
IntPatch_SPntPole = IntPatch_SpecPntType.IntPatch_SPntPole

class IntPatch_IType(IntEnum):
	IntPatch_Lin: int = ...
	IntPatch_Circle: int = ...
	IntPatch_Ellipse: int = ...
	IntPatch_Parabola: int = ...
	IntPatch_Hyperbola: int = ...
	IntPatch_Analytic: int = ...
	IntPatch_Walking: int = ...
	IntPatch_Restriction: int = ...
IntPatch_Lin = IntPatch_IType.IntPatch_Lin
IntPatch_Circle = IntPatch_IType.IntPatch_Circle
IntPatch_Ellipse = IntPatch_IType.IntPatch_Ellipse
IntPatch_Parabola = IntPatch_IType.IntPatch_Parabola
IntPatch_Hyperbola = IntPatch_IType.IntPatch_Hyperbola
IntPatch_Analytic = IntPatch_IType.IntPatch_Analytic
IntPatch_Walking = IntPatch_IType.IntPatch_Walking
IntPatch_Restriction = IntPatch_IType.IntPatch_Restriction

class IntPatch_ALineToWLine:
	def __init__(self, theS1: Adaptor3d_HSurface, theS2: Adaptor3d_HSurface, theNbPoints: Optional[int] = 200) -> None: ...
	@overload
	def MakeWLine(self, aline: IntPatch_ALine, theLines: IntPatch_SequenceOfLine) -> None: ...
	@overload
	def MakeWLine(self, aline: IntPatch_ALine, paraminf: float, paramsup: float, theLines: IntPatch_SequenceOfLine) -> None: ...
	def SetTol3D(self, aT: float) -> None: ...
	def SetTolOpenDomain(self, aT: float) -> None: ...
	def SetTolTransition(self, aT: float) -> None: ...
	def Tol3D(self) -> float: ...
	def TolOpenDomain(self) -> float: ...
	def TolTransition(self) -> float: ...

class IntPatch_ArcFunction(math_FunctionWithDerivative):
	def __init__(self) -> None: ...
	def Arc(self) -> Adaptor2d_HCurve2d: ...
	def Derivative(self, X: float) -> Tuple[bool, float]: ...
	def GetStateNumber(self) -> int: ...
	def LastComputedPoint(self) -> gp_Pnt: ...
	def NbSamples(self) -> int: ...
	def Quadric(self) -> IntSurf_Quadric: ...
	@overload
	def Set(self, A: Adaptor2d_HCurve2d) -> None: ...
	@overload
	def Set(self, S: Adaptor3d_HSurface) -> None: ...
	def SetQuadric(self, Q: IntSurf_Quadric) -> None: ...
	def Surface(self) -> Adaptor3d_HSurface: ...
	def Valpoint(self, Index: int) -> gp_Pnt: ...
	def Value(self, X: float) -> Tuple[bool, float]: ...
	def Values(self, X: float) -> Tuple[bool, float, float]: ...

class IntPatch_CSFunction(math_FunctionSetWithDerivatives):
	def __init__(self, S1: Adaptor3d_HSurface, C: Adaptor2d_HCurve2d, S2: Adaptor3d_HSurface) -> None: ...
	def AuxillarCurve(self) -> Adaptor2d_HCurve2d: ...
	def AuxillarSurface(self) -> Adaptor3d_HSurface: ...
	def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
	def NbEquations(self) -> int: ...
	def NbVariables(self) -> int: ...
	def Point(self) -> gp_Pnt: ...
	def Root(self) -> float: ...
	def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
	def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class IntPatch_CurvIntSurf:
	@overload
	def __init__(self, U: float, V: float, W: float, F: IntPatch_CSFunction, TolTangency: float, MarginCoef: Optional[float] = 0.0) -> None: ...
	@overload
	def __init__(self, F: IntPatch_CSFunction, TolTangency: float) -> None: ...
	def Function(self) -> IntPatch_CSFunction: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def ParameterOnCurve(self) -> float: ...
	def ParameterOnSurface(self) -> Tuple[float, float]: ...
	def Perform(self, U: float, V: float, W: float, Rsnld: math_FunctionSetRoot, u0: float, v0: float, u1: float, v1: float, w0: float, w1: float) -> None: ...
	def Point(self) -> gp_Pnt: ...

class IntPatch_HCurve2dTool:
	@staticmethod
	def BSpline(C: Adaptor2d_HCurve2d) -> Geom2d_BSplineCurve: ...
	@staticmethod
	def Bezier(C: Adaptor2d_HCurve2d) -> Geom2d_BezierCurve: ...
	@staticmethod
	def Circle(C: Adaptor2d_HCurve2d) -> gp_Circ2d: ...
	@staticmethod
	def Continuity(C: Adaptor2d_HCurve2d) -> GeomAbs_Shape: ...
	@staticmethod
	def D0(C: Adaptor2d_HCurve2d, U: float, P: gp_Pnt2d) -> None: ...
	@staticmethod
	def D1(C: Adaptor2d_HCurve2d, U: float, P: gp_Pnt2d, V: gp_Vec2d) -> None: ...
	@staticmethod
	def D2(C: Adaptor2d_HCurve2d, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	@staticmethod
	def D3(C: Adaptor2d_HCurve2d, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	@staticmethod
	def DN(C: Adaptor2d_HCurve2d, U: float, N: int) -> gp_Vec2d: ...
	@staticmethod
	def Ellipse(C: Adaptor2d_HCurve2d) -> gp_Elips2d: ...
	@staticmethod
	def FirstParameter(C: Adaptor2d_HCurve2d) -> float: ...
	@staticmethod
	def GetType(C: Adaptor2d_HCurve2d) -> GeomAbs_CurveType: ...
	@staticmethod
	def Hyperbola(C: Adaptor2d_HCurve2d) -> gp_Hypr2d: ...
	@staticmethod
	def Intervals(C: Adaptor2d_HCurve2d, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
	@staticmethod
	def IsClosed(C: Adaptor2d_HCurve2d) -> bool: ...
	@staticmethod
	def IsPeriodic(C: Adaptor2d_HCurve2d) -> bool: ...
	@staticmethod
	def LastParameter(C: Adaptor2d_HCurve2d) -> float: ...
	@staticmethod
	def Line(C: Adaptor2d_HCurve2d) -> gp_Lin2d: ...
	@staticmethod
	def NbIntervals(C: Adaptor2d_HCurve2d, S: GeomAbs_Shape) -> int: ...
	@staticmethod
	def NbSamples(C: Adaptor2d_HCurve2d, U0: float, U1: float) -> int: ...
	@staticmethod
	def Parabola(C: Adaptor2d_HCurve2d) -> gp_Parab2d: ...
	@staticmethod
	def Period(C: Adaptor2d_HCurve2d) -> float: ...
	@staticmethod
	def Resolution(C: Adaptor2d_HCurve2d, R3d: float) -> float: ...
	@staticmethod
	def Value(C: Adaptor2d_HCurve2d, U: float) -> gp_Pnt2d: ...

class IntPatch_HInterTool:
	def __init__(self) -> None: ...
	@staticmethod
	def Bounds(C: Adaptor2d_HCurve2d) -> Tuple[float, float]: ...
	@staticmethod
	def HasBeenSeen(C: Adaptor2d_HCurve2d) -> bool: ...
	@staticmethod
	def HasFirstPoint(C: Adaptor2d_HCurve2d, Index: int) -> Tuple[bool, int]: ...
	@staticmethod
	def HasLastPoint(C: Adaptor2d_HCurve2d, Index: int) -> Tuple[bool, int]: ...
	@staticmethod
	def IsAllSolution(C: Adaptor2d_HCurve2d) -> bool: ...
	@staticmethod
	def IsVertex(C: Adaptor2d_HCurve2d, Index: int) -> bool: ...
	@staticmethod
	def NbPoints(C: Adaptor2d_HCurve2d) -> int: ...
	def NbSamplePoints(self, S: Adaptor3d_HSurface) -> int: ...
	@staticmethod
	def NbSamplesOnArc(A: Adaptor2d_HCurve2d) -> int: ...
	@staticmethod
	def NbSamplesU(S: Adaptor3d_HSurface, u1: float, u2: float) -> int: ...
	@staticmethod
	def NbSamplesV(S: Adaptor3d_HSurface, v1: float, v2: float) -> int: ...
	@staticmethod
	def NbSegments(C: Adaptor2d_HCurve2d) -> int: ...
	@staticmethod
	def Parameter(V: Adaptor3d_HVertex, C: Adaptor2d_HCurve2d) -> float: ...
	@staticmethod
	def Project(C: Adaptor2d_HCurve2d, P: gp_Pnt2d, Ptproj: gp_Pnt2d) -> Tuple[bool, float]: ...
	def SamplePoint(self, S: Adaptor3d_HSurface, Index: int) -> Tuple[float, float]: ...
	@staticmethod
	def SingularOnUMax(S: Adaptor3d_HSurface) -> bool: ...
	@staticmethod
	def SingularOnUMin(S: Adaptor3d_HSurface) -> bool: ...
	@staticmethod
	def SingularOnVMax(S: Adaptor3d_HSurface) -> bool: ...
	@staticmethod
	def SingularOnVMin(S: Adaptor3d_HSurface) -> bool: ...
	@staticmethod
	def Tolerance(V: Adaptor3d_HVertex, C: Adaptor2d_HCurve2d) -> float: ...
	@staticmethod
	def Value(C: Adaptor2d_HCurve2d, Index: int, Pt: gp_Pnt) -> Tuple[float, float]: ...
	@staticmethod
	def Vertex(C: Adaptor2d_HCurve2d, Index: int, V: Adaptor3d_HVertex) -> None: ...

class IntPatch_ImpImpIntersection:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, theIsReqToKeepRLine: Optional[bool] = False) -> None: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def Line(self, Index: int) -> IntPatch_Line: ...
	def NbLines(self) -> int: ...
	def NbPnts(self) -> int: ...
	def OppositeFaces(self) -> bool: ...
	def Perform(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, theIsReqToKeepRLine: Optional[bool] = False) -> None: ...
	def Point(self, Index: int) -> IntPatch_Point: ...
	def TangentFaces(self) -> bool: ...

class IntPatch_ImpPrmIntersection:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Surf1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, Surf2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, Fleche: float, Pas: float) -> None: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def Line(self, Index: int) -> IntPatch_Line: ...
	def NbLines(self) -> int: ...
	def NbPnts(self) -> int: ...
	def Perform(self, Surf1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, Surf2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, Fleche: float, Pas: float) -> None: ...
	def Point(self, Index: int) -> IntPatch_Point: ...
	def SetStartPoint(self, U: float, V: float) -> None: ...

class IntPatch_InterferencePolyhedron(Intf_Interference):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Obje1: IntPatch_Polyhedron, Obje2: IntPatch_Polyhedron) -> None: ...
	@overload
	def __init__(self, Obje: IntPatch_Polyhedron) -> None: ...
	@overload
	def Perform(self, Obje1: IntPatch_Polyhedron, Obje2: IntPatch_Polyhedron) -> None: ...
	@overload
	def Perform(self, Obje: IntPatch_Polyhedron) -> None: ...

class IntPatch_Intersection:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float) -> None: ...
	@overload
	def __init__(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, TolArc: float, TolTang: float) -> None: ...
	def Dump(self, Mode: int, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool) -> None: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def Line(self, Index: int) -> IntPatch_Line: ...
	def NbLines(self) -> int: ...
	def NbPnts(self) -> int: ...
	def OppositeFaces(self) -> bool: ...
	@overload
	def Perform(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, isGeomInt: Optional[bool] = True, theIsReqToKeepRLine: Optional[bool] = False, theIsReqToPostWLProc: Optional[bool] = True) -> None: ...
	@overload
	def Perform(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, TolArc: float, TolTang: float, LOfPnts: IntSurf_ListOfPntOn2S, isGeomInt: Optional[bool] = True, theIsReqToKeepRLine: Optional[bool] = False, theIsReqToPostWLProc: Optional[bool] = True) -> None: ...
	@overload
	def Perform(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, U1: float, V1: float, U2: float, V2: float, TolArc: float, TolTang: float) -> None: ...
	@overload
	def Perform(self, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, TolArc: float, TolTang: float) -> None: ...
	def Point(self, Index: int) -> IntPatch_Point: ...
	def SequenceOfLine(self) -> IntPatch_SequenceOfLine: ...
	def SetTolerances(self, TolArc: float, TolTang: float, UVMaxStep: float, Fleche: float) -> None: ...
	def TangentFaces(self) -> bool: ...

class IntPatch_Line(Standard_Transient):
	def ArcType(self) -> IntPatch_IType: ...
	def IsTangent(self) -> bool: ...
	def IsUIsoOnS1(self) -> bool: ...
	def IsUIsoOnS2(self) -> bool: ...
	def IsVIsoOnS1(self) -> bool: ...
	def IsVIsoOnS2(self) -> bool: ...
	def SetValue(self, Uiso1: bool, Viso1: bool, Uiso2: bool, Viso2: bool) -> None: ...
	def SituationS1(self) -> IntSurf_Situation: ...
	def SituationS2(self) -> IntSurf_Situation: ...
	def TransitionOnS1(self) -> IntSurf_TypeTrans: ...
	def TransitionOnS2(self) -> IntSurf_TypeTrans: ...

class IntPatch_LineConstructor:
	def __init__(self, mode: int) -> None: ...
	def Line(self, index: int) -> IntPatch_Line: ...
	def NbLines(self) -> int: ...
	def Perform(self, SL: IntPatch_SequenceOfLine, L: IntPatch_Line, S1: Adaptor3d_HSurface, D1: Adaptor3d_TopolTool, S2: Adaptor3d_HSurface, D2: Adaptor3d_TopolTool, Tol: float) -> None: ...

class IntPatch_Point:
	def __init__(self) -> None: ...
	def ArcOnS1(self) -> Adaptor2d_HCurve2d: ...
	def ArcOnS2(self) -> Adaptor2d_HCurve2d: ...
	def Dump(self) -> None: ...
	def IsMultiple(self) -> bool: ...
	def IsOnDomS1(self) -> bool: ...
	def IsOnDomS2(self) -> bool: ...
	def IsTangencyPoint(self) -> bool: ...
	def IsVertexOnS1(self) -> bool: ...
	def IsVertexOnS2(self) -> bool: ...
	def ParameterOnArc1(self) -> float: ...
	def ParameterOnArc2(self) -> float: ...
	def ParameterOnLine(self) -> float: ...
	def Parameters(self) -> Tuple[float, float, float, float]: ...
	def ParametersOnS1(self) -> Tuple[float, float]: ...
	def ParametersOnS2(self) -> Tuple[float, float]: ...
	def PntOn2S(self) -> IntSurf_PntOn2S: ...
	def ReverseTransition(self) -> None: ...
	def SetArc(self, OnFirst: bool, A: Adaptor2d_HCurve2d, Param: float, TLine: IntSurf_Transition, TArc: IntSurf_Transition) -> None: ...
	def SetMultiple(self, IsMult: bool) -> None: ...
	def SetParameter(self, Para: float) -> None: ...
	def SetParameters(self, U1: float, V1: float, U2: float, V2: float) -> None: ...
	def SetTolerance(self, Tol: float) -> None: ...
	@overload
	def SetValue(self, Pt: gp_Pnt, Tol: float, Tangent: bool) -> None: ...
	@overload
	def SetValue(self, Pt: gp_Pnt) -> None: ...
	@overload
	def SetValue(self, thePOn2S: IntSurf_PntOn2S) -> None: ...
	def SetVertex(self, OnFirst: bool, V: Adaptor3d_HVertex) -> None: ...
	def Tolerance(self) -> float: ...
	def TransitionLineArc1(self) -> IntSurf_Transition: ...
	def TransitionLineArc2(self) -> IntSurf_Transition: ...
	def TransitionOnS1(self) -> IntSurf_Transition: ...
	def TransitionOnS2(self) -> IntSurf_Transition: ...
	def Value(self) -> gp_Pnt: ...
	def VertexOnS1(self) -> Adaptor3d_HVertex: ...
	def VertexOnS2(self) -> Adaptor3d_HVertex: ...

class IntPatch_Polygo(Intf_Polygon2d):
	def DeflectionOverEstimation(self) -> float: ...
	def Dump(self) -> None: ...
	def Error(self) -> float: ...
	def NbPoints(self) -> int: ...
	def NbSegments(self) -> int: ...
	def Point(self, Index: int) -> gp_Pnt2d: ...
	def Segment(self, theIndex: int, theBegin: gp_Pnt2d, theEnd: gp_Pnt2d) -> None: ...

class IntPatch_PolyhedronTool:
	@staticmethod
	def Bounding(thePolyh: IntPatch_Polyhedron) -> Bnd_Box: ...
	@staticmethod
	def ComponentsBounding(thePolyh: IntPatch_Polyhedron) -> Bnd_HArray1OfBox: ...
	@staticmethod
	def DeflectionOverEstimation(thePolyh: IntPatch_Polyhedron) -> float: ...
	@staticmethod
	def NbTriangles(thePolyh: IntPatch_Polyhedron) -> int: ...
	@staticmethod
	def Point(thePolyh: IntPatch_Polyhedron, Index: int) -> gp_Pnt: ...
	@staticmethod
	def TriConnex(thePolyh: IntPatch_Polyhedron, Triang: int, Pivot: int, Pedge: int) -> Tuple[int, int, int]: ...
	@staticmethod
	def Triangle(thePolyh: IntPatch_Polyhedron, Index: int) -> Tuple[int, int, int]: ...

class IntPatch_PrmPrmIntersection:
	def __init__(self) -> None: ...
	def CodeReject(self, x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float) -> int: ...
	def DansGrille(self, t: int) -> int: ...
	def GrilleInteger(self, ix: int, iy: int, iz: int) -> int: ...
	def IntegerGrille(self, t: int) -> Tuple[int, int, int]: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def Line(self, Index: int) -> IntPatch_Line: ...
	def NbLines(self) -> int: ...
	def NbPointsGrille(self) -> int: ...
	def NewLine(self, Caro1: Adaptor3d_HSurface, Caro2: Adaptor3d_HSurface, IndexLine: int, LowPoint: int, HighPoint: int, NbPoints: int) -> IntPatch_Line: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Polyhedron1: IntPatch_Polyhedron, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Polyhedron2: IntPatch_Polyhedron, Domain2: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Polyhedron1: IntPatch_Polyhedron, Domain1: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Domain2: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float, ClearFlag: Optional[bool] = True) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Domain2: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float, ListOfPnts: IntSurf_ListOfPntOn2S) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Domain2: Adaptor3d_TopolTool, U1: float, V1: float, U2: float, V2: float, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Domain1: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Polyhedron2: IntPatch_Polyhedron, Domain2: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	@overload
	def Perform(self, Caro1: Adaptor3d_HSurface, Polyhedron1: IntPatch_Polyhedron, Domain1: Adaptor3d_TopolTool, Caro2: Adaptor3d_HSurface, Domain2: Adaptor3d_TopolTool, TolTangency: float, Epsilon: float, Deflection: float, Increment: float) -> None: ...
	def PointDepart(self, LineOn2S: IntSurf_LineOn2S, S1: Adaptor3d_HSurface, SU1: int, SV1: int, S2: Adaptor3d_HSurface, SU2: int, SV2: int) -> None: ...
	def Remplit(self, a: int, b: int, c: int, Map: IntPatch_PrmPrmIntersection_T3Bits) -> None: ...
	def RemplitLin(self, x1: int, y1: int, z1: int, x2: int, y2: int, z2: int, Map: IntPatch_PrmPrmIntersection_T3Bits) -> None: ...
	def RemplitTri(self, x1: int, y1: int, z1: int, x2: int, y2: int, z2: int, x3: int, y3: int, z3: int, Map: IntPatch_PrmPrmIntersection_T3Bits) -> None: ...

class IntPatch_PrmPrmIntersection_T3Bits:
	def __init__(self, size: int) -> None: ...
	def Add(self, t: int) -> None: ...
	def And(self, Oth: IntPatch_PrmPrmIntersection_T3Bits) -> Tuple[int, int]: ...
	def Destroy(self) -> None: ...
	def Raz(self, t: int) -> None: ...
	def ResetAnd(self) -> None: ...
	def Val(self, t: int) -> int: ...

class IntPatch_RstInt:
	@staticmethod
	def PutVertexOnLine(L: IntPatch_Line, Surf: Adaptor3d_HSurface, Domain: Adaptor3d_TopolTool, OtherSurf: Adaptor3d_HSurface, OnFirst: bool, Tol: float) -> None: ...

class IntPatch_SpecialPoints:
	@staticmethod
	def AddCrossUVIsoPoint(theQSurf: Adaptor3d_HSurface, thePSurf: Adaptor3d_HSurface, theRefPt: IntSurf_PntOn2S, theTol3d: float, theAddedPoint: IntSurf_PntOn2S, theIsReversed: Optional[bool] = False) -> bool: ...
	@staticmethod
	def AddPointOnUorVIso(theQSurf: Adaptor3d_HSurface, thePSurf: Adaptor3d_HSurface, theRefPt: IntSurf_PntOn2S, theIsU: bool, theIsoParameter: float, theToler: math_Vector, theInitPoint: math_Vector, theInfBound: math_Vector, theSupBound: math_Vector, theAddedPoint: IntSurf_PntOn2S, theIsReversed: Optional[bool] = False) -> bool: ...
	@staticmethod
	def AddSingularPole(theQSurf: Adaptor3d_HSurface, thePSurf: Adaptor3d_HSurface, thePtIso: IntSurf_PntOn2S, theVertex: IntPatch_Point, theAddedPoint: IntSurf_PntOn2S, theIsReversed: Optional[bool] = False, theIsReqRefCheck: Optional[bool] = False) -> bool: ...
	@staticmethod
	def AdjustPointAndVertex(theRefPoint: IntSurf_PntOn2S, theArrPeriods_list: List[float], theNewPoint: IntSurf_PntOn2S, theVertex: Optional[IntPatch_Point] = 0) -> None: ...
	@staticmethod
	def ContinueAfterSpecialPoint(theQSurf: Adaptor3d_HSurface, thePSurf: Adaptor3d_HSurface, theRefPt: IntSurf_PntOn2S, theSPType: IntPatch_SpecPntType, theTol2D: float, theNewPoint: IntSurf_PntOn2S, theIsReversed: Optional[bool] = False) -> bool: ...

class IntPatch_TheIWLineOfTheIWalking(Standard_Transient):
	def __init__(self, theAllocator: Optional[IntSurf_Allocator] = 0) -> None: ...
	def AddIndexPassing(self, Index: int) -> None: ...
	def AddPoint(self, P: IntSurf_PntOn2S) -> None: ...
	@overload
	def AddStatusFirst(self, Closed: bool, HasFirst: bool) -> None: ...
	@overload
	def AddStatusFirst(self, Closed: bool, HasLast: bool, Index: int, P: IntSurf_PathPoint) -> None: ...
	def AddStatusFirstLast(self, Closed: bool, HasFirst: bool, HasLast: bool) -> None: ...
	@overload
	def AddStatusLast(self, HasLast: bool) -> None: ...
	@overload
	def AddStatusLast(self, HasLast: bool, Index: int, P: IntSurf_PathPoint) -> None: ...
	def Cut(self, Index: int) -> None: ...
	def FirstPoint(self) -> IntSurf_PathPoint: ...
	def FirstPointIndex(self) -> int: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsTangentAtBegining(self) -> bool: ...
	def IsTangentAtEnd(self) -> bool: ...
	def LastPoint(self) -> IntSurf_PathPoint: ...
	def LastPointIndex(self) -> int: ...
	def Line(self) -> IntSurf_LineOn2S: ...
	def NbPassingPoint(self) -> int: ...
	def NbPoints(self) -> int: ...
	def PassingPoint(self, Index: int) -> Tuple[int, int]: ...
	def Reverse(self) -> None: ...
	def SetTangencyAtBegining(self, IsTangent: bool) -> None: ...
	def SetTangencyAtEnd(self, IsTangent: bool) -> None: ...
	def SetTangentVector(self, V: gp_Vec, Index: int) -> None: ...
	def TangentVector(self) -> Tuple[gp_Vec, int]: ...
	def Value(self, Index: int) -> IntSurf_PntOn2S: ...

class IntPatch_TheIWalking:
	def __init__(self, Epsilon: float, Deflection: float, Step: float, theToFillHoles: Optional[bool] = False) -> None: ...
	def IsDone(self) -> bool: ...
	def NbLines(self) -> int: ...
	def NbSinglePnts(self) -> int: ...
	@overload
	def Perform(self, Pnts1: IntSurf_SequenceOfPathPoint, Pnts2: IntSurf_SequenceOfInteriorPoint, Func: IntPatch_TheSurfFunction, S: Adaptor3d_HSurface, Reversed: Optional[bool] = False) -> None: ...
	@overload
	def Perform(self, Pnts1: IntSurf_SequenceOfPathPoint, Func: IntPatch_TheSurfFunction, S: Adaptor3d_HSurface, Reversed: Optional[bool] = False) -> None: ...
	def SetTolerance(self, Epsilon: float, Deflection: float, Step: float) -> None: ...
	def SinglePnt(self, Index: int) -> IntSurf_PathPoint: ...
	def Value(self, Index: int) -> IntPatch_TheIWLineOfTheIWalking: ...

class IntPatch_ThePathPointOfTheSOnBounds:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, Tol: float, V: Adaptor3d_HVertex, A: Adaptor2d_HCurve2d, Parameter: float) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, Tol: float, A: Adaptor2d_HCurve2d, Parameter: float) -> None: ...
	def Arc(self) -> Adaptor2d_HCurve2d: ...
	def IsNew(self) -> bool: ...
	def Parameter(self) -> float: ...
	@overload
	def SetValue(self, P: gp_Pnt, Tol: float, V: Adaptor3d_HVertex, A: Adaptor2d_HCurve2d, Parameter: float) -> None: ...
	@overload
	def SetValue(self, P: gp_Pnt, Tol: float, A: Adaptor2d_HCurve2d, Parameter: float) -> None: ...
	def Tolerance(self) -> float: ...
	def Value(self) -> gp_Pnt: ...
	def Vertex(self) -> Adaptor3d_HVertex: ...

class IntPatch_TheSOnBounds:
	def __init__(self) -> None: ...
	def AllArcSolution(self) -> bool: ...
	def IsDone(self) -> bool: ...
	def NbPoints(self) -> int: ...
	def NbSegments(self) -> int: ...
	def Perform(self, F: IntPatch_ArcFunction, Domain: Adaptor3d_TopolTool, TolBoundary: float, TolTangency: float, RecheckOnRegularity: Optional[bool] = False) -> None: ...
	def Point(self, Index: int) -> IntPatch_ThePathPointOfTheSOnBounds: ...
	def Segment(self, Index: int) -> IntPatch_TheSegmentOfTheSOnBounds: ...

class IntPatch_TheSearchInside:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, F: IntPatch_TheSurfFunction, Surf: Adaptor3d_HSurface, T: Adaptor3d_TopolTool, Epsilon: float) -> None: ...
	def IsDone(self) -> bool: ...
	def NbPoints(self) -> int: ...
	@overload
	def Perform(self, F: IntPatch_TheSurfFunction, Surf: Adaptor3d_HSurface, T: Adaptor3d_TopolTool, Epsilon: float) -> None: ...
	@overload
	def Perform(self, F: IntPatch_TheSurfFunction, Surf: Adaptor3d_HSurface, UStart: float, VStart: float) -> None: ...
	def Value(self, Index: int) -> IntSurf_InteriorPoint: ...

class IntPatch_TheSegmentOfTheSOnBounds:
	def __init__(self) -> None: ...
	def Curve(self) -> Adaptor2d_HCurve2d: ...
	def FirstPoint(self) -> IntPatch_ThePathPointOfTheSOnBounds: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def LastPoint(self) -> IntPatch_ThePathPointOfTheSOnBounds: ...
	def SetLimitPoint(self, V: IntPatch_ThePathPointOfTheSOnBounds, First: bool) -> None: ...
	def SetValue(self, A: Adaptor2d_HCurve2d) -> None: ...

class IntPatch_TheSurfFunction(math_FunctionSetWithDerivatives):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, PS: Adaptor3d_HSurface, IS: IntSurf_Quadric) -> None: ...
	@overload
	def __init__(self, IS: IntSurf_Quadric) -> None: ...
	def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
	def Direction2d(self) -> gp_Dir2d: ...
	def Direction3d(self) -> gp_Vec: ...
	def ISurface(self) -> IntSurf_Quadric: ...
	def IsTangent(self) -> bool: ...
	def NbEquations(self) -> int: ...
	def NbVariables(self) -> int: ...
	def PSurface(self) -> Adaptor3d_HSurface: ...
	def Point(self) -> gp_Pnt: ...
	def Root(self) -> float: ...
	@overload
	def Set(self, PS: Adaptor3d_HSurface) -> None: ...
	@overload
	def Set(self, Tolerance: float) -> None: ...
	def SetImplicitSurface(self, IS: IntSurf_Quadric) -> None: ...
	def Tolerance(self) -> float: ...
	def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
	def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class IntPatch_WLineTool:
	@staticmethod
	def ComputePurgedWLine(theWLine: IntPatch_WLine, theS1: Adaptor3d_HSurface, theS2: Adaptor3d_HSurface, theDom1: Adaptor3d_TopolTool, theDom2: Adaptor3d_TopolTool) -> IntPatch_WLine: ...
	@staticmethod
	def JoinWLines(theSlin: IntPatch_SequenceOfLine, theSPnt: IntPatch_SequenceOfPoint, theS1: Adaptor3d_HSurface, theS2: Adaptor3d_HSurface, theTol3D: float) -> None: ...

class IntPatch_ALine(IntPatch_Line):
	@overload
	def __init__(self, C: IntAna_Curve, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, C: IntAna_Curve, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, C: IntAna_Curve, Tang: bool) -> None: ...
	def AddVertex(self, Pnt: IntPatch_Point) -> None: ...
	def ChangeVertex(self, theIndex: int) -> IntPatch_Point: ...
	def ComputeVertexParameters(self, Tol: float) -> None: ...
	def Curve(self) -> IntAna_Curve: ...
	def D1(self, U: float, P: gp_Pnt, Du: gp_Vec) -> bool: ...
	def FindParameter(self, P: gp_Pnt, theParams: TColStd_ListOfReal) -> None: ...
	def FirstParameter(self) -> Tuple[float, bool]: ...
	def FirstPoint(self) -> IntPatch_Point: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def LastParameter(self) -> Tuple[float, bool]: ...
	def LastPoint(self) -> IntPatch_Point: ...
	def NbVertex(self) -> int: ...
	def Replace(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def SetFirstPoint(self, IndFirst: int) -> None: ...
	def SetLastPoint(self, IndLast: int) -> None: ...
	def Value(self, U: float) -> gp_Pnt: ...
	def Vertex(self, Index: int) -> IntPatch_Point: ...

class IntPatch_GLine(IntPatch_Line):
	@overload
	def __init__(self, L: gp_Lin, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, L: gp_Lin, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, L: gp_Lin, Tang: bool) -> None: ...
	@overload
	def __init__(self, C: gp_Circ, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, C: gp_Circ, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, C: gp_Circ, Tang: bool) -> None: ...
	@overload
	def __init__(self, E: gp_Elips, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, E: gp_Elips, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, E: gp_Elips, Tang: bool) -> None: ...
	@overload
	def __init__(self, P: gp_Parab, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, P: gp_Parab, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, P: gp_Parab, Tang: bool) -> None: ...
	@overload
	def __init__(self, H: gp_Hypr, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, H: gp_Hypr, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, H: gp_Hypr, Tang: bool) -> None: ...
	def AddVertex(self, Pnt: IntPatch_Point) -> None: ...
	def Circle(self) -> gp_Circ: ...
	def ComputeVertexParameters(self, Tol: float) -> None: ...
	def Ellipse(self) -> gp_Elips: ...
	def FirstPoint(self) -> IntPatch_Point: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def Hyperbola(self) -> gp_Hypr: ...
	def LastPoint(self) -> IntPatch_Point: ...
	def Line(self) -> gp_Lin: ...
	def NbVertex(self) -> int: ...
	def Parabola(self) -> gp_Parab: ...
	def Replace(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def SetFirstPoint(self, IndFirst: int) -> None: ...
	def SetLastPoint(self, IndLast: int) -> None: ...
	def Vertex(self, Index: int) -> IntPatch_Point: ...

class IntPatch_PointLine(IntPatch_Line):
	def AddVertex(self, Pnt: IntPatch_Point, theIsPrepend: Optional[bool] = False) -> None: ...
	def ChangeVertex(self, Index: int) -> IntPatch_Point: ...
	def ClearVertexes(self) -> None: ...
	@staticmethod
	def CurvatureRadiusOfIntersLine(theS1: Adaptor3d_HSurface, theS2: Adaptor3d_HSurface, theUVPoint: IntSurf_PntOn2S) -> float: ...
	def Curve(self) -> IntSurf_LineOn2S: ...
	def IsOutBox(self, P: gp_Pnt) -> bool: ...
	def IsOutSurf1Box(self, P1: gp_Pnt2d) -> bool: ...
	def IsOutSurf2Box(self, P2: gp_Pnt2d) -> bool: ...
	def NbPnts(self) -> int: ...
	def NbVertex(self) -> int: ...
	def Point(self, Index: int) -> IntSurf_PntOn2S: ...
	def RemoveVertex(self, theIndex: int) -> None: ...
	def Vertex(self, Index: int) -> IntPatch_Point: ...

class IntPatch_PolyArc(IntPatch_Polygo):
	def __init__(self, A: Adaptor2d_HCurve2d, NbSample: int, Pfirst: float, Plast: float, BoxOtherPolygon: Bnd_Box2d) -> None: ...
	def Closed(self) -> bool: ...
	def NbPoints(self) -> int: ...
	def Parameter(self, Index: int) -> float: ...
	def Point(self, Index: int) -> gp_Pnt2d: ...
	def SetOffset(self, OffsetX: float, OffsetY: float) -> None: ...

class IntPatch_PolyLine(IntPatch_Polygo):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, InitDefle: float) -> None: ...
	def NbPoints(self) -> int: ...
	def Point(self, Index: int) -> gp_Pnt2d: ...
	def ResetError(self) -> None: ...
	def SetRLine(self, OnFirst: bool, Line: IntPatch_RLine) -> None: ...
	def SetWLine(self, OnFirst: bool, Line: IntPatch_WLine) -> None: ...

class IntPatch_RLine(IntPatch_PointLine):
	@overload
	def __init__(self, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, Tang: bool) -> None: ...
	def Add(self, L: IntSurf_LineOn2S) -> None: ...
	def AddVertex(self, Pnt: IntPatch_Point, theIsPrepend: Optional[bool] = False) -> None: ...
	def ArcOnS1(self) -> Adaptor2d_HCurve2d: ...
	def ArcOnS2(self) -> Adaptor2d_HCurve2d: ...
	def ChangeVertex(self, Index: int) -> IntPatch_Point: ...
	def ClearVertexes(self) -> None: ...
	def ComputeVertexParameters(self, Tol: float) -> None: ...
	def Curve(self) -> IntSurf_LineOn2S: ...
	def Dump(self, theMode: int) -> None: ...
	def FirstPoint(self) -> IntPatch_Point: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def HasPolygon(self) -> bool: ...
	def IsArcOnS1(self) -> bool: ...
	def IsArcOnS2(self) -> bool: ...
	def IsOutBox(self, theP: gp_Pnt) -> bool: ...
	def IsOutSurf1Box(self, theP: gp_Pnt2d) -> bool: ...
	def IsOutSurf2Box(self, theP: gp_Pnt2d) -> bool: ...
	def LastPoint(self) -> IntPatch_Point: ...
	def NbPnts(self) -> int: ...
	def NbVertex(self) -> int: ...
	def ParamOnS1(self) -> Tuple[float, float]: ...
	def ParamOnS2(self) -> Tuple[float, float]: ...
	def Point(self, Index: int) -> IntSurf_PntOn2S: ...
	def RemoveVertex(self, theIndex: int) -> None: ...
	def Replace(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def SetArcOnS1(self, A: Adaptor2d_HCurve2d) -> None: ...
	def SetArcOnS2(self, A: Adaptor2d_HCurve2d) -> None: ...
	def SetCurve(self, theNewCurve: IntSurf_LineOn2S) -> None: ...
	def SetFirstPoint(self, IndFirst: int) -> None: ...
	def SetLastPoint(self, IndLast: int) -> None: ...
	def SetPoint(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def Vertex(self, Index: int) -> IntPatch_Point: ...

class IntPatch_WLine(IntPatch_PointLine):
	@overload
	def __init__(self, Line: IntSurf_LineOn2S, Tang: bool, Trans1: IntSurf_TypeTrans, Trans2: IntSurf_TypeTrans) -> None: ...
	@overload
	def __init__(self, Line: IntSurf_LineOn2S, Tang: bool, Situ1: IntSurf_Situation, Situ2: IntSurf_Situation) -> None: ...
	@overload
	def __init__(self, Line: IntSurf_LineOn2S, Tang: bool) -> None: ...
	def AddVertex(self, Pnt: IntPatch_Point, theIsPrepend: Optional[bool] = False) -> None: ...
	def ChangeVertex(self, Index: int) -> IntPatch_Point: ...
	def ClearVertexes(self) -> None: ...
	def ComputeVertexParameters(self, Tol: float) -> None: ...
	def Curve(self) -> IntSurf_LineOn2S: ...
	def Dump(self, theMode: int) -> None: ...
	def EnablePurging(self, theIsEnabled: bool) -> None: ...
	@overload
	def FirstPoint(self) -> IntPatch_Point: ...
	@overload
	def FirstPoint(self) -> Tuple[IntPatch_Point, int]: ...
	def GetArcOnS1(self) -> Adaptor2d_HCurve2d: ...
	def GetArcOnS2(self) -> Adaptor2d_HCurve2d: ...
	def GetCreatingWay(self) -> False: ...
	def HasArcOnS1(self) -> bool: ...
	def HasArcOnS2(self) -> bool: ...
	def HasFirstPoint(self) -> bool: ...
	def HasLastPoint(self) -> bool: ...
	def InsertVertexBefore(self, theIndex: int, thePnt: IntPatch_Point) -> None: ...
	def IsOutBox(self, theP: gp_Pnt) -> bool: ...
	def IsOutSurf1Box(self, theP: gp_Pnt2d) -> bool: ...
	def IsOutSurf2Box(self, theP: gp_Pnt2d) -> bool: ...
	def IsPurgingAllowed(self) -> bool: ...
	@overload
	def LastPoint(self) -> IntPatch_Point: ...
	@overload
	def LastPoint(self) -> Tuple[IntPatch_Point, int]: ...
	def NbPnts(self) -> int: ...
	def NbVertex(self) -> int: ...
	def Point(self, Index: int) -> IntSurf_PntOn2S: ...
	def RemoveVertex(self, theIndex: int) -> None: ...
	def Replace(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def SetArcOnS1(self, A: Adaptor2d_HCurve2d) -> None: ...
	def SetArcOnS2(self, A: Adaptor2d_HCurve2d) -> None: ...
	def SetCreatingWayInfo(self, theAlgo: IntPatch_WLType) -> None: ...
	def SetFirstPoint(self, IndFirst: int) -> None: ...
	def SetLastPoint(self, IndLast: int) -> None: ...
	def SetPeriod(self, pu1: float, pv1: float, pu2: float, pv2: float) -> None: ...
	def SetPoint(self, Index: int, Pnt: IntPatch_Point) -> None: ...
	def U1Period(self) -> float: ...
	def U2Period(self) -> float: ...
	def V1Period(self) -> float: ...
	def V2Period(self) -> float: ...
	def Vertex(self, Index: int) -> IntPatch_Point: ...

#classnotwrapped
class IntPatch_Polyhedron: ...

# harray1 classes
# harray2 classes
# hsequence classes

IntPatch_HCurve2dTool_BSpline = IntPatch_HCurve2dTool.BSpline
IntPatch_HCurve2dTool_Bezier = IntPatch_HCurve2dTool.Bezier
IntPatch_HCurve2dTool_Circle = IntPatch_HCurve2dTool.Circle
IntPatch_HCurve2dTool_Continuity = IntPatch_HCurve2dTool.Continuity
IntPatch_HCurve2dTool_D0 = IntPatch_HCurve2dTool.D0
IntPatch_HCurve2dTool_D1 = IntPatch_HCurve2dTool.D1
IntPatch_HCurve2dTool_D2 = IntPatch_HCurve2dTool.D2
IntPatch_HCurve2dTool_D3 = IntPatch_HCurve2dTool.D3
IntPatch_HCurve2dTool_DN = IntPatch_HCurve2dTool.DN
IntPatch_HCurve2dTool_Ellipse = IntPatch_HCurve2dTool.Ellipse
IntPatch_HCurve2dTool_FirstParameter = IntPatch_HCurve2dTool.FirstParameter
IntPatch_HCurve2dTool_GetType = IntPatch_HCurve2dTool.GetType
IntPatch_HCurve2dTool_Hyperbola = IntPatch_HCurve2dTool.Hyperbola
IntPatch_HCurve2dTool_Intervals = IntPatch_HCurve2dTool.Intervals
IntPatch_HCurve2dTool_IsClosed = IntPatch_HCurve2dTool.IsClosed
IntPatch_HCurve2dTool_IsPeriodic = IntPatch_HCurve2dTool.IsPeriodic
IntPatch_HCurve2dTool_LastParameter = IntPatch_HCurve2dTool.LastParameter
IntPatch_HCurve2dTool_Line = IntPatch_HCurve2dTool.Line
IntPatch_HCurve2dTool_NbIntervals = IntPatch_HCurve2dTool.NbIntervals
IntPatch_HCurve2dTool_NbSamples = IntPatch_HCurve2dTool.NbSamples
IntPatch_HCurve2dTool_Parabola = IntPatch_HCurve2dTool.Parabola
IntPatch_HCurve2dTool_Period = IntPatch_HCurve2dTool.Period
IntPatch_HCurve2dTool_Resolution = IntPatch_HCurve2dTool.Resolution
IntPatch_HCurve2dTool_Value = IntPatch_HCurve2dTool.Value
IntPatch_HInterTool_Bounds = IntPatch_HInterTool.Bounds
IntPatch_HInterTool_HasBeenSeen = IntPatch_HInterTool.HasBeenSeen
IntPatch_HInterTool_HasFirstPoint = IntPatch_HInterTool.HasFirstPoint
IntPatch_HInterTool_HasLastPoint = IntPatch_HInterTool.HasLastPoint
IntPatch_HInterTool_IsAllSolution = IntPatch_HInterTool.IsAllSolution
IntPatch_HInterTool_IsVertex = IntPatch_HInterTool.IsVertex
IntPatch_HInterTool_NbPoints = IntPatch_HInterTool.NbPoints
IntPatch_HInterTool_NbSamplesOnArc = IntPatch_HInterTool.NbSamplesOnArc
IntPatch_HInterTool_NbSamplesU = IntPatch_HInterTool.NbSamplesU
IntPatch_HInterTool_NbSamplesV = IntPatch_HInterTool.NbSamplesV
IntPatch_HInterTool_NbSegments = IntPatch_HInterTool.NbSegments
IntPatch_HInterTool_Parameter = IntPatch_HInterTool.Parameter
IntPatch_HInterTool_Project = IntPatch_HInterTool.Project
IntPatch_HInterTool_SingularOnUMax = IntPatch_HInterTool.SingularOnUMax
IntPatch_HInterTool_SingularOnUMin = IntPatch_HInterTool.SingularOnUMin
IntPatch_HInterTool_SingularOnVMax = IntPatch_HInterTool.SingularOnVMax
IntPatch_HInterTool_SingularOnVMin = IntPatch_HInterTool.SingularOnVMin
IntPatch_HInterTool_Tolerance = IntPatch_HInterTool.Tolerance
IntPatch_HInterTool_Value = IntPatch_HInterTool.Value
IntPatch_HInterTool_Vertex = IntPatch_HInterTool.Vertex
IntPatch_PolyhedronTool_Bounding = IntPatch_PolyhedronTool.Bounding
IntPatch_PolyhedronTool_ComponentsBounding = IntPatch_PolyhedronTool.ComponentsBounding
IntPatch_PolyhedronTool_DeflectionOverEstimation = IntPatch_PolyhedronTool.DeflectionOverEstimation
IntPatch_PolyhedronTool_NbTriangles = IntPatch_PolyhedronTool.NbTriangles
IntPatch_PolyhedronTool_Point = IntPatch_PolyhedronTool.Point
IntPatch_PolyhedronTool_TriConnex = IntPatch_PolyhedronTool.TriConnex
IntPatch_PolyhedronTool_Triangle = IntPatch_PolyhedronTool.Triangle
IntPatch_RstInt_PutVertexOnLine = IntPatch_RstInt.PutVertexOnLine
IntPatch_SpecialPoints_AddCrossUVIsoPoint = IntPatch_SpecialPoints.AddCrossUVIsoPoint
IntPatch_SpecialPoints_AddPointOnUorVIso = IntPatch_SpecialPoints.AddPointOnUorVIso
IntPatch_SpecialPoints_AddSingularPole = IntPatch_SpecialPoints.AddSingularPole
IntPatch_SpecialPoints_AdjustPointAndVertex = IntPatch_SpecialPoints.AdjustPointAndVertex
IntPatch_SpecialPoints_ContinueAfterSpecialPoint = IntPatch_SpecialPoints.ContinueAfterSpecialPoint
IntPatch_WLineTool_ComputePurgedWLine = IntPatch_WLineTool.ComputePurgedWLine
IntPatch_WLineTool_ExtendTwoWLines = IntPatch_WLineTool.ExtendTwoWLines
IntPatch_WLineTool_JoinWLines = IntPatch_WLineTool.JoinWLines
IntPatch_PointLine_CurvatureRadiusOfIntersLine = IntPatch_PointLine.CurvatureRadiusOfIntersLine
