from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.TDataStd import *
from OCC.Core.TDF import *
from OCC.Core.TColStd import *
from OCC.Core.gp import *
from OCC.Core.Quantity import *
from OCC.Core.TopoDS import *
from OCC.Core.XCAFDimTolObjects import *
from OCC.Core.TDocStd import *
from OCC.Core.TopLoc import *
from OCC.Core.XCAFNoteObjects import *
from OCC.Core.OSD import *
from OCC.Core.TopTools import *
from OCC.Core.XCAFView import *
from OCC.Core.Graphic3d import *

XCAFDoc_PartId = NewType('XCAFDoc_PartId', TCollection_AsciiString)

class XCAFDoc_GraphNodeSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class XCAFDoc_ColorType(IntEnum):
	XCAFDoc_ColorGen: int = ...
	XCAFDoc_ColorSurf: int = ...
	XCAFDoc_ColorCurv: int = ...
XCAFDoc_ColorGen = XCAFDoc_ColorType.XCAFDoc_ColorGen
XCAFDoc_ColorSurf = XCAFDoc_ColorType.XCAFDoc_ColorSurf
XCAFDoc_ColorCurv = XCAFDoc_ColorType.XCAFDoc_ColorCurv

class xcafdoc:
	@staticmethod
	def AssemblyGUID() -> Standard_GUID: ...
	@staticmethod
	def ColorByLayerGUID() -> Standard_GUID: ...
	@staticmethod
	def ColorRefGUID(type: XCAFDoc_ColorType) -> Standard_GUID: ...
	@staticmethod
	def DatumRefGUID() -> Standard_GUID: ...
	@staticmethod
	def DatumTolRefGUID() -> Standard_GUID: ...
	@staticmethod
	def DimTolRefGUID() -> Standard_GUID: ...
	@staticmethod
	def DimensionRefFirstGUID() -> Standard_GUID: ...
	@staticmethod
	def DimensionRefSecondGUID() -> Standard_GUID: ...
	@staticmethod
	def ExternRefGUID() -> Standard_GUID: ...
	@staticmethod
	def GeomToleranceRefGUID() -> Standard_GUID: ...
	@staticmethod
	def InvisibleGUID() -> Standard_GUID: ...
	@staticmethod
	def LayerRefGUID() -> Standard_GUID: ...
	@staticmethod
	def LockGUID() -> Standard_GUID: ...
	@staticmethod
	def MaterialRefGUID() -> Standard_GUID: ...
	@staticmethod
	def NoteRefGUID() -> Standard_GUID: ...
	@staticmethod
	def SHUORefGUID() -> Standard_GUID: ...
	@staticmethod
	def ShapeRefGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefAnnotationGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefGDTGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefNoteGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefPlaneGUID() -> Standard_GUID: ...
	@staticmethod
	def ViewRefShapeGUID() -> Standard_GUID: ...
	@staticmethod
	def VisMaterialRefGUID() -> Standard_GUID: ...

class XCAFDoc_Area(TDataStd_Real):
	def __init__(self) -> None: ...
	@overload
	def Get(self) -> float: ...
	@overload
	@staticmethod
	def Get(label: TDF_Label) -> Tuple[bool, float]: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	@overload
	def Set(self, vol: float) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, area: float) -> XCAFDoc_Area: ...

class XCAFDoc_AssemblyItemId:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, thePath: TColStd_ListOfAsciiString) -> None: ...
	@overload
	def __init__(self, theString: TCollection_AsciiString) -> None: ...
	def GetPath(self) -> TColStd_ListOfAsciiString: ...
	@overload
	def Init(self, thePath: TColStd_ListOfAsciiString) -> None: ...
	@overload
	def Init(self, theString: TCollection_AsciiString) -> None: ...
	def IsChild(self, theOther: XCAFDoc_AssemblyItemId) -> bool: ...
	def IsDirectChild(self, theOther: XCAFDoc_AssemblyItemId) -> bool: ...
	def IsEqual(self, theOther: XCAFDoc_AssemblyItemId) -> bool: ...
	def IsNull(self) -> bool: ...
	def Nullify(self) -> None: ...
	def ToString(self) -> TCollection_AsciiString: ...

class XCAFDoc_AssemblyItemRef(TDF_Attribute):
	def __init__(self) -> None: ...
	def ClearExtraRef(self) -> None: ...
	@staticmethod
	def Get(theLabel: TDF_Label) -> XCAFDoc_AssemblyItemRef: ...
	def GetGUID(self) -> Standard_GUID: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetItem(self) -> XCAFDoc_AssemblyItemId: ...
	def GetSubshapeIndex(self) -> int: ...
	def HasExtraRef(self) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def IsGUID(self) -> bool: ...
	def IsOrphan(self) -> bool: ...
	def IsSubshapeIndex(self) -> bool: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, theAttrInto: TDF_Attribute, theRT: TDF_RelocationTable) -> None: ...
	def Restore(self, theAttrFrom: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theShapeIndex: int) -> XCAFDoc_AssemblyItemRef: ...
	def SetGUID(self, theAttrGUID: Standard_GUID) -> None: ...
	@overload
	def SetItem(self, theItemId: XCAFDoc_AssemblyItemId) -> None: ...
	@overload
	def SetItem(self, thePath: TColStd_ListOfAsciiString) -> None: ...
	@overload
	def SetItem(self, theString: TCollection_AsciiString) -> None: ...
	def SetSubshapeIndex(self, theShapeIndex: int) -> None: ...

class XCAFDoc_Centroid(TDF_Attribute):
	def __init__(self) -> None: ...
	@overload
	def Get(self) -> gp_Pnt: ...
	@overload
	@staticmethod
	def Get(label: TDF_Label, pnt: gp_Pnt) -> bool: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, pnt: gp_Pnt) -> XCAFDoc_Centroid: ...
	@overload
	def Set(self, pnt: gp_Pnt) -> None: ...

class XCAFDoc_ClippingPlaneTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@overload
	def AddClippingPlane(self, thePlane: gp_Pln, theName: TCollection_ExtendedString, theCapping: bool) -> TDF_Label: ...
	@overload
	def AddClippingPlane(self, thePlane: gp_Pln, theName: TCollection_HAsciiString, theCapping: bool) -> TDF_Label: ...
	@overload
	def AddClippingPlane(self, thePlane: gp_Pln, theName: TCollection_ExtendedString) -> TDF_Label: ...
	@overload
	def AddClippingPlane(self, thePlane: gp_Pln, theName: TCollection_HAsciiString) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	@overload
	def GetCapping(self, theClippingPlaneL: TDF_Label) -> bool: ...
	@overload
	def GetCapping(self, theClippingPlaneL: TDF_Label) -> Tuple[bool, bool]: ...
	@overload
	def GetClippingPlane(self, theLabel: TDF_Label, thePlane: gp_Pln, theName: TCollection_ExtendedString) -> Tuple[bool, bool]: ...
	@overload
	def GetClippingPlane(self, theLabel: TDF_Label, thePlane: gp_Pln, theName: TCollection_HAsciiString) -> Tuple[bool, bool]: ...
	def GetClippingPlanes(self, Labels: TDF_LabelSequence) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def IsClippingPlane(self, theLabel: TDF_Label) -> bool: ...
	def RemoveClippingPlane(self, theLabel: TDF_Label) -> bool: ...
	@staticmethod
	def Set(theLabel: TDF_Label) -> XCAFDoc_ClippingPlaneTool: ...
	def SetCapping(self, theClippingPlaneL: TDF_Label, theCapping: bool) -> None: ...
	def UpdateClippingPlane(self, theLabelL: TDF_Label, thePlane: gp_Pln, theName: TCollection_ExtendedString) -> None: ...

class XCAFDoc_Color(TDF_Attribute):
	def __init__(self) -> None: ...
	def GetAlpha(self) -> float: ...
	def GetColor(self) -> Quantity_Color: ...
	def GetColorRGBA(self) -> Quantity_ColorRGBA: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetNOC(self) -> Quantity_NameOfColor: ...
	def GetRGB(self) -> Tuple[float, float, float]: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, C: Quantity_Color) -> XCAFDoc_Color: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, C: Quantity_ColorRGBA) -> XCAFDoc_Color: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, C: Quantity_NameOfColor) -> XCAFDoc_Color: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, R: float, G: float, B: float, alpha: Optional[float] = 1.0) -> XCAFDoc_Color: ...
	@overload
	def Set(self, C: Quantity_Color) -> None: ...
	@overload
	def Set(self, C: Quantity_ColorRGBA) -> None: ...
	@overload
	def Set(self, C: Quantity_NameOfColor) -> None: ...
	@overload
	def Set(self, R: float, G: float, B: float, alpha: Optional[float] = 1.0) -> None: ...

class XCAFDoc_ColorTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@overload
	def AddColor(self, col: Quantity_Color) -> TDF_Label: ...
	@overload
	def AddColor(self, col: Quantity_ColorRGBA) -> TDF_Label: ...
	@staticmethod
	def AutoNaming() -> bool: ...
	def BaseLabel(self) -> TDF_Label: ...
	@overload
	def FindColor(self, col: Quantity_Color, lab: TDF_Label) -> bool: ...
	@overload
	def FindColor(self, col: Quantity_ColorRGBA, lab: TDF_Label) -> bool: ...
	@overload
	def FindColor(self, col: Quantity_Color) -> TDF_Label: ...
	@overload
	def FindColor(self, col: Quantity_ColorRGBA) -> TDF_Label: ...
	@overload
	def GetColor(self, lab: TDF_Label, col: Quantity_Color) -> bool: ...
	@overload
	def GetColor(self, lab: TDF_Label, col: Quantity_ColorRGBA) -> bool: ...
	@overload
	@staticmethod
	def GetColor(L: TDF_Label, type: XCAFDoc_ColorType, colorL: TDF_Label) -> bool: ...
	@overload
	def GetColor(self, L: TDF_Label, type: XCAFDoc_ColorType, color: Quantity_Color) -> bool: ...
	@overload
	def GetColor(self, L: TDF_Label, type: XCAFDoc_ColorType, color: Quantity_ColorRGBA) -> bool: ...
	@overload
	def GetColor(self, S: TopoDS_Shape, type: XCAFDoc_ColorType, colorL: TDF_Label) -> bool: ...
	@overload
	def GetColor(self, S: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_Color) -> bool: ...
	@overload
	def GetColor(self, S: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_ColorRGBA) -> bool: ...
	def GetColors(self, Labels: TDF_LabelSequence) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	@overload
	def GetInstanceColor(self, theShape: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_Color) -> bool: ...
	@overload
	def GetInstanceColor(self, theShape: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_ColorRGBA) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def IsColor(self, lab: TDF_Label) -> bool: ...
	def IsColorByLayer(self, L: TDF_Label) -> bool: ...
	def IsInstanceVisible(self, theShape: TopoDS_Shape) -> bool: ...
	@overload
	def IsSet(self, L: TDF_Label, type: XCAFDoc_ColorType) -> bool: ...
	@overload
	def IsSet(self, S: TopoDS_Shape, type: XCAFDoc_ColorType) -> bool: ...
	def IsVisible(self, L: TDF_Label) -> bool: ...
	def RemoveColor(self, lab: TDF_Label) -> None: ...
	def ReverseChainsOfTreeNodes(self) -> bool: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_ColorTool: ...
	@staticmethod
	def SetAutoNaming(theIsAutoNaming: bool) -> None: ...
	@overload
	def SetColor(self, L: TDF_Label, colorL: TDF_Label, type: XCAFDoc_ColorType) -> None: ...
	@overload
	def SetColor(self, L: TDF_Label, Color: Quantity_Color, type: XCAFDoc_ColorType) -> None: ...
	@overload
	def SetColor(self, L: TDF_Label, Color: Quantity_ColorRGBA, type: XCAFDoc_ColorType) -> None: ...
	@overload
	def SetColor(self, S: TopoDS_Shape, colorL: TDF_Label, type: XCAFDoc_ColorType) -> bool: ...
	@overload
	def SetColor(self, S: TopoDS_Shape, Color: Quantity_Color, type: XCAFDoc_ColorType) -> bool: ...
	@overload
	def SetColor(self, S: TopoDS_Shape, Color: Quantity_ColorRGBA, type: XCAFDoc_ColorType) -> bool: ...
	def SetColorByLayer(self, shapeLabel: TDF_Label, isColorByLayer: Optional[bool] = False) -> None: ...
	@overload
	def SetInstanceColor(self, theShape: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_Color, isCreateSHUO: Optional[bool] = True) -> bool: ...
	@overload
	def SetInstanceColor(self, theShape: TopoDS_Shape, type: XCAFDoc_ColorType, color: Quantity_ColorRGBA, isCreateSHUO: Optional[bool] = True) -> bool: ...
	def SetVisibility(self, shapeLabel: TDF_Label, isvisible: Optional[bool] = True) -> None: ...
	def ShapeTool(self) -> XCAFDoc_ShapeTool: ...
	@overload
	def UnSetColor(self, L: TDF_Label, type: XCAFDoc_ColorType) -> None: ...
	@overload
	def UnSetColor(self, S: TopoDS_Shape, type: XCAFDoc_ColorType) -> bool: ...

class XCAFDoc_Datum(TDF_Attribute):
	def __init__(self) -> None: ...
	def GetDescription(self) -> TCollection_HAsciiString: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetIdentification(self) -> TCollection_HAsciiString: ...
	def GetName(self) -> TCollection_HAsciiString: ...
	def GetObject(self) -> XCAFDimTolObjects_DatumObject: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, anIdentification: TCollection_HAsciiString) -> XCAFDoc_Datum: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label) -> XCAFDoc_Datum: ...
	@overload
	def Set(self, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, anIdentification: TCollection_HAsciiString) -> None: ...
	def SetObject(self, theDatumObject: XCAFDimTolObjects_DatumObject) -> None: ...

class XCAFDoc_DimTol(TDF_Attribute):
	def __init__(self) -> None: ...
	def GetDescription(self) -> TCollection_HAsciiString: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetKind(self) -> int: ...
	def GetName(self) -> TCollection_HAsciiString: ...
	def GetVal(self) -> TColStd_HArray1OfReal: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, kind: int, aVal: TColStd_HArray1OfReal, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString) -> XCAFDoc_DimTol: ...
	@overload
	def Set(self, kind: int, aVal: TColStd_HArray1OfReal, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString) -> None: ...

class XCAFDoc_DimTolTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@overload
	def AddDatum(self, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, theIdentification: TCollection_HAsciiString) -> TDF_Label: ...
	@overload
	def AddDatum(self) -> TDF_Label: ...
	def AddDimTol(self, theKind: int, theVal: TColStd_HArray1OfReal, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString) -> TDF_Label: ...
	def AddDimension(self) -> TDF_Label: ...
	def AddGeomTolerance(self) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	def FindDatum(self, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, theIdentification: TCollection_HAsciiString, lab: TDF_Label) -> bool: ...
	@overload
	def FindDimTol(self, theKind: int, theVal: TColStd_HArray1OfReal, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, lab: TDF_Label) -> bool: ...
	@overload
	def FindDimTol(self, theKind: int, theVal: TColStd_HArray1OfReal, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString) -> TDF_Label: ...
	def GetDatum(self, theDatumL: TDF_Label, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, theIdentification: TCollection_HAsciiString) -> bool: ...
	def GetDatumLabels(self, Labels: TDF_LabelSequence) -> None: ...
	def GetDatumOfTolerLabels(self, theDimTolL: TDF_Label, theDatums: TDF_LabelSequence) -> bool: ...
	def GetDatumWithObjectOfTolerLabels(self, theDimTolL: TDF_Label, theDatums: TDF_LabelSequence) -> bool: ...
	def GetDimTol(self, theDimTolL: TDF_Label, theVal: TColStd_HArray1OfReal, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString) -> Tuple[bool, int]: ...
	def GetDimTolLabels(self, Labels: TDF_LabelSequence) -> None: ...
	def GetDimensionLabels(self, theLabels: TDF_LabelSequence) -> None: ...
	def GetGeomToleranceLabels(self, theLabels: TDF_LabelSequence) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetRefDatumLabel(self, theShapeL: TDF_Label, theDatum: TDF_LabelSequence) -> bool: ...
	def GetRefDimensionLabels(self, theShapeL: TDF_Label, theDimensions: TDF_LabelSequence) -> bool: ...
	def GetRefGeomToleranceLabels(self, theShapeL: TDF_Label, theDimTols: TDF_LabelSequence) -> bool: ...
	def GetRefShapeLabel(self, theL: TDF_Label, theShapeLFirst: TDF_LabelSequence, theShapeLSecond: TDF_LabelSequence) -> bool: ...
	def GetTolerOfDatumLabels(self, theDatumL: TDF_Label, theTols: TDF_LabelSequence) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def IsDatum(self, lab: TDF_Label) -> bool: ...
	def IsDimTol(self, theLab: TDF_Label) -> bool: ...
	def IsDimension(self, theLab: TDF_Label) -> bool: ...
	def IsGeomTolerance(self, theLab: TDF_Label) -> bool: ...
	def IsLocked(self, theViewL: TDF_Label) -> bool: ...
	def Lock(self, theViewL: TDF_Label) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_DimTolTool: ...
	@overload
	def SetDatum(self, theShapeLabels: TDF_LabelSequence, theDatumL: TDF_Label) -> None: ...
	@overload
	def SetDatum(self, theL: TDF_Label, theTolerL: TDF_Label, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, theIdentification: TCollection_HAsciiString) -> None: ...
	def SetDatumToGeomTol(self, theDatumL: TDF_Label, theTolerL: TDF_Label) -> None: ...
	@overload
	def SetDimTol(self, theL: TDF_Label, theDimTolL: TDF_Label) -> None: ...
	@overload
	def SetDimTol(self, theL: TDF_Label, theKind: int, theVal: TColStd_HArray1OfReal, theName: TCollection_HAsciiString, theDescription: TCollection_HAsciiString) -> TDF_Label: ...
	@overload
	def SetDimension(self, theFirstLS: TDF_LabelSequence, theSecondLS: TDF_LabelSequence, theDimL: TDF_Label) -> None: ...
	@overload
	def SetDimension(self, theFirstL: TDF_Label, theSecondL: TDF_Label, theDimL: TDF_Label) -> None: ...
	@overload
	def SetDimension(self, theL: TDF_Label, theDimL: TDF_Label) -> None: ...
	@overload
	def SetGeomTolerance(self, theL: TDF_Label, theGeomTolL: TDF_Label) -> None: ...
	@overload
	def SetGeomTolerance(self, theL: TDF_LabelSequence, theGeomTolL: TDF_Label) -> None: ...
	def ShapeTool(self) -> XCAFDoc_ShapeTool: ...
	def Unlock(self, theViewL: TDF_Label) -> None: ...

class XCAFDoc_Dimension(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetObject(self) -> XCAFDimTolObjects_DimensionObject: ...
	def ID(self) -> Standard_GUID: ...
	@staticmethod
	def Set(theLabel: TDF_Label) -> XCAFDoc_Dimension: ...
	def SetObject(self, theDimensionObject: XCAFDimTolObjects_DimensionObject) -> None: ...

class XCAFDoc_DocumentTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	def AfterRetrieval(self, forceIt: Optional[bool] = False) -> bool: ...
	@staticmethod
	def ClippingPlaneTool(acces: TDF_Label) -> XCAFDoc_ClippingPlaneTool: ...
	@staticmethod
	def ClippingPlanesLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def ColorTool(acces: TDF_Label) -> XCAFDoc_ColorTool: ...
	@staticmethod
	def ColorsLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def DGTsLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def DimTolTool(acces: TDF_Label) -> XCAFDoc_DimTolTool: ...
	@staticmethod
	def DocLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def Init(self) -> None: ...
	@staticmethod
	def IsXCAFDocument(Doc: TDocStd_Document) -> bool: ...
	@staticmethod
	def LayerTool(acces: TDF_Label) -> XCAFDoc_LayerTool: ...
	@staticmethod
	def LayersLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def MaterialTool(acces: TDF_Label) -> XCAFDoc_MaterialTool: ...
	@staticmethod
	def MaterialsLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def NotesLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def NotesTool(acces: TDF_Label) -> XCAFDoc_NotesTool: ...
	@staticmethod
	def Set(L: TDF_Label, IsAcces: Optional[bool] = True) -> XCAFDoc_DocumentTool: ...
	@staticmethod
	def ShapeTool(acces: TDF_Label) -> XCAFDoc_ShapeTool: ...
	@staticmethod
	def ShapesLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def ViewTool(acces: TDF_Label) -> XCAFDoc_ViewTool: ...
	@staticmethod
	def ViewsLabel(acces: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def VisMaterialLabel(theLabel: TDF_Label) -> TDF_Label: ...
	@staticmethod
	def VisMaterialTool(theLabel: TDF_Label) -> XCAFDoc_VisMaterialTool: ...

class XCAFDoc_Editor:
	@overload
	@staticmethod
	def Expand(Doc: TDF_Label, Shape: TDF_Label, recursively: Optional[bool] = True) -> bool: ...
	@overload
	@staticmethod
	def Expand(Doc: TDF_Label, recursively: Optional[bool] = True) -> bool: ...

class XCAFDoc_GraphNode(TDF_Attribute):
	def __init__(self) -> None: ...
	def BeforeForget(self) -> None: ...
	def ChildIndex(self, Ch: XCAFDoc_GraphNode) -> int: ...
	def FatherIndex(self, F: XCAFDoc_GraphNode) -> int: ...
	@staticmethod
	def Find(L: TDF_Label, G: XCAFDoc_GraphNode) -> bool: ...
	def GetChild(self, Chindex: int) -> XCAFDoc_GraphNode: ...
	@staticmethod
	def GetDefaultGraphID() -> Standard_GUID: ...
	def GetFather(self, Findex: int) -> XCAFDoc_GraphNode: ...
	def ID(self) -> Standard_GUID: ...
	def IsChild(self, F: XCAFDoc_GraphNode) -> bool: ...
	def IsFather(self, Ch: XCAFDoc_GraphNode) -> bool: ...
	def NbChildren(self) -> int: ...
	def NbFathers(self) -> int: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def References(self, aDataSet: TDF_DataSet) -> None: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_GraphNode: ...
	@overload
	@staticmethod
	def Set(L: TDF_Label, ExplicitGraphID: Standard_GUID) -> XCAFDoc_GraphNode: ...
	def SetChild(self, Ch: XCAFDoc_GraphNode) -> int: ...
	def SetFather(self, F: XCAFDoc_GraphNode) -> int: ...
	def SetGraphID(self, explicitID: Standard_GUID) -> None: ...
	@overload
	def UnSetChild(self, Ch: XCAFDoc_GraphNode) -> None: ...
	@overload
	def UnSetChild(self, Chindex: int) -> None: ...
	@overload
	def UnSetFather(self, F: XCAFDoc_GraphNode) -> None: ...
	@overload
	def UnSetFather(self, Findex: int) -> None: ...

class XCAFDoc_LayerTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	def AddLayer(self, aLayer: TCollection_ExtendedString) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	@overload
	def FindLayer(self, aLayer: TCollection_ExtendedString, lab: TDF_Label) -> bool: ...
	@overload
	def FindLayer(self, aLayer: TCollection_ExtendedString) -> TDF_Label: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetLayer(self, lab: TDF_Label, aLayer: TCollection_ExtendedString) -> bool: ...
	def GetLayerLabels(self, Labels: TDF_LabelSequence) -> None: ...
	@overload
	def GetLayers(self, L: TDF_Label, aLayerS: TColStd_HSequenceOfExtendedString) -> bool: ...
	@overload
	def GetLayers(self, L: TDF_Label, aLayerLS: TDF_LabelSequence) -> bool: ...
	@overload
	def GetLayers(self, L: TDF_Label) -> TColStd_HSequenceOfExtendedString: ...
	@overload
	def GetLayers(self, Sh: TopoDS_Shape, aLayerS: TColStd_HSequenceOfExtendedString) -> bool: ...
	@overload
	def GetLayers(self, Sh: TopoDS_Shape, aLayerLS: TDF_LabelSequence) -> bool: ...
	@overload
	def GetLayers(self, Sh: TopoDS_Shape) -> TColStd_HSequenceOfExtendedString: ...
	def GetShapesOfLayer(self, layerL: TDF_Label, ShLabels: TDF_LabelSequence) -> None: ...
	def ID(self) -> Standard_GUID: ...
	def IsLayer(self, lab: TDF_Label) -> bool: ...
	@overload
	def IsSet(self, L: TDF_Label, aLayer: TCollection_ExtendedString) -> bool: ...
	@overload
	def IsSet(self, L: TDF_Label, aLayerL: TDF_Label) -> bool: ...
	@overload
	def IsSet(self, Sh: TopoDS_Shape, aLayer: TCollection_ExtendedString) -> bool: ...
	@overload
	def IsSet(self, Sh: TopoDS_Shape, aLayerL: TDF_Label) -> bool: ...
	def IsVisible(self, layerL: TDF_Label) -> bool: ...
	def RemoveLayer(self, lab: TDF_Label) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_LayerTool: ...
	@overload
	def SetLayer(self, L: TDF_Label, LayerL: TDF_Label, shapeInOneLayer: Optional[bool] = False) -> None: ...
	@overload
	def SetLayer(self, L: TDF_Label, aLayer: TCollection_ExtendedString, shapeInOneLayer: Optional[bool] = False) -> None: ...
	@overload
	def SetLayer(self, Sh: TopoDS_Shape, LayerL: TDF_Label, shapeInOneLayer: Optional[bool] = False) -> bool: ...
	@overload
	def SetLayer(self, Sh: TopoDS_Shape, aLayer: TCollection_ExtendedString, shapeInOneLayer: Optional[bool] = False) -> bool: ...
	def SetVisibility(self, layerL: TDF_Label, isvisible: Optional[bool] = True) -> None: ...
	def ShapeTool(self) -> XCAFDoc_ShapeTool: ...
	@overload
	def UnSetLayers(self, L: TDF_Label) -> None: ...
	@overload
	def UnSetLayers(self, Sh: TopoDS_Shape) -> bool: ...
	@overload
	def UnSetOneLayer(self, L: TDF_Label, aLayer: TCollection_ExtendedString) -> bool: ...
	@overload
	def UnSetOneLayer(self, L: TDF_Label, aLayerL: TDF_Label) -> bool: ...
	@overload
	def UnSetOneLayer(self, Sh: TopoDS_Shape, aLayer: TCollection_ExtendedString) -> bool: ...
	@overload
	def UnSetOneLayer(self, Sh: TopoDS_Shape, aLayerL: TDF_Label) -> bool: ...

class XCAFDoc_Location(TDF_Attribute):
	def __init__(self) -> None: ...
	def Get(self) -> TopLoc_Location: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, Loc: TopLoc_Location) -> XCAFDoc_Location: ...
	@overload
	def Set(self, Loc: TopLoc_Location) -> None: ...

class XCAFDoc_Material(TDF_Attribute):
	def __init__(self) -> None: ...
	def GetDensName(self) -> TCollection_HAsciiString: ...
	def GetDensValType(self) -> TCollection_HAsciiString: ...
	def GetDensity(self) -> float: ...
	def GetDescription(self) -> TCollection_HAsciiString: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetName(self) -> TCollection_HAsciiString: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, Into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, With: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aDensity: float, aDensName: TCollection_HAsciiString, aDensValType: TCollection_HAsciiString) -> XCAFDoc_Material: ...
	@overload
	def Set(self, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aDensity: float, aDensName: TCollection_HAsciiString, aDensValType: TCollection_HAsciiString) -> None: ...

class XCAFDoc_MaterialTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	def AddMaterial(self, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aDensity: float, aDensName: TCollection_HAsciiString, aDensValType: TCollection_HAsciiString) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	@staticmethod
	def GetDensityForShape(ShapeL: TDF_Label) -> float: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetMaterial(self, MatL: TDF_Label, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aDensName: TCollection_HAsciiString, aDensValType: TCollection_HAsciiString) -> Tuple[bool, float]: ...
	def GetMaterialLabels(self, Labels: TDF_LabelSequence) -> None: ...
	def ID(self) -> Standard_GUID: ...
	def IsMaterial(self, lab: TDF_Label) -> bool: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_MaterialTool: ...
	@overload
	def SetMaterial(self, L: TDF_Label, MatL: TDF_Label) -> None: ...
	@overload
	def SetMaterial(self, L: TDF_Label, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aDensity: float, aDensName: TCollection_HAsciiString, aDensValType: TCollection_HAsciiString) -> None: ...
	def ShapeTool(self) -> XCAFDoc_ShapeTool: ...

class XCAFDoc_Note(TDF_Attribute):
	@staticmethod
	def Get(theLabel: TDF_Label) -> XCAFDoc_Note: ...
	def GetObject(self) -> XCAFNoteObjects_NoteObject: ...
	@staticmethod
	def IsMine(theLabel: TDF_Label) -> bool: ...
	def IsOrphan(self) -> bool: ...
	def Paste(self, theAttrInto: TDF_Attribute, theRT: TDF_RelocationTable) -> None: ...
	def Restore(self, theAttrFrom: TDF_Attribute) -> None: ...
	def Set(self, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString) -> None: ...
	def SetObject(self, theObject: XCAFNoteObjects_NoteObject) -> None: ...
	def TimeStamp(self) -> TCollection_ExtendedString: ...
	def UserName(self) -> TCollection_ExtendedString: ...

class XCAFDoc_NotesTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@overload
	def AddNote(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	def AddNote(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	def AddNoteToAttr(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	def AddNoteToAttr(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label, theGUID: Standard_GUID) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	def AddNoteToSubshape(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theSubshapeIndex: int) -> XCAFDoc_AssemblyItemRef: ...
	@overload
	def AddNoteToSubshape(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label, theSubshapeIndex: int) -> XCAFDoc_AssemblyItemRef: ...
	def CreateBalloon(self, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theComment: TCollection_ExtendedString) -> XCAFDoc_Note: ...
	@overload
	def CreateBinData(self, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theFile: OSD_File) -> XCAFDoc_Note: ...
	@overload
	def CreateBinData(self, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theData: TColStd_HArray1OfByte) -> XCAFDoc_Note: ...
	def CreateComment(self, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theComment: TCollection_ExtendedString) -> XCAFDoc_Note: ...
	def DeleteAllNotes(self) -> int: ...
	def DeleteNote(self, theNoteLabel: TDF_Label) -> bool: ...
	def DeleteNotes(self, theNoteLabels: TDF_LabelSequence) -> int: ...
	def DeleteOrphanNotes(self) -> int: ...
	@overload
	def FindAnnotatedItem(self, theItemId: XCAFDoc_AssemblyItemId) -> TDF_Label: ...
	@overload
	def FindAnnotatedItem(self, theItemLabel: TDF_Label) -> TDF_Label: ...
	@overload
	def FindAnnotatedItemAttr(self, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID) -> TDF_Label: ...
	@overload
	def FindAnnotatedItemAttr(self, theItemLabel: TDF_Label, theGUID: Standard_GUID) -> TDF_Label: ...
	@overload
	def FindAnnotatedItemSubshape(self, theItemId: XCAFDoc_AssemblyItemId, theSubshapeIndex: int) -> TDF_Label: ...
	@overload
	def FindAnnotatedItemSubshape(self, theItemLabel: TDF_Label, theSubshapeIndex: int) -> TDF_Label: ...
	def GetAnnotatedItems(self, theLabels: TDF_LabelSequence) -> None: ...
	def GetAnnotatedItemsLabel(self) -> TDF_Label: ...
	@overload
	def GetAttrNotes(self, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID, theNoteLabels: TDF_LabelSequence) -> int: ...
	@overload
	def GetAttrNotes(self, theItemLabel: TDF_Label, theGUID: Standard_GUID, theNoteLabels: TDF_LabelSequence) -> int: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	@overload
	def GetNotes(self, theNoteLabels: TDF_LabelSequence) -> None: ...
	@overload
	def GetNotes(self, theItemId: XCAFDoc_AssemblyItemId, theNoteLabels: TDF_LabelSequence) -> int: ...
	@overload
	def GetNotes(self, theItemLabel: TDF_Label, theNoteLabels: TDF_LabelSequence) -> int: ...
	def GetNotesLabel(self) -> TDF_Label: ...
	def GetOrphanNotes(self, theNoteLabels: TDF_LabelSequence) -> None: ...
	def GetSubshapeNotes(self, theItemId: XCAFDoc_AssemblyItemId, theSubshapeIndex: int, theNoteLabels: TDF_LabelSequence) -> int: ...
	def ID(self) -> Standard_GUID: ...
	@overload
	def IsAnnotatedItem(self, theItemId: XCAFDoc_AssemblyItemId) -> bool: ...
	@overload
	def IsAnnotatedItem(self, theItemLabel: TDF_Label) -> bool: ...
	def NbAnnotatedItems(self) -> int: ...
	def NbNotes(self) -> int: ...
	def NbOrphanNotes(self) -> int: ...
	@overload
	def RemoveAllAttrNotes(self, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveAllAttrNotes(self, theItemLabel: TDF_Label, theGUID: Standard_GUID, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveAllNotes(self, theItemId: XCAFDoc_AssemblyItemId, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveAllNotes(self, theItemLabel: TDF_Label, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	def RemoveAllSubshapeNotes(self, theItemId: XCAFDoc_AssemblyItemId, theSubshapeIndex: int, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveAttrNote(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theGUID: Standard_GUID, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveAttrNote(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label, theGUID: Standard_GUID, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveNote(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveNote(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveSubshapeNote(self, theNoteLabel: TDF_Label, theItemId: XCAFDoc_AssemblyItemId, theSubshapeIndex: int, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@overload
	def RemoveSubshapeNote(self, theNoteLabel: TDF_Label, theItemLabel: TDF_Label, theSubshapeIndex: int, theDelIfOrphan: Optional[bool] = False) -> bool: ...
	@staticmethod
	def Set(theLabel: TDF_Label) -> XCAFDoc_NotesTool: ...

class XCAFDoc_ShapeMapTool(TDF_Attribute):
	def __init__(self) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetMap(self) -> TopTools_IndexedMapOfShape: ...
	def ID(self) -> Standard_GUID: ...
	def IsSubShape(self, sub: TopoDS_Shape) -> bool: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_ShapeMapTool: ...
	def SetShape(self, S: TopoDS_Shape) -> None: ...

class XCAFDoc_ShapeTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@overload
	def AddComponent(self, assembly: TDF_Label, comp: TDF_Label, Loc: TopLoc_Location) -> TDF_Label: ...
	@overload
	def AddComponent(self, assembly: TDF_Label, comp: TopoDS_Shape, expand: Optional[bool] = False) -> TDF_Label: ...
	def AddShape(self, S: TopoDS_Shape, makeAssembly: Optional[bool] = True, makePrepare: Optional[bool] = True) -> TDF_Label: ...
	@overload
	def AddSubShape(self, shapeL: TDF_Label, sub: TopoDS_Shape) -> TDF_Label: ...
	@overload
	def AddSubShape(self, shapeL: TDF_Label, sub: TopoDS_Shape, addedSubShapeL: TDF_Label) -> bool: ...
	@staticmethod
	def AutoNaming() -> bool: ...
	def BaseLabel(self) -> TDF_Label: ...
	def ComputeShapes(self, L: TDF_Label) -> None: ...
	def ComputeSimpleShapes(self) -> None: ...
	def Expand(self, Shape: TDF_Label) -> bool: ...
	def FindComponent(self, theShape: TopoDS_Shape, Labels: TDF_LabelSequence) -> bool: ...
	def FindMainShape(self, sub: TopoDS_Shape) -> TDF_Label: ...
	def FindMainShapeUsingMap(self, sub: TopoDS_Shape) -> TDF_Label: ...
	@staticmethod
	def FindSHUO(Labels: TDF_LabelSequence, theSHUOAttr: XCAFDoc_GraphNode) -> bool: ...
	@overload
	def FindShape(self, S: TopoDS_Shape, L: TDF_Label, findInstance: Optional[bool] = False) -> bool: ...
	@overload
	def FindShape(self, S: TopoDS_Shape, findInstance: Optional[bool] = False) -> TDF_Label: ...
	def FindSubShape(self, shapeL: TDF_Label, sub: TopoDS_Shape, L: TDF_Label) -> bool: ...
	@staticmethod
	def GetAllComponentSHUO(CompLabel: TDF_Label, SHUOAttrs: TDF_AttributeSequence) -> bool: ...
	def GetAllSHUOInstances(self, theSHUO: XCAFDoc_GraphNode, theSHUOShapeSeq: TopTools_SequenceOfShape) -> bool: ...
	@staticmethod
	def GetComponents(L: TDF_Label, Labels: TDF_LabelSequence, getsubchilds: Optional[bool] = False) -> bool: ...
	@staticmethod
	def GetExternRefs(L: TDF_Label, SHAS: TColStd_SequenceOfHAsciiString) -> None: ...
	def GetFreeShapes(self, FreeLabels: TDF_LabelSequence) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	@staticmethod
	def GetLocation(L: TDF_Label) -> TopLoc_Location: ...
	@overload
	def GetNamedProperties(self, theLabel: TDF_Label, theToCreate: Optional[bool] = False) -> TDataStd_NamedData: ...
	@overload
	def GetNamedProperties(self, theShape: TopoDS_Shape, theToCreate: Optional[bool] = False) -> TDataStd_NamedData: ...
	@staticmethod
	def GetReferredShape(L: TDF_Label, Label: TDF_Label) -> bool: ...
	@staticmethod
	def GetSHUO(SHUOLabel: TDF_Label, aSHUOAttr: XCAFDoc_GraphNode) -> bool: ...
	def GetSHUOInstance(self, theSHUO: XCAFDoc_GraphNode) -> TopoDS_Shape: ...
	@staticmethod
	def GetSHUONextUsage(UpperUsageL: TDF_Label, Labels: TDF_LabelSequence) -> bool: ...
	@staticmethod
	def GetSHUOUpperUsage(NextUsageL: TDF_Label, Labels: TDF_LabelSequence) -> bool: ...
	@overload
	@staticmethod
	def GetShape(L: TDF_Label, S: TopoDS_Shape) -> bool: ...
	@overload
	@staticmethod
	def GetShape(L: TDF_Label) -> TopoDS_Shape: ...
	def GetShapes(self, Labels: TDF_LabelSequence) -> None: ...
	@staticmethod
	def GetSubShapes(L: TDF_Label, Labels: TDF_LabelSequence) -> bool: ...
	@staticmethod
	def GetUsers(L: TDF_Label, Labels: TDF_LabelSequence, getsubchilds: Optional[bool] = False) -> int: ...
	def ID(self) -> Standard_GUID: ...
	def Init(self) -> None: ...
	@staticmethod
	def IsAssembly(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsComponent(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsCompound(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsExternRef(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsFree(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsReference(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsShape(L: TDF_Label) -> bool: ...
	@staticmethod
	def IsSimpleShape(L: TDF_Label) -> bool: ...
	@overload
	@staticmethod
	def IsSubShape(L: TDF_Label) -> bool: ...
	@overload
	def IsSubShape(self, shapeL: TDF_Label, sub: TopoDS_Shape) -> bool: ...
	def IsTopLevel(self, L: TDF_Label) -> bool: ...
	@staticmethod
	def NbComponents(L: TDF_Label, getsubchilds: Optional[bool] = False) -> int: ...
	def NewShape(self) -> TDF_Label: ...
	def RemoveComponent(self, comp: TDF_Label) -> None: ...
	def RemoveSHUO(self, SHUOLabel: TDF_Label) -> bool: ...
	def RemoveShape(self, L: TDF_Label, removeCompletely: Optional[bool] = True) -> bool: ...
	def Search(self, S: TopoDS_Shape, L: TDF_Label, findInstance: Optional[bool] = True, findComponent: Optional[bool] = True, findSubshape: Optional[bool] = True) -> bool: ...
	def SearchUsingMap(self, S: TopoDS_Shape, L: TDF_Label, findWithoutLoc: bool, findSubshape: bool) -> bool: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_ShapeTool: ...
	@staticmethod
	def SetAutoNaming(V: bool) -> None: ...
	@overload
	def SetExternRefs(self, SHAS: TColStd_SequenceOfHAsciiString) -> TDF_Label: ...
	@overload
	def SetExternRefs(self, L: TDF_Label, SHAS: TColStd_SequenceOfHAsciiString) -> None: ...
	def SetInstanceSHUO(self, theShape: TopoDS_Shape) -> XCAFDoc_GraphNode: ...
	def SetSHUO(self, Labels: TDF_LabelSequence, MainSHUOAttr: XCAFDoc_GraphNode) -> bool: ...
	def SetShape(self, L: TDF_Label, S: TopoDS_Shape) -> None: ...
	def UpdateAssemblies(self) -> None: ...

class XCAFDoc_View(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetObject(self) -> XCAFView_Object: ...
	def ID(self) -> Standard_GUID: ...
	@staticmethod
	def Set(theLabel: TDF_Label) -> XCAFDoc_View: ...
	def SetObject(self, theViewObject: XCAFView_Object) -> None: ...

class XCAFDoc_ViewTool(TDataStd_GenericEmpty):
	def __init__(self) -> None: ...
	def AddView(self) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetRefAnnotationLabel(self, theViewL: TDF_Label, theAnnotationLabels: TDF_LabelSequence) -> bool: ...
	def GetRefClippingPlaneLabel(self, theViewL: TDF_Label, theClippingPlaneLabels: TDF_LabelSequence) -> bool: ...
	def GetRefGDTLabel(self, theViewL: TDF_Label, theGDTLabels: TDF_LabelSequence) -> bool: ...
	def GetRefNoteLabel(self, theViewL: TDF_Label, theNoteLabels: TDF_LabelSequence) -> bool: ...
	def GetRefShapeLabel(self, theViewL: TDF_Label, theShapeLabels: TDF_LabelSequence) -> bool: ...
	def GetViewLabels(self, theLabels: TDF_LabelSequence) -> None: ...
	def GetViewLabelsForAnnotation(self, theAnnotationL: TDF_Label, theViews: TDF_LabelSequence) -> bool: ...
	def GetViewLabelsForClippingPlane(self, theClippingPlaneL: TDF_Label, theViews: TDF_LabelSequence) -> bool: ...
	def GetViewLabelsForGDT(self, theGDTL: TDF_Label, theViews: TDF_LabelSequence) -> bool: ...
	def GetViewLabelsForNote(self, theNoteL: TDF_Label, theViews: TDF_LabelSequence) -> bool: ...
	def GetViewLabelsForShape(self, theShapeL: TDF_Label, theViews: TDF_LabelSequence) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def IsLocked(self, theViewL: TDF_Label) -> bool: ...
	def IsView(self, theLabel: TDF_Label) -> bool: ...
	def Lock(self, theViewL: TDF_Label) -> None: ...
	def RemoveView(self, theViewL: TDF_Label) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_ViewTool: ...
	def SetClippingPlanes(self, theClippingPlaneLabels: TDF_LabelSequence, theViewL: TDF_Label) -> None: ...
	@overload
	def SetView(self, theShapes: TDF_LabelSequence, theGDTs: TDF_LabelSequence, theClippingPlanes: TDF_LabelSequence, theNotes: TDF_LabelSequence, theAnnotations: TDF_LabelSequence, theViewL: TDF_Label) -> None: ...
	@overload
	def SetView(self, theShapes: TDF_LabelSequence, theGDTs: TDF_LabelSequence, theClippingPlanes: TDF_LabelSequence, theViewL: TDF_Label) -> None: ...
	@overload
	def SetView(self, theShapes: TDF_LabelSequence, theGDTs: TDF_LabelSequence, theViewL: TDF_Label) -> None: ...
	def Unlock(self, theViewL: TDF_Label) -> None: ...

class XCAFDoc_VisMaterial(TDF_Attribute):
	def __init__(self) -> None: ...
	def AlphaCutOff(self) -> float: ...
	def AlphaMode(self) -> Graphic3d_AlphaMode: ...
	def BaseColor(self) -> Quantity_ColorRGBA: ...
	def CommonMaterial(self) -> XCAFDoc_VisMaterialCommon: ...
	def ConvertToCommonMaterial(self) -> XCAFDoc_VisMaterialCommon: ...
	def ConvertToPbrMaterial(self) -> XCAFDoc_VisMaterialPBR: ...
	def FillAspect(self, theAspect: Graphic3d_Aspects) -> None: ...
	def FillMaterialAspect(self, theAspect: Graphic3d_MaterialAspect) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def HasCommonMaterial(self) -> bool: ...
	def HasPbrMaterial(self) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def IsDoubleSided(self) -> bool: ...
	def IsEmpty(self) -> False: ...
	def IsEqual(self, theOther: XCAFDoc_VisMaterial) -> bool: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, theInto: TDF_Attribute, theRelTable: TDF_RelocationTable) -> None: ...
	def PbrMaterial(self) -> XCAFDoc_VisMaterialPBR: ...
	def RawName(self) -> TCollection_HAsciiString: ...
	def Restore(self, theWith: TDF_Attribute) -> None: ...
	def SetAlphaMode(self, theMode: Graphic3d_AlphaMode, theCutOff: Optional[float] = 0.5) -> None: ...
	def SetCommonMaterial(self, theMaterial: XCAFDoc_VisMaterialCommon) -> None: ...
	def SetDoubleSided(self, theIsDoubleSided: bool) -> None: ...
	def SetPbrMaterial(self, theMaterial: XCAFDoc_VisMaterialPBR) -> None: ...
	def SetRawName(self, theName: TCollection_HAsciiString) -> None: ...
	def UnsetCommonMaterial(self) -> None: ...
	def UnsetPbrMaterial(self) -> None: ...

class XCAFDoc_VisMaterialCommon:
	def __init__(self) -> None: ...
	def IsEqual(self, theOther: XCAFDoc_VisMaterialCommon) -> bool: ...

class XCAFDoc_VisMaterialPBR:
	def __init__(self) -> None: ...
	def IsEqual(self, theOther: XCAFDoc_VisMaterialPBR) -> bool: ...

class XCAFDoc_VisMaterialTool(TDF_Attribute):
	def __init__(self) -> None: ...
	@overload
	def AddMaterial(self, theMat: XCAFDoc_VisMaterial, theName: TCollection_AsciiString) -> TDF_Label: ...
	@overload
	def AddMaterial(self, theName: TCollection_AsciiString) -> TDF_Label: ...
	def BaseLabel(self) -> TDF_Label: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetMaterial(self, theMatLabel: TDF_Label) -> XCAFDoc_VisMaterial: ...
	def GetMaterials(self, Labels: TDF_LabelSequence) -> None: ...
	@overload
	@staticmethod
	def GetShapeMaterial(theShapeLabel: TDF_Label, theMaterialLabel: TDF_Label) -> bool: ...
	@overload
	def GetShapeMaterial(self, theShapeLabel: TDF_Label) -> XCAFDoc_VisMaterial: ...
	@overload
	def GetShapeMaterial(self, theShape: TopoDS_Shape, theMaterialLabel: TDF_Label) -> bool: ...
	@overload
	def GetShapeMaterial(self, theShape: TopoDS_Shape) -> XCAFDoc_VisMaterial: ...
	def ID(self) -> Standard_GUID: ...
	def IsMaterial(self, theLabel: TDF_Label) -> bool: ...
	@overload
	def IsSetShapeMaterial(self, theLabel: TDF_Label) -> bool: ...
	@overload
	def IsSetShapeMaterial(self, theShape: TopoDS_Shape) -> bool: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def RemoveMaterial(self, theLabel: TDF_Label) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> XCAFDoc_VisMaterialTool: ...
	@overload
	def SetShapeMaterial(self, theShapeLabel: TDF_Label, theMaterialLabel: TDF_Label) -> None: ...
	@overload
	def SetShapeMaterial(self, theShape: TopoDS_Shape, theMaterialLabel: TDF_Label) -> bool: ...
	def ShapeTool(self) -> XCAFDoc_ShapeTool: ...
	@overload
	def UnSetShapeMaterial(self, theShapeLabel: TDF_Label) -> None: ...
	@overload
	def UnSetShapeMaterial(self, theShape: TopoDS_Shape) -> bool: ...

class XCAFDoc_Volume(TDataStd_Real):
	def __init__(self) -> None: ...
	@overload
	def Get(self) -> float: ...
	@overload
	@staticmethod
	def Get(label: TDF_Label) -> Tuple[bool, float]: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	@overload
	def Set(self, vol: float) -> None: ...
	@overload
	@staticmethod
	def Set(label: TDF_Label, vol: float) -> XCAFDoc_Volume: ...

class XCAFDoc_NoteBinData(XCAFDoc_Note):
	def __init__(self) -> None: ...
	def Data(self) -> TColStd_HArray1OfByte: ...
	@staticmethod
	def Get(theLabel: TDF_Label) -> XCAFDoc_NoteBinData: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def MIMEtype(self) -> TCollection_AsciiString: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, theAttrInto: TDF_Attribute, theRT: TDF_RelocationTable) -> None: ...
	def Restore(self, theAttrFrom: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theFile: OSD_File) -> XCAFDoc_NoteBinData: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theData: TColStd_HArray1OfByte) -> XCAFDoc_NoteBinData: ...
	@overload
	def Set(self, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theFile: OSD_File) -> bool: ...
	@overload
	def Set(self, theTitle: TCollection_ExtendedString, theMIMEtype: TCollection_AsciiString, theData: TColStd_HArray1OfByte) -> None: ...
	def Size(self) -> int: ...
	def Title(self) -> TCollection_ExtendedString: ...

class XCAFDoc_NoteComment(XCAFDoc_Note):
	def __init__(self) -> None: ...
	def Comment(self) -> TCollection_ExtendedString: ...
	@staticmethod
	def Get(theLabel: TDF_Label) -> XCAFDoc_NoteComment: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, theAttrInto: TDF_Attribute, theRT: TDF_RelocationTable) -> None: ...
	def Restore(self, theAttrFrom: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(theLabel: TDF_Label, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theComment: TCollection_ExtendedString) -> XCAFDoc_NoteComment: ...
	@overload
	def Set(self, theComment: TCollection_ExtendedString) -> None: ...

class XCAFDoc_NoteBalloon(XCAFDoc_NoteComment):
	def __init__(self) -> None: ...
	@staticmethod
	def Get(theLabel: TDF_Label) -> XCAFDoc_NoteBalloon: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	@staticmethod
	def Set(theLabel: TDF_Label, theUserName: TCollection_ExtendedString, theTimeStamp: TCollection_ExtendedString, theComment: TCollection_ExtendedString) -> XCAFDoc_NoteBalloon: ...

#classnotwrapped
class XCAFDoc_GeomTolerance: ...

# harray1 classes
# harray2 classes
# hsequence classes

xcafdoc_AssemblyGUID = xcafdoc.AssemblyGUID
xcafdoc_ColorByLayerGUID = xcafdoc.ColorByLayerGUID
xcafdoc_ColorRefGUID = xcafdoc.ColorRefGUID
xcafdoc_DatumRefGUID = xcafdoc.DatumRefGUID
xcafdoc_DatumTolRefGUID = xcafdoc.DatumTolRefGUID
xcafdoc_DimTolRefGUID = xcafdoc.DimTolRefGUID
xcafdoc_DimensionRefFirstGUID = xcafdoc.DimensionRefFirstGUID
xcafdoc_DimensionRefSecondGUID = xcafdoc.DimensionRefSecondGUID
xcafdoc_ExternRefGUID = xcafdoc.ExternRefGUID
xcafdoc_GeomToleranceRefGUID = xcafdoc.GeomToleranceRefGUID
xcafdoc_InvisibleGUID = xcafdoc.InvisibleGUID
xcafdoc_LayerRefGUID = xcafdoc.LayerRefGUID
xcafdoc_LockGUID = xcafdoc.LockGUID
xcafdoc_MaterialRefGUID = xcafdoc.MaterialRefGUID
xcafdoc_NoteRefGUID = xcafdoc.NoteRefGUID
xcafdoc_SHUORefGUID = xcafdoc.SHUORefGUID
xcafdoc_ShapeRefGUID = xcafdoc.ShapeRefGUID
xcafdoc_ViewRefAnnotationGUID = xcafdoc.ViewRefAnnotationGUID
xcafdoc_ViewRefGDTGUID = xcafdoc.ViewRefGDTGUID
xcafdoc_ViewRefGUID = xcafdoc.ViewRefGUID
xcafdoc_ViewRefNoteGUID = xcafdoc.ViewRefNoteGUID
xcafdoc_ViewRefPlaneGUID = xcafdoc.ViewRefPlaneGUID
xcafdoc_ViewRefShapeGUID = xcafdoc.ViewRefShapeGUID
xcafdoc_VisMaterialRefGUID = xcafdoc.VisMaterialRefGUID
XCAFDoc_Area_Get = XCAFDoc_Area.Get
XCAFDoc_Area_GetID = XCAFDoc_Area.GetID
XCAFDoc_Area_Set = XCAFDoc_Area.Set
XCAFDoc_AssemblyItemRef_Get = XCAFDoc_AssemblyItemRef.Get
XCAFDoc_AssemblyItemRef_GetID = XCAFDoc_AssemblyItemRef.GetID
XCAFDoc_AssemblyItemRef_Set = XCAFDoc_AssemblyItemRef.Set
XCAFDoc_AssemblyItemRef_Set = XCAFDoc_AssemblyItemRef.Set
XCAFDoc_AssemblyItemRef_Set = XCAFDoc_AssemblyItemRef.Set
XCAFDoc_Centroid_Get = XCAFDoc_Centroid.Get
XCAFDoc_Centroid_GetID = XCAFDoc_Centroid.GetID
XCAFDoc_Centroid_Set = XCAFDoc_Centroid.Set
XCAFDoc_ClippingPlaneTool_GetID = XCAFDoc_ClippingPlaneTool.GetID
XCAFDoc_ClippingPlaneTool_Set = XCAFDoc_ClippingPlaneTool.Set
XCAFDoc_Color_GetID = XCAFDoc_Color.GetID
XCAFDoc_Color_Set = XCAFDoc_Color.Set
XCAFDoc_Color_Set = XCAFDoc_Color.Set
XCAFDoc_Color_Set = XCAFDoc_Color.Set
XCAFDoc_Color_Set = XCAFDoc_Color.Set
XCAFDoc_ColorTool_AutoNaming = XCAFDoc_ColorTool.AutoNaming
XCAFDoc_ColorTool_GetColor = XCAFDoc_ColorTool.GetColor
XCAFDoc_ColorTool_GetID = XCAFDoc_ColorTool.GetID
XCAFDoc_ColorTool_Set = XCAFDoc_ColorTool.Set
XCAFDoc_ColorTool_SetAutoNaming = XCAFDoc_ColorTool.SetAutoNaming
XCAFDoc_Datum_GetID = XCAFDoc_Datum.GetID
XCAFDoc_Datum_Set = XCAFDoc_Datum.Set
XCAFDoc_Datum_Set = XCAFDoc_Datum.Set
XCAFDoc_DimTol_GetID = XCAFDoc_DimTol.GetID
XCAFDoc_DimTol_Set = XCAFDoc_DimTol.Set
XCAFDoc_DimTolTool_GetID = XCAFDoc_DimTolTool.GetID
XCAFDoc_DimTolTool_Set = XCAFDoc_DimTolTool.Set
XCAFDoc_Dimension_GetID = XCAFDoc_Dimension.GetID
XCAFDoc_Dimension_Set = XCAFDoc_Dimension.Set
XCAFDoc_DocumentTool_ClippingPlaneTool = XCAFDoc_DocumentTool.ClippingPlaneTool
XCAFDoc_DocumentTool_ClippingPlanesLabel = XCAFDoc_DocumentTool.ClippingPlanesLabel
XCAFDoc_DocumentTool_ColorTool = XCAFDoc_DocumentTool.ColorTool
XCAFDoc_DocumentTool_ColorsLabel = XCAFDoc_DocumentTool.ColorsLabel
XCAFDoc_DocumentTool_DGTsLabel = XCAFDoc_DocumentTool.DGTsLabel
XCAFDoc_DocumentTool_DimTolTool = XCAFDoc_DocumentTool.DimTolTool
XCAFDoc_DocumentTool_DocLabel = XCAFDoc_DocumentTool.DocLabel
XCAFDoc_DocumentTool_GetID = XCAFDoc_DocumentTool.GetID
XCAFDoc_DocumentTool_IsXCAFDocument = XCAFDoc_DocumentTool.IsXCAFDocument
XCAFDoc_DocumentTool_LayerTool = XCAFDoc_DocumentTool.LayerTool
XCAFDoc_DocumentTool_LayersLabel = XCAFDoc_DocumentTool.LayersLabel
XCAFDoc_DocumentTool_MaterialTool = XCAFDoc_DocumentTool.MaterialTool
XCAFDoc_DocumentTool_MaterialsLabel = XCAFDoc_DocumentTool.MaterialsLabel
XCAFDoc_DocumentTool_NotesLabel = XCAFDoc_DocumentTool.NotesLabel
XCAFDoc_DocumentTool_NotesTool = XCAFDoc_DocumentTool.NotesTool
XCAFDoc_DocumentTool_Set = XCAFDoc_DocumentTool.Set
XCAFDoc_DocumentTool_ShapeTool = XCAFDoc_DocumentTool.ShapeTool
XCAFDoc_DocumentTool_ShapesLabel = XCAFDoc_DocumentTool.ShapesLabel
XCAFDoc_DocumentTool_ViewTool = XCAFDoc_DocumentTool.ViewTool
XCAFDoc_DocumentTool_ViewsLabel = XCAFDoc_DocumentTool.ViewsLabel
XCAFDoc_DocumentTool_VisMaterialLabel = XCAFDoc_DocumentTool.VisMaterialLabel
XCAFDoc_DocumentTool_VisMaterialTool = XCAFDoc_DocumentTool.VisMaterialTool
XCAFDoc_Editor_Expand = XCAFDoc_Editor.Expand
XCAFDoc_Editor_Expand = XCAFDoc_Editor.Expand
XCAFDoc_GraphNode_Find = XCAFDoc_GraphNode.Find
XCAFDoc_GraphNode_GetDefaultGraphID = XCAFDoc_GraphNode.GetDefaultGraphID
XCAFDoc_GraphNode_Set = XCAFDoc_GraphNode.Set
XCAFDoc_GraphNode_Set = XCAFDoc_GraphNode.Set
XCAFDoc_LayerTool_GetID = XCAFDoc_LayerTool.GetID
XCAFDoc_LayerTool_Set = XCAFDoc_LayerTool.Set
XCAFDoc_Location_GetID = XCAFDoc_Location.GetID
XCAFDoc_Location_Set = XCAFDoc_Location.Set
XCAFDoc_Material_GetID = XCAFDoc_Material.GetID
XCAFDoc_Material_Set = XCAFDoc_Material.Set
XCAFDoc_MaterialTool_GetDensityForShape = XCAFDoc_MaterialTool.GetDensityForShape
XCAFDoc_MaterialTool_GetID = XCAFDoc_MaterialTool.GetID
XCAFDoc_MaterialTool_Set = XCAFDoc_MaterialTool.Set
XCAFDoc_Note_Get = XCAFDoc_Note.Get
XCAFDoc_Note_IsMine = XCAFDoc_Note.IsMine
XCAFDoc_NotesTool_GetID = XCAFDoc_NotesTool.GetID
XCAFDoc_NotesTool_Set = XCAFDoc_NotesTool.Set
XCAFDoc_ShapeMapTool_GetID = XCAFDoc_ShapeMapTool.GetID
XCAFDoc_ShapeMapTool_Set = XCAFDoc_ShapeMapTool.Set
XCAFDoc_ShapeTool_AutoNaming = XCAFDoc_ShapeTool.AutoNaming
XCAFDoc_ShapeTool_DumpShape = XCAFDoc_ShapeTool.DumpShape
XCAFDoc_ShapeTool_FindSHUO = XCAFDoc_ShapeTool.FindSHUO
XCAFDoc_ShapeTool_GetAllComponentSHUO = XCAFDoc_ShapeTool.GetAllComponentSHUO
XCAFDoc_ShapeTool_GetComponents = XCAFDoc_ShapeTool.GetComponents
XCAFDoc_ShapeTool_GetExternRefs = XCAFDoc_ShapeTool.GetExternRefs
XCAFDoc_ShapeTool_GetID = XCAFDoc_ShapeTool.GetID
XCAFDoc_ShapeTool_GetLocation = XCAFDoc_ShapeTool.GetLocation
XCAFDoc_ShapeTool_GetReferredShape = XCAFDoc_ShapeTool.GetReferredShape
XCAFDoc_ShapeTool_GetSHUO = XCAFDoc_ShapeTool.GetSHUO
XCAFDoc_ShapeTool_GetSHUONextUsage = XCAFDoc_ShapeTool.GetSHUONextUsage
XCAFDoc_ShapeTool_GetSHUOUpperUsage = XCAFDoc_ShapeTool.GetSHUOUpperUsage
XCAFDoc_ShapeTool_GetShape = XCAFDoc_ShapeTool.GetShape
XCAFDoc_ShapeTool_GetShape = XCAFDoc_ShapeTool.GetShape
XCAFDoc_ShapeTool_GetSubShapes = XCAFDoc_ShapeTool.GetSubShapes
XCAFDoc_ShapeTool_GetUsers = XCAFDoc_ShapeTool.GetUsers
XCAFDoc_ShapeTool_IsAssembly = XCAFDoc_ShapeTool.IsAssembly
XCAFDoc_ShapeTool_IsComponent = XCAFDoc_ShapeTool.IsComponent
XCAFDoc_ShapeTool_IsCompound = XCAFDoc_ShapeTool.IsCompound
XCAFDoc_ShapeTool_IsExternRef = XCAFDoc_ShapeTool.IsExternRef
XCAFDoc_ShapeTool_IsFree = XCAFDoc_ShapeTool.IsFree
XCAFDoc_ShapeTool_IsReference = XCAFDoc_ShapeTool.IsReference
XCAFDoc_ShapeTool_IsShape = XCAFDoc_ShapeTool.IsShape
XCAFDoc_ShapeTool_IsSimpleShape = XCAFDoc_ShapeTool.IsSimpleShape
XCAFDoc_ShapeTool_IsSubShape = XCAFDoc_ShapeTool.IsSubShape
XCAFDoc_ShapeTool_NbComponents = XCAFDoc_ShapeTool.NbComponents
XCAFDoc_ShapeTool_Set = XCAFDoc_ShapeTool.Set
XCAFDoc_ShapeTool_SetAutoNaming = XCAFDoc_ShapeTool.SetAutoNaming
XCAFDoc_View_GetID = XCAFDoc_View.GetID
XCAFDoc_View_Set = XCAFDoc_View.Set
XCAFDoc_ViewTool_GetID = XCAFDoc_ViewTool.GetID
XCAFDoc_ViewTool_Set = XCAFDoc_ViewTool.Set
XCAFDoc_VisMaterial_GetID = XCAFDoc_VisMaterial.GetID
XCAFDoc_VisMaterialTool_GetID = XCAFDoc_VisMaterialTool.GetID
XCAFDoc_VisMaterialTool_GetShapeMaterial = XCAFDoc_VisMaterialTool.GetShapeMaterial
XCAFDoc_VisMaterialTool_Set = XCAFDoc_VisMaterialTool.Set
XCAFDoc_Volume_Get = XCAFDoc_Volume.Get
XCAFDoc_Volume_GetID = XCAFDoc_Volume.GetID
XCAFDoc_Volume_Set = XCAFDoc_Volume.Set
XCAFDoc_NoteBinData_Get = XCAFDoc_NoteBinData.Get
XCAFDoc_NoteBinData_GetID = XCAFDoc_NoteBinData.GetID
XCAFDoc_NoteBinData_Set = XCAFDoc_NoteBinData.Set
XCAFDoc_NoteBinData_Set = XCAFDoc_NoteBinData.Set
XCAFDoc_NoteComment_Get = XCAFDoc_NoteComment.Get
XCAFDoc_NoteComment_GetID = XCAFDoc_NoteComment.GetID
XCAFDoc_NoteComment_Set = XCAFDoc_NoteComment.Set
XCAFDoc_NoteBalloon_Get = XCAFDoc_NoteBalloon.Get
XCAFDoc_NoteBalloon_GetID = XCAFDoc_NoteBalloon.GetID
XCAFDoc_NoteBalloon_Set = XCAFDoc_NoteBalloon.Set
