/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;

class IdentityFile
implements Identity {
    private JSch jsch;
    private KeyPair kpair;
    private String identity;

    static IdentityFile newInstance(String string, String string2, JSch jSch) throws JSchException {
        KeyPair keyPair = KeyPair.load(jSch, string, string2);
        return new IdentityFile(jSch, string, keyPair);
    }

    static IdentityFile newInstance(String string, byte[] byArray, byte[] byArray2, JSch jSch) throws JSchException {
        KeyPair keyPair = KeyPair.load(jSch, byArray, byArray2);
        return new IdentityFile(jSch, string, keyPair);
    }

    private IdentityFile(JSch jSch, String string, KeyPair keyPair) throws JSchException {
        this.jsch = jSch;
        this.identity = string;
        this.kpair = keyPair;
    }

    @Override
    public boolean setPassphrase(byte[] byArray) throws JSchException {
        return this.kpair.decrypt(byArray);
    }

    @Override
    public byte[] getPublicKeyBlob() {
        return this.kpair.getPublicKeyBlob();
    }

    @Override
    public byte[] getSignature(byte[] byArray) {
        return this.kpair.getSignature(byArray);
    }

    @Override
    public boolean decrypt() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getAlgName() {
        return new String(this.kpair.getKeyTypeName());
    }

    @Override
    public String getName() {
        return this.identity;
    }

    @Override
    public boolean isEncrypted() {
        return this.kpair.isEncrypted();
    }

    @Override
    public void clear() {
        this.kpair.dispose();
        this.kpair = null;
    }

    public KeyPair getKeyPair() {
        return this.kpair;
    }
}

