/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.sisu.inject.MildKeys;

class MildValues<K, V>
implements Map<K, V> {
    final ReferenceQueue<V> queue = new ReferenceQueue();
    final Map<K, Reference<V>> map;
    private final boolean soft;

    MildValues(Map<K, Reference<V>> map2, boolean soft) {
        this.map = map2;
        this.soft = soft;
    }

    @Override
    public final boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(MildValues.tempValue(value));
    }

    @Override
    public final V get(Object key2) {
        Reference<V> ref2 = this.map.get(key2);
        return ref2 != null ? (V)ref2.get() : null;
    }

    @Override
    public final V put(K key2, V value) {
        this.compact();
        Reference<V> ref2 = this.map.put(key2, this.mildValue(key2, value));
        return ref2 != null ? (V)ref2.get() : null;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e2 : m.entrySet()) {
            this.map.put(e2.getKey(), this.mildValue(e2.getKey(), e2.getValue()));
        }
    }

    @Override
    public final V remove(Object key2) {
        this.compact();
        Reference<V> ref2 = this.map.remove(key2);
        return ref2 != null ? (V)ref2.get() : null;
    }

    @Override
    public final void clear() {
        this.map.clear();
        this.compact();
    }

    @Override
    public final boolean isEmpty() {
        this.compact();
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        this.compact();
        return this.map.size();
    }

    @Override
    public final Set<K> keySet() {
        this.compact();
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        this.compact();
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueItr();
            }

            @Override
            public int size() {
                return MildValues.this.map.size();
            }
        };
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryItr();
            }

            @Override
            public int size() {
                return MildValues.this.map.size();
            }
        };
    }

    final Reference<V> mildValue(K key2, V value) {
        return this.soft ? new Soft<K, V>(key2, value, this.queue) : new Weak<K, V>(key2, value, this.queue);
    }

    static final <V> Reference<V> tempValue(V value) {
        return new Weak<Object, V>(null, value, null);
    }

    void compact() {
        Reference<V> ref2;
        while ((ref2 = this.queue.poll()) != null) {
            Object key2 = ((InverseMapping)((Object)ref2)).key();
            if (this.map.get(key2) != ref2) continue;
            this.map.remove(key2);
        }
    }

    final class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Reference<V>>> itr;
        private Map.Entry<K, Reference<V>> nextEntry;
        private V nextValue;

        EntryItr() {
            this.itr = MildValues.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextValue == null && this.itr.hasNext()) {
                this.nextEntry = this.itr.next();
                this.nextValue = this.nextEntry.getValue().get();
            }
            return this.nextValue != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                StrongEntry entry = new StrongEntry(this.nextEntry, this.nextValue);
                this.nextEntry = null;
                this.nextValue = null;
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static interface InverseMapping {
        public Object key();
    }

    private static final class Soft<K, V>
    extends MildKeys.Soft<V>
    implements InverseMapping {
        private final K key;

        Soft(K key2, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key2;
        }

        @Override
        public Object key() {
            return this.key;
        }
    }

    final class StrongEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, Reference<V>> entry;
        private V value;

        StrongEntry(Map.Entry<K, Reference<V>> entry, V value) {
            this.entry = entry;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = this.value;
            this.entry.setValue(MildValues.this.mildValue(this.getKey(), newValue));
            this.value = newValue;
            return oldValue;
        }
    }

    final class ValueItr
    implements Iterator<V> {
        private final Iterator<Reference<V>> itr;
        private V nextValue;

        ValueItr() {
            this.itr = MildValues.this.map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextValue == null && this.itr.hasNext()) {
                this.nextValue = this.itr.next().get();
            }
            return this.nextValue != null;
        }

        @Override
        public V next() {
            if (this.hasNext()) {
                Object value = this.nextValue;
                this.nextValue = null;
                return value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static final class Weak<K, V>
    extends MildKeys.Weak<V>
    implements InverseMapping {
        private final K key;

        Weak(K key2, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key2;
        }

        @Override
        public Object key() {
            return this.key;
        }
    }
}

