/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import esmska.data.Config;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class GatewayUpdateInfo {
    private String name;
    private String fileName;
    private String version;
    private String minProgramVersion;
    private URL downloadUrl;
    private URL iconUrl;

    public GatewayUpdateInfo(String name, String fileName, String version, String minProgramVersion, String downloadUrl, String iconUrl) throws MalformedURLException {
        Validate.notEmpty(name);
        Validate.notEmpty(fileName);
        Validate.notEmpty(version);
        Validate.notEmpty(minProgramVersion);
        Validate.notEmpty(downloadUrl);
        this.name = name;
        this.fileName = fileName;
        this.version = version;
        this.minProgramVersion = minProgramVersion;
        this.downloadUrl = new URL(downloadUrl);
        this.iconUrl = StringUtils.isNotEmpty(iconUrl) ? new URL(iconUrl) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getMinProgramVersion() {
        return this.minProgramVersion;
    }

    public URL getIconUrl() {
        return this.iconUrl;
    }

    public boolean canBeUsed() {
        return Config.compareProgramVersions(Config.getLatestVersion(), this.minProgramVersion) >= 0;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("fileName", this.fileName).append("version", this.version).append("minProgramVersion", this.minProgramVersion).append("downloadUrl", this.downloadUrl).append("iconUrl", this.iconUrl).toString();
    }
}

