/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;

public final class AFPResourceAccessor {
    private static final Log log = LogFactory.getLog(AFPResourceAccessor.class);
    private final InternalResourceResolver resourceResolver;
    private final URI baseURI;
    private final URIResolver uriResolver;

    public AFPResourceAccessor(InternalResourceResolver resourceResolver, String baseURI) {
        URIResolver uriResolver;
        this.resourceResolver = resourceResolver;
        URI actualBaseURI = null;
        if (baseURI == null) {
            actualBaseURI = null;
            uriResolver = new NullBaseURIResolver();
        } else {
            try {
                actualBaseURI = InternalResourceResolver.getBaseURI(baseURI);
                uriResolver = new BaseURIResolver();
            }
            catch (URISyntaxException use) {
                log.error((Object)("The URI given \"" + baseURI + "\" is invalid: " + use.getMessage()));
                actualBaseURI = null;
                uriResolver = new NullBaseURIResolver();
            }
        }
        this.baseURI = actualBaseURI;
        this.uriResolver = uriResolver;
    }

    public AFPResourceAccessor(InternalResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        return this.resourceResolver.getResource(this.uriResolver.resolveURI(uri));
    }

    public URI resolveURI(String uri) {
        return this.uriResolver.resolveURI(uri);
    }

    private static final class NullBaseURIResolver
    implements URIResolver {
        private NullBaseURIResolver() {
        }

        @Override
        public URI resolveURI(URI uri) {
            return uri;
        }

        @Override
        public URI resolveURI(String uri) {
            return URI.create("./" + uri.trim());
        }
    }

    private final class BaseURIResolver
    implements URIResolver {
        private BaseURIResolver() {
        }

        @Override
        public URI resolveURI(URI uri) {
            return AFPResourceAccessor.this.baseURI.resolve(uri);
        }

        @Override
        public URI resolveURI(String uri) {
            return AFPResourceAccessor.this.baseURI.resolve(uri.trim());
        }
    }

    private static interface URIResolver {
        public URI resolveURI(URI var1);

        public URI resolveURI(String var1);
    }
}

