/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.function.FieldListModel;
import tim.prune.undo.UndoDeleteFieldValues;

public class DeleteFieldValues
extends GenericFunction {
    private JDialog _dialog = null;
    private JList<String> _fieldList = null;
    private FieldListModel _listModel = null;
    private JButton _okButton = null;

    public DeleteFieldValues(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletefieldvalues";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.initDialog();
        if (this._listModel.getSize() < 1) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.deletefieldvalues.nofields");
        } else {
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.deletefieldvalues.intro")), "North");
        this._fieldList = new JList<String>(new String[]{"First field", "Second field"});
        this._fieldList.setSelectionMode(0);
        this._fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DeleteFieldValues.this._okButton.setEnabled(DeleteFieldValues.this._fieldList.getSelectedIndex() >= 0);
            }
        });
        jPanel.add((Component)new JScrollPane(this._fieldList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteFieldValues.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel2.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteFieldValues.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void initDialog() {
        this._listModel = new FieldListModel();
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        Track track = this._app.getTrackInfo().getTrack();
        FieldList fieldList = track.getFieldList();
        int n3 = 0;
        while (n3 < fieldList.getNumFields()) {
            Field field = fieldList.getField(n3);
            if (field != Field.LATITUDE && field != Field.LONGITUDE && track.hasData(field, n, n2)) {
                this._listModel.addField(field);
            }
            ++n3;
        }
        this._fieldList.setModel(this._listModel);
        this._fieldList.clearSelection();
        this._okButton.setEnabled(false);
    }

    private void finish() {
        Field field = this._listModel.getField(this._fieldList.getSelectedIndex());
        if (field != null) {
            UndoDeleteFieldValues undoDeleteFieldValues = new UndoDeleteFieldValues(this._app.getTrackInfo(), field);
            int n = this._app.getTrackInfo().getSelection().getStart();
            int n2 = this._app.getTrackInfo().getSelection().getEnd();
            Track track = this._app.getTrackInfo().getTrack();
            int n3 = n;
            while (n3 <= n2) {
                track.getPoint(n3).setFieldValue(field, null, false);
                ++n3;
            }
            this._dialog.dispose();
            this._app.getTrackInfo().getSelection().markInvalid();
            UpdateMessageBroker.informSubscribers((byte)2);
            this._app.completeFunction(undoDeleteFieldValues, I18nManager.getText("confirm.deletefieldvalues"));
        }
    }
}

