/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.cache;

import java.io.File;
import tim.prune.function.cache.RowInfo;

public class TileSet {
    private RowInfo _rowInfo = null;
    private String _path = null;
    private String _usedBy = null;

    public TileSet(File file, String string, String string2) {
        this._path = string;
        this._usedBy = string2;
        this._rowInfo = new RowInfo();
        if (file != null && file.exists() && file.isDirectory() && file.canRead()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2 != null && file2.exists() && file2.isDirectory() && file2.canRead() && TileSet.isNumeric(file2.getName())) {
                    RowInfo rowInfo = TileSet.makeRowInfo(file2);
                    this._rowInfo.addRow(rowInfo);
                }
                ++n2;
            }
        }
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNumericUntilDot(String string) {
        if (string == null) return false;
        if (string.equals("")) return false;
        if (string.charAt(0) == '.') {
            return false;
        }
        try {
            int n = 46;
            int n2 = 0;
            do {
                if ((n = (int)string.charAt(n2)) == 46) {
                    return true;
                }
                if (n < 48) return false;
                if (n > 57) {
                    return false;
                }
                ++n2;
            } while (n != 0);
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static RowInfo makeRowInfo(File file) {
        RowInfo rowInfo = new RowInfo();
        rowInfo.setZoom(Integer.parseInt(file.getName()));
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2 != null && file2.exists() && file2.isDirectory() && file2.canRead() && TileSet.isNumeric(file2.getName())) {
                File[] fileArray2 = file2.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file3 = fileArray2[n4];
                    if (file3 != null && file3.exists() && file3.isFile() && file3.canRead() && TileSet.isNumericUntilDot(file3.getName())) {
                        rowInfo.addTile(file3.length());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return rowInfo;
    }

    public RowInfo getRowInfo() {
        return this._rowInfo;
    }

    public String getPath() {
        return this._path;
    }

    public String getUsedBy() {
        return this._usedBy;
    }
}

