/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Color;
import java.awt.image.BufferedImage;

public abstract class MapUtils {
    public static double getXFromLongitude(double d) {
        return (d + 180.0) / 360.0;
    }

    public static double getYFromLatitude(double d) {
        return (1.0 - Math.log(Math.tan(d * Math.PI / 180.0) + 1.0 / Math.cos(d * Math.PI / 180.0)) / Math.PI) / 2.0;
    }

    public static double getLongitudeFromX(double d) {
        double d2 = (d % 1.0 + 1.0) % 1.0;
        return d2 * 360.0 - 180.0;
    }

    public static double getLatitudeFromY(double d) {
        double d2 = Math.PI * (1.0 - 2.0 * d);
        return 57.29577951308232 * Math.atan(0.5 * (Math.exp(d2) - Math.exp(-d2)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean overlapsPoints(BufferedImage bufferedImage, int n, int n2, int n3, int n4, Color color) {
        int n5 = 80;
        int n6 = color.getRGB();
        int n7 = n6 & 0xFF;
        int n8 = n6 >> 8 & 0xFF;
        int n9 = n6 >> 16 & 0xFF;
        try {
            int n10 = 0;
            block2: while (true) {
                if (n10 >= n3) {
                    return false;
                }
                int n11 = 0;
                while (true) {
                    if (n11 >= n4) {
                        ++n10;
                        continue block2;
                    }
                    int n12 = bufferedImage.getRGB(n + n10, n2 - n11);
                    int n13 = n12 & 0xFF;
                    int n14 = n12 >> 8 & 0xFF;
                    int n15 = n12 >> 16 & 0xFF;
                    if (Math.abs(n13 - n7) < 80) return true;
                    if (Math.abs(n14 - n8) < 80) return true;
                    if (Math.abs(n15 - n9) < 80) {
                        return true;
                    }
                    ++n11;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }
}

