/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.SourceInfo;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.KmlHandler;
import tim.prune.load.xml.XmlHandler;

public class XmlFileLoader
extends DefaultHandler
implements Runnable {
    private File _file = null;
    private App _app = null;
    private XmlHandler _handler = null;
    private String _unknownType = null;

    public XmlFileLoader(App app) {
        this._app = app;
    }

    public void reset() {
        this._handler = null;
        this._unknownType = null;
    }

    public void openFile(File file) {
        this._file = file;
        this.reset();
        new Thread(this).start();
    }

    @Override
    public void run() {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(this._file);
            bl = this.parseXmlStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            if (this._handler == null) {
                this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.unknownxml")) + " " + this._unknownType);
            } else {
                SourceInfo.FILE_TYPE fILE_TYPE = this._handler instanceof GpxHandler ? SourceInfo.FILE_TYPE.GPX : SourceInfo.FILE_TYPE.KML;
                SourceInfo sourceInfo = new SourceInfo(this._file, fILE_TYPE);
                sourceInfo.setFileTitle(this._handler.getFileTitle());
                this._app.informDataLoaded(this._handler.getFieldArray(), this._handler.getDataArray(), null, sourceInfo, this._handler.getTrackNameList(), new MediaLinkInfo(this._handler.getLinkArray()));
            }
        }
    }

    public boolean parseXmlStream(InputStream inputStream) {
        Object object;
        boolean bl = false;
        try {
            object = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            object.setContentHandler(this);
            object.parse(new InputSource(inputStream));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            try {
                object = SAXParserFactory.newInstance().newSAXParser();
                ((SAXParser)object).parse(inputStream, (DefaultHandler)this);
                bl = true;
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.othererror")) + " " + exception.getMessage());
            }
        }
        return bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._handler == null) {
            if (string3.equals("kml")) {
                this._handler = new KmlHandler();
            } else if (string3.equals("gpx")) {
                this._handler = new GpxHandler();
            } else if (this._unknownType == null && !string3.equals("")) {
                this._unknownType = string3;
            }
        } else {
            this._handler.startElement(string, string2, string3, attributes);
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._handler != null) {
            this._handler.characters(cArray, n, n2);
        }
        super.characters(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._handler != null) {
            this._handler.endElement(string, string2, string3);
        }
        super.endElement(string, string2, string3);
    }

    public XmlHandler getHandler() {
        return this._handler;
    }
}

