/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.InputStream;
import tim.prune.save.xml.ByteBuffer;
import tim.prune.save.xml.TagReceiver;

public class GpxSlicer {
    private TagReceiver _receiver = null;
    private static final char[] GPX_START = "<gpx".toCharArray();
    private static final char[] GPX_END = ">".toCharArray();
    private static final char[] TRKPT_START = "<trkpt".toCharArray();
    private static final char[] TRKPT_END = "/trkpt>".toCharArray();
    private static final char[] WPT_START = "<wpt".toCharArray();
    private static final char[] WPT_END = "/wpt>".toCharArray();
    private static final char[] RTEPT_START = "<rtept".toCharArray();
    private static final char[] RTEPT_END = "/rtept>".toCharArray();
    private static final char[] CDATA_START = "<![CDATA[".toCharArray();
    private static final char[] CDATA_END = "]]>".toCharArray();

    public GpxSlicer(TagReceiver tagReceiver) {
        this._receiver = tagReceiver;
    }

    public void slice(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer(200);
        ByteBuffer byteBuffer = new ByteBuffer();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = null;
        boolean bl3 = false;
        int n = 0;
        try {
            while ((n = inputStream.read()) >= 0) {
                byteBuffer.appendByte((byte)n);
                if (!(bl || bl2 || n != 62 && n != 10)) {
                    byteBuffer.clear();
                    continue;
                }
                if (stringBuffer != null) {
                    stringBuffer.append((char)n);
                }
                if (bl2) {
                    if (!byteBuffer.foundSequence(CDATA_END)) continue;
                    bl2 = false;
                    continue;
                }
                if (!bl) {
                    if (!bl3 && byteBuffer.foundSequence(GPX_START)) {
                        bl = true;
                        bl3 = true;
                        cArray = GPX_END;
                        if (stringBuffer != null && stringBuffer.toString().toLowerCase().indexOf("encoding=\"utf-8\"") > 0) {
                            byteBuffer.setEncodingUtf8();
                        }
                        stringBuffer = null;
                    } else if (n == 116) {
                        if (byteBuffer.foundSequence(TRKPT_START)) {
                            bl = true;
                            cArray = TRKPT_END;
                        } else if (byteBuffer.foundSequence(WPT_START)) {
                            bl = true;
                            cArray = WPT_END;
                        } else if (byteBuffer.foundSequence(RTEPT_START)) {
                            bl = true;
                            cArray = RTEPT_END;
                        }
                    }
                } else if (byteBuffer.foundSequence(cArray)) {
                    String string = byteBuffer.toString();
                    this._receiver.reportTag(string);
                    byteBuffer.clear();
                    bl = false;
                }
                if (!byteBuffer.foundSequence(CDATA_START)) continue;
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

