import type express from 'express';
import passport from 'passport';
import type { CacheProvider } from './inmemory-cache-provider';
export declare type CertCallback = (callback: (err: Error | null, cert?: string | string[]) => void) => void;
export interface AuthenticateOptions extends passport.AuthenticateOptions {
    additionalParams?: Record<string, any>;
}
export interface AuthorizeOptions extends AuthenticateOptions {
    samlFallback?: string;
}
export interface SamlConfig {
    callbackUrl?: string;
    path?: string;
    protocol?: string;
    host?: string;
    entryPoint?: string;
    issuer?: string;
    privateCert?: string;
    cert?: string | string[] | CertCallback;
    decryptionPvk?: string;
    signatureAlgorithm?: 'sha1' | 'sha256' | 'sha512';
    additionalParams?: any;
    additionalAuthorizeParams?: any;
    identifierFormat?: string;
    acceptedClockSkewMs?: number;
    attributeConsumingServiceIndex?: string;
    disableRequestedAuthnContext?: boolean;
    authnContext?: string;
    forceAuthn?: boolean;
    skipRequestCompression?: boolean;
    authnRequestBinding?: string;
    RACComparison?: 'exact' | 'minimum' | 'maximum' | 'better';
    providerName?: string;
    passive?: boolean;
    idpIssuer?: string;
    audience?: string;
    validateInResponseTo?: boolean;
    requestIdExpirationPeriodMs?: number;
    cacheProvider?: CacheProvider;
    name?: string;
    passReqToCallback?: boolean;
    logoutUrl?: string;
    additionalLogoutParams?: any;
    logoutCallbackUrl?: string;
}
export declare type Profile = {
    issuer?: string;
    sessionIndex?: string;
    nameID?: string;
    nameIDFormat?: string;
    nameQualifier?: string;
    spNameQualifier?: string;
    ID?: string;
    mail?: string;
    email?: string;
    getAssertionXml(): string;
    getAssertion(): Record<string, unknown>;
    getSamlResponseXml(): string;
} & {
    [attributeName: string]: unknown;
};
export declare type VerifiedCallback = (err: Error | null, user?: Record<string, unknown>, info?: Record<string, unknown>) => void;
export declare type VerifyWithRequest = (req: express.Request, profile: Profile, done: VerifiedCallback) => void;
export declare type VerifyWithoutRequest = (profile: Profile, done: VerifiedCallback) => void;
