/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

@ThreadSafe
public enum AwtRunnableQueue {
    INSTANCE;

    @GuardedBy(value="this")
    private boolean awtQueueStarted;
    @GuardedBy(value="this")
    private boolean awtRunnerQueued;
    @GuardedBy(value="this")
    private final LinkedList<Runnable> awtQueue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AwtRunnableQueue awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            this.awtQueueStarted = true;
        }
        this.queueAWTRunner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterIoTasks(Runnable runnable) {
        boolean bl = false;
        AwtRunnableQueue awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            if (this.awtQueueStarted && TaskManager.instance.countIoTasks() == 0 && this.awtQueue.isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            ThreadUtilities.runInDispatchThread(runnable);
            return;
        }
        awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            this.awtQueue.offer(runnable);
        }
        this.queueAWTRunner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAWTRunner(boolean bl) {
        if (bl) {
            ThreadUtilities.runInDispatchThreadAndWait(new RunRequestsInAWTThread());
        } else {
            AwtRunnableQueue awtRunnableQueue = this;
            synchronized (awtRunnableQueue) {
                if (this.awtQueue.isEmpty()) {
                    return;
                }
                if (!this.awtQueueStarted || this.awtRunnerQueued) {
                    return;
                }
                this.awtRunnerQueued = true;
            }
            EventQueue.invokeLater(new RunRequestsInAWTThread());
        }
    }

    private class RunRequestsInAWTThread
    implements Runnable {
        private RunRequestsInAWTThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable;
            AwtRunnableQueue awtRunnableQueue = AwtRunnableQueue.this;
            synchronized (awtRunnableQueue) {
                AwtRunnableQueue.this.awtRunnerQueued = false;
                runnable = AwtRunnableQueue.this.awtQueue.peek();
            }
            while (TaskManager.instance.countIoTasks() == 0 && runnable != null) {
                this.doAWTRequest(runnable);
                awtRunnableQueue = AwtRunnableQueue.this;
                synchronized (awtRunnableQueue) {
                    AwtRunnableQueue.this.awtQueue.poll();
                    runnable = AwtRunnableQueue.this.awtQueue.peek();
                }
            }
        }

        private void doAWTRequest(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception in AWT thread:");
                Log.log(9, this, throwable);
            }
        }
    }
}

