/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRule.class);
    private static final ConcurrentMap<String, Long> lastFailure = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, AtomicInteger> consecutiveFailures = new ConcurrentHashMap<String, AtomicInteger>();
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("remote-rule-pool-%d").setDaemon(true).build();
    protected static final List<Runnable> shutdownRoutines = new LinkedList<Runnable>();
    static final ExecutorService executor = Executors.newCachedThreadPool(threadFactory);
    protected final RemoteRuleConfig serviceConfiguration;
    protected final boolean inputLogging;
    private AnnotatedText annotatedText;
    protected final boolean filterMatches;
    protected final Language ruleLanguage;

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging, @Nullable String ruleId) {
        super(messages);
        this.serviceConfiguration = config;
        this.ruleLanguage = language;
        this.inputLogging = inputLogging;
        if (ruleId == null) {
            ruleId = this.getId();
        }
        this.filterMatches = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("filterMatches", "false"));
        lastFailure.putIfAbsent(ruleId, 0L);
        consecutiveFailures.putIfAbsent(ruleId, new AtomicInteger());
    }

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging) {
        this(language, messages, config, inputLogging, null);
    }

    public static void shutdown() {
        shutdownRoutines.forEach(Runnable::run);
    }

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences) {
        return this.run(sentences, null);
    }

    protected abstract RemoteRequest prepareRequest(List<AnalyzedSentence> var1, @Nullable Long var2);

    protected abstract Callable<RemoteRuleResult> executeRequest(RemoteRequest var1, long var2) throws TimeoutException;

    protected abstract RemoteRuleResult fallbackResults(RemoteRequest var1);

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences, @Nullable Long textSessionId) {
        if (sentences.isEmpty()) {
            return new FutureTask<RemoteRuleResult>(() -> new RemoteRuleResult(false, true, Collections.emptyList(), sentences));
        }
        return new FutureTask<RemoteRuleResult>(() -> {
            long failureInterval;
            long startTime = System.nanoTime();
            long characters = sentences.stream().mapToInt(sentence -> sentence.getText().length()).sum();
            String ruleId = this.getId();
            RemoteRequest req = this.prepareRequest(sentences, textSessionId);
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall() && (failureInterval = System.currentTimeMillis() - (Long)lastFailure.get(ruleId)) < this.serviceConfiguration.getDownMilliseconds()) {
                RemoteRuleMetrics.request(ruleId, 0, 0L, characters, RemoteRuleMetrics.RequestResult.DOWN);
                RemoteRuleResult result = this.fallbackResults(req);
                return result;
            }
            RemoteRuleMetrics.up(ruleId, true);
            for (int i = 0; i <= this.serviceConfiguration.getMaxRetries(); ++i) {
                long timeout = this.serviceConfiguration.getBaseTimeoutMilliseconds() + (long)Math.round((float)characters * this.serviceConfiguration.getTimeoutPerCharacterMilliseconds());
                Callable<RemoteRuleResult> task = this.executeRequest(req, timeout);
                Future<RemoteRuleResult> future = null;
                try {
                    Object filteredMatches;
                    future = executor.submit(task);
                    RemoteRuleResult result = timeout <= 0L ? future.get() : future.get(timeout, TimeUnit.MILLISECONDS);
                    future.cancel(true);
                    if (result.isRemote()) {
                        ((AtomicInteger)consecutiveFailures.get(ruleId)).set(0);
                        RemoteRuleMetrics.failures(ruleId, 0);
                    }
                    RemoteRuleMetrics.RequestResult requestResult = result.isRemote() ? RemoteRuleMetrics.RequestResult.SUCCESS : RemoteRuleMetrics.RequestResult.SKIPPED;
                    RemoteRuleMetrics.request(ruleId, i, System.nanoTime() - startTime, characters, requestResult);
                    if (this.filterMatches) {
                        filteredMatches = new ArrayList();
                        for (AnalyzedSentence sentence2 : sentences) {
                            List<RuleMatch> sentenceMatches = result.matchesForSentence(sentence2);
                            List<RuleMatch> filteredSentenceMatches = RemoteRuleFilters.filterMatches(this.ruleLanguage, sentence2, sentenceMatches);
                            filteredMatches.addAll(filteredSentenceMatches);
                        }
                        result = new RemoteRuleResult(result.isRemote(), result.isSuccess(), (List<RuleMatch>)filteredMatches, sentences);
                    }
                    filteredMatches = result;
                    return filteredMatches;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    RemoteRuleMetrics.RequestResult status;
                    if (e instanceof TimeoutException || e instanceof InterruptedException || e.getCause() != null && e.getCause() instanceof TimeoutException) {
                        status = RemoteRuleMetrics.RequestResult.TIMEOUT;
                        logger.warn("Timed out while fetching results for remote rule " + ruleId + ", tried " + (i + 1) + " times, timeout: " + timeout + "ms", (Throwable)e);
                    } else {
                        status = RemoteRuleMetrics.RequestResult.ERROR;
                        logger.warn("Error while fetching results for remote rule " + ruleId + ", tried " + (i + 1) + " times, timeout: " + timeout + "ms", (Throwable)e);
                    }
                    RemoteRuleMetrics.request(ruleId, i, System.nanoTime() - startTime, characters, status);
                    continue;
                }
                finally {
                    if (future != null) {
                        future.cancel(true);
                    }
                }
            }
            RemoteRuleMetrics.failures(ruleId, ((AtomicInteger)consecutiveFailures.get(ruleId)).incrementAndGet());
            logger.warn("Fetching results for remote rule " + ruleId + " failed.");
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall()) {
                lastFailure.put(ruleId, System.currentTimeMillis());
                logger.warn("Remote rule " + ruleId + " marked as DOWN.");
                RemoteRuleMetrics.downtime(ruleId, this.serviceConfiguration.getDownMilliseconds());
                RemoteRuleMetrics.up(ruleId, false);
            }
            RemoteRuleResult result = this.fallbackResults(req);
            return result;
        });
    }

    @Override
    public String getId() {
        return this.serviceConfiguration.getRuleId();
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        FutureTask<RemoteRuleResult> task = this.run(Collections.singletonList(sentence));
        task.run();
        try {
            return task.get().getMatches().toArray(new RuleMatch[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Fetching results for remote rule " + this.getId() + " failed.", (Throwable)e);
            return new RuleMatch[0];
        }
    }

    public RemoteRuleConfig getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    protected class RemoteRequest {
        protected RemoteRequest() {
        }
    }
}

