/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import dumonts.hunspell.bindings.HunspellLibrary;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bridj.NativeList;
import org.bridj.Pointer;
import org.languagetool.JLanguageTool;
import org.languagetool.broker.ResourceDataBroker;

public class Hunspell
implements Closeable {
    private final Pointer<HunspellLibrary.Hunhandle> handle;
    private final Charset charset;
    private static final Map<LanguageAndPath, Hunspell> map = new HashMap<LanguageAndPath, Hunspell>();

    public Hunspell(Path dictionary, Path affix) {
        try {
            Pointer aff = Pointer.pointerToCString((String)affix.toString());
            Pointer dic = Pointer.pointerToCString((String)dictionary.toString());
            this.handle = HunspellLibrary.Hunspell_create((Pointer)aff, (Pointer)dic);
            this.charset = Charset.forName(HunspellLibrary.Hunspell_get_dic_encoding(this.handle).getCString());
            if (this.handle == null) {
                throw new RuntimeException("Unable to create Hunspell instance");
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Could not create hunspell instance. Please note that LanguageTool supports only 64-bit platforms (Linux, Windows, Mac) and that it requires a 64-bit JVM (Java).", e);
        }
    }

    public static synchronized Hunspell getInstance(Path dictionary, Path affix) {
        LanguageAndPath key = new LanguageAndPath(dictionary, affix);
        Hunspell hunspell = map.get(key);
        if (hunspell != null) {
            return hunspell;
        }
        Hunspell newHunspell = new Hunspell(dictionary, affix);
        map.put(key, newHunspell);
        return newHunspell;
    }

    public static Hunspell forDictionaryInResources(String language, String resourcePath) {
        try {
            ResourceDataBroker broker = JLanguageTool.getDataBroker();
            InputStream dictionaryStream = broker.getAsStream(resourcePath + language + ".dic");
            InputStream affixStream = broker.getAsStream(resourcePath + language + ".aff");
            if (dictionaryStream == null || affixStream == null) {
                throw new RuntimeException("Could not find dictionary for language \"" + language + "\" in classpath");
            }
            Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
            Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
            Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
            return new Hunspell(dictionary, affix);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
        }
    }

    public static Hunspell forDictionaryInResources(String language) {
        return Hunspell.forDictionaryInResources(language, "");
    }

    public boolean spell(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        int result = HunspellLibrary.Hunspell_spell(this.handle, (Pointer)str);
        return result != 0;
    }

    public void add(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        HunspellLibrary.Hunspell_add(this.handle, (Pointer)str);
    }

    public List<String> suggest(String word) {
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        Pointer nativeSuggestionArray = Pointer.allocatePointerPointer(Byte.class);
        int suggestionCount = HunspellLibrary.Hunspell_suggest(this.handle, (Pointer)nativeSuggestionArray, (Pointer)str);
        if (suggestionCount == 0) {
            return new ArrayList<String>();
        }
        NativeList nativeSuggestionList = ((Pointer)nativeSuggestionArray.get()).validElements((long)suggestionCount).asList();
        List<String> suggestions = nativeSuggestionList.stream().map(p -> p.getStringAtOffset(0L, Pointer.StringType.C, this.charset)).collect(Collectors.toList());
        HunspellLibrary.Hunspell_free_list(this.handle, (Pointer)nativeSuggestionArray, (int)suggestionCount);
        return suggestions;
    }

    @Override
    public void close() {
        if (this.handle != null) {
            HunspellLibrary.Hunspell_destroy(this.handle);
        }
    }

    static class LanguageAndPath {
        private final Path dictionary;
        private final Path affix;

        LanguageAndPath(Path dictionary, Path affix) {
            this.dictionary = Objects.requireNonNull(dictionary);
            this.affix = Objects.requireNonNull(affix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageAndPath that = (LanguageAndPath)o;
            return Objects.equals(this.dictionary, that.dictionary) && Objects.equals(this.affix, that.affix);
        }

        public int hashCode() {
            return Objects.hash(this.dictionary, this.affix);
        }
    }
}

