/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.daten.DatenAbo;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.cellrenderer.CellRendererBase;
import mediathek.tool.table.MVTable;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellRendererAbo
extends CellRendererBase {
    private static final Logger logger = LogManager.getLogger(CellRendererAbo.class);
    private final Icon checkedIcon = IconFontSwing.buildIcon(FontAwesome.CHECK, 12.0f);
    private final Icon uncheckedIcon = IconFontSwing.buildIcon(FontAwesome.MINUS, 12.0f);

    public CellRendererAbo(MVSenderIconCache cache) {
        super(cache);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        this.setIcon(null);
        this.setHorizontalAlignment(10);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            int r = table.convertRowIndexToModel(row);
            int c = table.convertColumnIndexToModel(column);
            DatenAbo abo = Daten.getInstance().getListeAbo().getAboNr(r);
            boolean aboIstEingeschaltet = abo.aboIstEingeschaltet();
            switch (c) {
                case 0: 
                case 8: 
                case 9: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 1: {
                    this.setHorizontalAlignment(0);
                    this.setCheckedOrUncheckedIcon(aboIstEingeschaltet);
                    break;
                }
                case 3: {
                    if (!((MVTable)table).showSenderIcons()) break;
                    this.setSenderIcon((String)value, ((MVTable)table).useSmallSenderIcons);
                }
            }
            if (!aboIstEingeschaltet) {
                this.setBackgroundColor(this, isSelected);
            }
        }
        catch (Exception ex) {
            logger.error("Fehler 630365892", (Throwable)ex);
        }
        return this;
    }

    private void setBackgroundColor(Component c, boolean isSelected) {
        this.setFontItalic();
        if (isSelected) {
            c.setBackground(MVColor.ABO_AUSGESCHALTET_SEL.color);
        } else {
            c.setBackground(MVColor.ABO_AUSGESCHALTET.color);
        }
    }

    private void setFontItalic() {
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.setFont(this.getFont().deriveFont(2));
        }
    }

    private void setCheckedOrUncheckedIcon(boolean condition) {
        Icon icon = condition ? this.checkedIcon : this.uncheckedIcon;
        this.setIcon(icon);
    }
}

