/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Comparator;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.SimpleValidationMessage;

public interface ValidationMessage
extends Comparable<ValidationMessage> {
    public static final Comparator<ValidationMessage> COMPARATOR = new Comparator<ValidationMessage>(){

        @Override
        public int compare(ValidationMessage vm1, ValidationMessage vm2) {
            if (vm1 == vm2) {
                return 0;
            }
            if (vm1 == null) {
                return 1;
            }
            if (vm2 == null) {
                return -1;
            }
            return vm1.compareTo(vm2);
        }
    };

    public String getText();

    public Severity getSeverity();

    public Control getTarget();

    public static ValidationMessage error(Control target, String text) {
        return new SimpleValidationMessage(target, text, Severity.ERROR);
    }

    public static ValidationMessage warning(Control target, String text) {
        return new SimpleValidationMessage(target, text, Severity.WARNING);
    }

    public static ValidationMessage info(Control target, String text) {
        return new SimpleValidationMessage(target, text, Severity.INFO);
    }

    public static ValidationMessage ok(Control target, String text) {
        return new SimpleValidationMessage(target, text, Severity.OK);
    }

    public static ValidationMessage ok(Control target) {
        return new SimpleValidationMessage(target, "", Severity.OK);
    }

    @Override
    default public int compareTo(ValidationMessage msg) {
        return msg == null || this.getTarget() != msg.getTarget() ? -1 : this.getSeverity().compareTo(msg.getSeverity());
    }
}

